package com.kidoz.sdk.api.general.assets_handling;

import android.content.Context;

import com.kidoz.events.DeviceUtils;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import com.kidoz.sdk.api.ui_views.feed_view.FeedFamilyViewDialog;
import com.kidoz.sdk.api.ui_views.feed_view.FeedViewDialog;
import com.kidoz.sdk.api.ui_views.flexi_view.MovableView;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner1;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner2;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner3;
import com.kidoz.sdk.api.ui_views.panel_view.FamilyPanelView;
import com.kidoz.sdk.api.ui_views.panel_view.StandardPanelView;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.util.ArrayList;

/**
 * Created by RonyBrosh on 12/8/2015.
 */
public class AssetUtil
{
    private static final String TAG = AssetUtil.class.getSimpleName();

    // Available assets keys
    //PAnel View
    private static final String PANEL_ASSETS = "panel";
    private static final String PANEL_FAMILY_ASSETS = "panelFamily";
    //Banner view
    private static final String BANNER_1_ASSETS = "banner1";
    private static final String BANNER_2_ASSETS = "banner2";
    private static final String BANNER_3_ASSETS = "banner3";
    //Feed view
    private static final String FEED_ASSETS = "feed";
    private static final String FEED_FAMILY_ASSETS = "feedFamily";
    //Flexi view
    private static final String FLEXI_VIEW_ASSETS = "flexiView";
    //Flexi view
    private static final String INTERSTITIAL_ASSETS = "interstitial";

    private static final String VIDEO_UNIT_ASSETS = "videoUnit";

    // General asset keys
    private static final String IMAGE_URL = "imageURL";
    private static final String IMAGE_RATIO = "imageRatio";
    private static final String ANIMATION_KEY = "animationKey";
    private static final String TEXT = "text";
    private static final String COLOR = "color";

    public static boolean parseAssets(Context context, String dataResponse)
    {
        boolean result = false;
        if (context != null && dataResponse != null)
        {
            try
            {
                JSONObject rootObject = new JSONObject(dataResponse);
                if (rootObject != null)
                {
                    if (rootObject.has(BANNER_1_ASSETS) == true)
                    {
                        result = KidozBanner1.parseKidozBanner(context, rootObject.getJSONObject(BANNER_1_ASSETS));
                    }
                    else if (rootObject.has(BANNER_2_ASSETS) == true)
                    {
                        result = KidozBanner2.parseKidozBanner(context, rootObject.getJSONObject(BANNER_2_ASSETS));
                    }
                    else if (rootObject.has(BANNER_3_ASSETS) == true)
                    {
                        result = KidozBanner3.parseKidozBanner(context, rootObject.getJSONObject(BANNER_3_ASSETS));
                    }
                    else if (rootObject.has(FEED_ASSETS) == true)
                    {
                        result = FeedViewDialog.parseFeedData(context, rootObject.getJSONObject(FEED_ASSETS));
                    }
                    else if (rootObject.has(FEED_FAMILY_ASSETS) == true)
                    {
                        result = FeedFamilyViewDialog.parseFamilyFeed(context, rootObject.getJSONObject(FEED_FAMILY_ASSETS));
                    }
                    else if (rootObject.has(PANEL_ASSETS) == true)
                    {
                        result = StandardPanelView.parsePanelData(context, rootObject.getJSONObject(PANEL_ASSETS));
                    }
                    else if (rootObject.has(PANEL_FAMILY_ASSETS) == true)
                    {
                        result = FamilyPanelView.parseFamilyPanelData(context, rootObject.getJSONObject(PANEL_FAMILY_ASSETS));
                    }
                    else if (rootObject.has(FLEXI_VIEW_ASSETS) == true)
                    {
                        result = MovableView.parseFlexiViewData(context, rootObject.getJSONObject(FLEXI_VIEW_ASSETS));
                    }
                    else if (rootObject.has(INTERSTITIAL_ASSETS) == true)
                    {
                        result = StyleParser.parseInterstitialData(context, rootObject.getJSONObject(INTERSTITIAL_ASSETS));
                    }
                    else if (rootObject.has(VIDEO_UNIT_ASSETS) == true)
                    {
                        result = StyleParser.parseVideoUnit(context, rootObject.getJSONObject(VIDEO_UNIT_ASSETS));
                    }
                }
            }
            catch (Exception ex)
            {
                if (ex != null)
                {
                    SDKLogger.printErrorLog(TAG, "Error when trying to parse assets: " + ex.getMessage());
                }
            }
        }
        return result;
    }

    private static String createAssetFileName(String assetURL)
    {
        String result = null;
        if (assetURL != null)
        {
            result = assetURL.substring(assetURL.lastIndexOf("/") + 1, assetURL.length());
        }
        return result;
    }

    public static boolean createAssetFile(Context context, String assetURL)
    {
        boolean result = true;
        if (assetURL != null)
        {
            // 1. Extract the asset file name
            String fileName = createAssetFileName(assetURL);
            File storageLocation = DeviceUtils.getInnerStoragePathIfPosible(context);
            File newFile = new File(storageLocation, fileName);
            if (newFile.exists() == false)
            {
                result = BaseConnectionClient.downloadAndSaveFile(assetURL, newFile);
            }
        }
        return result;
    }

    public static void deleteAssetFile(Context context, String assetURL)
    {
        if (assetURL != null)
        {
            // 1. Extract the asset file name
            String fileName = createAssetFileName(assetURL);
            File storageLocation = DeviceUtils.getInnerStoragePathIfPosible(context);
            File fileToDelete = new File(storageLocation, fileName);
            if (fileToDelete != null && fileToDelete.exists() == true)
            {
                fileToDelete.delete();
            }
        }
    }

    public static File getAssetFile(Context context, String assetURL)
    {
        File result = null;
        try
        {
            if (assetURL != null)
            {
                // 1. Extract the asset file name
                String fileName = createAssetFileName(assetURL);
                File storageLocation = DeviceUtils.getInnerStoragePathIfPosible(context);
                result = new File(storageLocation, fileName);
            }
        }
        catch (Exception ex)
        {

        }
        return result;
    }

    /**
     * Prepare and download assets
     */
    public static boolean loadAsset(Context context, JSONObject oldProperties, JSONObject newProperties, String assetKey) throws JSONException
    {
        boolean result = false;
        //String newAssetUrl = newProperties.optString(assetKey);
        ArrayList<String> imgList = generateAssetFileImageList(newProperties, assetKey);
        if (imgList.isEmpty() == false)
        {
            for (int i = 0; i < imgList.size(); i++)
            {
                if (oldProperties != null)
                {
                    result = true;
                    String oldAssetURL = oldProperties.optString(assetKey);
                    if (oldAssetURL == null || oldAssetURL.equals(imgList.get(i)) == false || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false || AssetUtil.getAssetFile(context, oldAssetURL).length() == 0)
                    {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, imgList.get(i));
                    }
                }
                else
                {
                    result = AssetUtil.createAssetFile(context, imgList.get(i));
                }

                if (result == true)
                {
                    newProperties.put(assetKey, imgList.get(i));
                    break;
                }
            }
        }
        return result;
    }

    /**
     * Generate valid asset files list
     */
    public static ArrayList<String> generateAssetFileImageList(JSONObject jsonObject, String key)
    {
        ArrayList<String> list = new ArrayList<String>();
        String link = jsonObject.optString(key);
        if (jsonObject.has(key + "Arr"))
        { // Check if multiple files exists
            JSONArray jsonArray = jsonObject.optJSONArray(key + "Arr");
            if (jsonArray != null && jsonArray.length() > 0)
            {
                if (link != null)
                {
                    // Remove suffix
                    String stripedLink = link.substring(0, link.lastIndexOf(".") + 1);
                    for (int i = 0; i < jsonArray.length(); i++)
                    {
                        String suffix = jsonArray.optString(i, "");
                        // Check if has webp file and check compatibility
                        if (suffix.equals("webp") || suffix.equals("webP") || suffix.equals("WEBP"))
                        {
                            //If compatible download the webp anim
                            if (Utils.isWebViewSupportWebP())
                            {
                                list.add(stripedLink + suffix);
                            }
                        }
                        else
                        {
                            //Otherwise download next file in array
                            list.add(stripedLink + suffix);
                        }
                    }
                }
            }
        }
        //No array exists or something went wrong , download the file from original link
        if (list.isEmpty())
        {
            list.add(link);
        }
        return list;
    }
}
