package com.kidoz.events;

import android.net.ConnectivityManager;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

/**
 * Created by orikam on 8/24/15.
 */
public class EventParameters
{
    public static final String TAG = EventParameters.class.getSimpleName();

    // General event related
    public static final String EVENT_TYPE = "EventType";
    public static final String EVENT_TYPE_DEVICE_INFO = "Device Info";
    public static final String INT_FIELD = "intField";
    public static final String INT_FIELD_2 = "intField2";

    // General device related
    public static final String USER_REFFERAL = "UserRefferal";
    public static final String KIDOZ_APP_PACKAGE_NAME = "PackageID";
    public static final String APP_VERSION = "AppVersion";
    public static final String DEVICE_TYPE = "DeviceType";
    public static final String DEVICE_BRAND = "DeviceBrand";
    public static final String DEVICE_MODEL = "DeviceModel";
    public static final String SCREEN_SIZE = "ScreenSize";
    public static final String DPI_FACTOR = "DpiFactor";
    public static final String SCREEN_WIDTH = "ScreenW";
    public static final String SCREEN_HEIGHT = "ScreenH";
    public static final String OS_TYPE = "OsType";
    public static final String OS_VERSION = "OsVersion";
    public static final String TIME_ZONE = "TimeZone";
    public static final String COUNTRY = "Country";
    public static final String DEVICE_LANGUAGE = "DeviceLang";
    public static final String DEVICE_HASH = "DeviceHash";
    public static final String APP_ID = "AppID";
    public static final String DEVELOPER_ID = "DeveloperID";
    public static final String ACTUAL_SDK_VERSION = "SdkVersion";
    public static final String SDK_EXTENSION_TYPE = "ExtensionType";

    // Screen type
    public static final String SCREEN_TYPE = "ScreenType";

    // Connect type
    public static final String CONNECTION_TYPE_WIFI = "W";
    public static final String CONNECTION_TYPE_CELLULAR = "C";

    // General event related

    public static final String ITEM_ID = "ItemID";
    public static final String LOG_TIME_UTC = "LogTimeUTC";
    public static final String LOG_TIME_LOCAL = "LogTimeLocal";
    public static final String DURATION = "Duration";
    public static final String ACTIVITY_NAME = "ActivityName";
    public static final String ACTIVITY_ID = "ActivityID";
    public static final String SESSION_ID = "SessionID";
    public static final String ADVERTISER_ID = "AdvertiserID";         //"advertiser_id";
    public static final String ITEM_INDEX = "ItemIndex";

    // Screen names
    public static final String PANEL_VIEW = "Panel View";
    public static final String INTERSTITIAL_VIEW = "Interstitial View";
    public static final String FEED_VIEW = "Feed View";

    // Category
    public static final String CATEGORY = "Category";
    public static final String CATEGORY_SDK = "SDK";
    public static final String CATEGORY_SESSION = "Session";
    public static final String CATEGORY_ACTIVITY = "Activity";
    public static final String CATEGORY_CONTENT_CLICK = "Content Click";
    public static final String CATEGORY_VIDEO_PLAYER = "Video Player";
    public static final String CATEGORY_WEB_PLAYER = "Web Player";
    public static final String CATEGORY_SPONSORED_CONTENT = "Sponsored Content";
    public static final String CATEGORY_PARENTAL_LOCK = "Parental Lock";

    // Action
    public static final String ACTION = "Action";
    public static final String ACTION_SDK_INIT = "SDK Init";
    public static final String ACTION_SDK_ALREADY_INIT = "SDK Already Initiated";
    public static final String ACTION_CLICK = "Click";
    public static final String ACTION_SESSION_START = "Session Start";
    public static final String ACTION_ACTIVITY_START = "Activity Start";
    public static final String ACTION_ACTIVITY_END = "Activity End";
    public static final String ACTION_VIDEO_VIEW = "Video Player View";
    public static final String ACTION_GAME_VIEW = "Online Games Player View";
    public static final String ACTION_EXTERNAL_LINK_VIEW = "Web External Link View";
    public static final String ACTION_WEBSITE_VIEW = "Website View";
    public static final String ACTION_HTML_VIEW = "Html View";
    public static final String ACTION_FEED_ITEM_CLICK = "Feed Click";
    public static final String ACTION_CONVERSION = "Conversion";


    public static final String ACTION_IMPRESSION = "Impression";
    public static final String ACTION_IMPRESSION_SERVED = "Impression Served";
    public static final String ACTION_PROMOTED_APP_INSTALL_COMPLETE = "Install Completed";
    public static final String ACTION_PARENTAL_DIALOG_DISMISS = "Dialog Dismiss";
    public static final String ACTION_PARENTAL_DIALOG_SHOW = "Dialog Show";
    public static final String ACTION_PARENTAL_CORRECT_PASSWORD = "Correct Password";
    public static final String ACTION_PARENTAL_INCORRECT_PASSWORD = "Incorrect Password";
    public static final String ACTION_WIDGET_VIEW = "Widget View";
    public static final String ACTION_BUTTON_VIEW = "Button View";
    public static final String ACTION_OPEN_DIALOG = "Open Dialog";
    public static final String ACTION_CLOSE_DIALOG = "Close Dialog";

    // Label
    public static final String LABEL = "Label";
    public static final String LABEL_EXIT_BUTTON = "Exit";
    public static final String LABEL_CLOSE_BUTTON = "Close";
    public static final String LABEL_CONTENT_TYPE_GOOGLE_PLAY_APP = "Google Play App";
    public static final String LABEL_CONTENT_TYPE_EXTERNAL_URL = "External Url";
    public static final String LABEL_CONTENT_TYPE_ONLINE_GAME = "Online Game";
    public static final String LABEL_CONTENT_TYPE_URL = "URL";
    public static final String LABEL_CONTENT_TYPE_YOUTUBE = "Youtube";
    public static final String LABEL_PARENTAL_LOCK_BUTTON = "Lock Button";
    public static final String LABEL_FEED_BUTTON_VIEW = "Feed Button View";
    public static final String LABEL_VIDEO_UNIT_BUTTON_VIEW = "Video Unit Button View";
    public static final String LABEL_BANNER_VIEW = "Banner View";
    public static final String LABEL_FLEXI_VIEW = "Flexi View";
    public static final String LABEL_PANEL_BUTTON_VIEW = "Panel Button View";
    public static final String LABEL_VIEW_OPEN_TYPE = "Open Type";
    public static final String LABEL_PANEL_VIEW_TYPE = "Panel Type";
    public static final String LABEL_WEB = "Web";

    // Widget types and styles
    public static final String WIDGET_TYPE = "WidgetType";
    public static final String STYLE_ID = "StyleId";

    //Values
    public static final String AUTOMATIC_OPEN = "0";
    public static final String MANUAL_OPEN = "1";

    public static String convertConnectionTypeToString(int connectionType)
    {
        String result = CONNECTION_TYPE_WIFI;
        switch (connectionType)
        {
            case ConnectivityManager.TYPE_MOBILE:
            {
            }
            case ConnectivityManager.TYPE_MOBILE_DUN:
            {
            }
            case ConnectivityManager.TYPE_MOBILE_HIPRI:
            {
            }
            case ConnectivityManager.TYPE_MOBILE_MMS:
            {
            }
            case ConnectivityManager.TYPE_MOBILE_SUPL:
            {
                result = CONNECTION_TYPE_CELLULAR;
                break;
            }
        }
        return result;
    }

    public static String getCurrentTimezoneOffset()
    {
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
        String offset = String.format(Locale.getDefault(), "%02d", Math.abs(offsetInMillis / 3600000));
        offset = (offsetInMillis >= 0 ? "+" : "-") + offset;
        return offset;
    }
}
