/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.RawRes;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import pl.droidsonroids.gif.GifDrawable;

final class GifViewUtils {
    static final String ANDROID_NS = "http://schemas.android.com/apk/res/android";
    static final List<String> SUPPORTED_RESOURCE_TYPE_NAMES = Arrays.asList("raw", "drawable", "mipmap");

    private GifViewUtils() {
    }

    static InitResult initImageView(ImageView view, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs != null && !view.isInEditMode()) {
            int sourceResId = GifViewUtils.getResourceId(view, attrs, true);
            int backgroundResId = GifViewUtils.getResourceId(view, attrs, false);
            boolean freezesAnimation = GifViewUtils.isFreezingAnimation((View)view, attrs, defStyleAttr, defStyleRes);
            return new InitResult(sourceResId, backgroundResId, freezesAnimation);
        }
        return new InitResult(0, 0, false);
    }

    private static int getResourceId(ImageView view, AttributeSet attrs, boolean isSrc) {
        String resourceTypeName;
        int resId = attrs.getAttributeResourceValue(ANDROID_NS, isSrc ? "src" : "background", 0);
        if (resId > 0 && SUPPORTED_RESOURCE_TYPE_NAMES.contains(resourceTypeName = view.getResources().getResourceTypeName(resId)) && !GifViewUtils.setResource(view, isSrc, resId)) {
            return resId;
        }
        return 0;
    }

    static boolean setResource(ImageView view, boolean isSrc, int resId) {
        Resources res = view.getResources();
        if (res != null) {
            try {
                GifDrawable d = new GifDrawable(res, resId);
                if (isSrc) {
                    view.setImageDrawable((Drawable)d);
                } else if (Build.VERSION.SDK_INT >= 16) {
                    view.setBackground((Drawable)d);
                } else {
                    view.setBackgroundDrawable((Drawable)d);
                }
                return true;
            }
            catch (Resources.NotFoundException | IOException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    static boolean isFreezingAnimation(View view, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        boolean freezesAnimation = false;
        return freezesAnimation;
    }

    static boolean setGifImageUri(ImageView imageView, Uri uri) {
        if (uri != null) {
            try {
                imageView.setImageDrawable((Drawable)new GifDrawable(imageView.getContext().getContentResolver(), uri));
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static float getDensityScale(@NonNull Resources res, @DrawableRes @RawRes int id) {
        TypedValue value = new TypedValue();
        res.getValue(id, value, true);
        int resourceDensity = value.density;
        int density = resourceDensity == 0 ? 160 : (resourceDensity != 65535 ? resourceDensity : 0);
        int targetDensity = res.getDisplayMetrics().densityDpi;
        if (density > 0 && targetDensity > 0) {
            return (float)targetDensity / (float)density;
        }
        return 1.0f;
    }

    static class InitResult {
        final int mSourceResId;
        final int mBackgroundResId;
        final boolean mFreezesAnimation;

        InitResult(int sourceResId, int backgroundResId, boolean freezesAnimation) {
            this.mSourceResId = sourceResId;
            this.mBackgroundResId = backgroundResId;
            this.mFreezesAnimation = freezesAnimation;
        }
    }
}

