/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.interstitial;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.interstitial.IntrstWrapper;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class KidozAdActivity
extends Activity {
    public static final String STYLE_ID_KEY = "styleId";
    protected HtmlViewWrapper mWebView;
    protected RelativeLayout mInnerContainer;
    protected int mBgColor = -16777216;
    private boolean mIsImmersive = true;
    private boolean mIsFirstLaunch = true;
    private Utils.StaticHandler mHandler;
    private IntrstWrapper.InnerHelperInterface mInnerHelperInterface;

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (Build.VERSION.SDK_INT < 18) {
            this.mWebView.setVisibility(4);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    KidozAdActivity.this.mWebView.setVisibility(0);
                    KidozAdActivity.this.mWebView.bringToFront();
                }
            }, 500L);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.setTheme(0x1030011);
        this.setRequestedOrientation(4);
        this.getWindow().setFlags(0x1000000, 0x1000000);
        this.mHandler = new Utils.StaticHandler(this.getMainLooper());
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mInnerHelperInterface = IntrstWrapper.initInstance((Context)this).getHelperInterface();
            String styleId = intent.getStringExtra(STYLE_ID_KEY);
            this.mWebView = HtmlManager.getIntrstDefaultHtmlView((Context)this);
            if (this.mWebView != null) {
                this.mWebView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                this.mWebView.setStyleID(styleId);
                this.mWebView.setInFocusActivityContext((Context)this);
                if (Build.VERSION.SDK_INT < 16) {
                    this.mWebView.setLayerType(0, null);
                }
                this.mInnerContainer = new RelativeLayout((Context)this);
                this.mInnerContainer.setBackgroundColor(this.mBgColor);
                this.mInnerContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
                this.setContentView((View)this.mInnerContainer, new ViewGroup.LayoutParams(-1, -1));
                EventManager.getInstance((Context)this).logEvent((Context)this, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), styleId, EventManager.LOG_CRITICAL_LEVEL, "Sponsored Content", "Widget View", "Interstitial View");
                if (this.mInnerHelperInterface != null) {
                    this.mInnerHelperInterface.onAdOpen();
                }
            } else {
                this.finish();
            }
        } else {
            this.finish();
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus && this.mIsImmersive) {
            this.applyImmersiveMode();
        }
    }

    private void applyImmersiveMode() {
        int flags = 2;
        if (Build.VERSION.SDK_INT >= 16) {
            flags = 1798;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            flags = 5894;
        }
        this.getWindow().getDecorView().setSystemUiVisibility(flags);
    }

    protected void onResume() {
        super.onResume();
        if (this.mWebView != null) {
            if (this.mIsFirstLaunch) {
                this.mIsFirstLaunch = false;
                this.mWebView.startVastAd();
            } else {
                this.mWebView.resumeVastAd();
            }
            if (Build.VERSION.SDK_INT < 18) {
                this.mWebView.setVisibility(4);
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        KidozAdActivity.this.mWebView.setVisibility(0);
                        KidozAdActivity.this.mWebView.bringToFront();
                    }
                }, 500L);
            } else {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        KidozAdActivity.this.mWebView.bringToFront();
                    }
                }, 200L);
            }
        }
    }

    protected void onPause() {
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.mWebView != null) {
            this.mWebView.pauseVastAd();
        }
        super.onPause();
    }

    protected void onDestroy() {
        if (this.mWebView != null) {
            this.mWebView.stopVastAd();
        }
        if (this.mInnerHelperInterface != null) {
            this.mInnerHelperInterface.onAdClose();
        }
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        super.onDestroy();
    }

    @Subscribe
    public void onHandleEvent(WidgetEventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INTERSTITIAL_AD_CLOSE) {
            this.mHandler.removeCallbacksAndMessages(null);
            if (!this.isFinishing()) {
                this.finish();
            }
        }
    }
}

