/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.html_view;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.kidoz.events.DeviceUtils;
import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.CookieManager;
import com.kidoz.sdk.api.general.utils.OnSwipeTouchListener;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlFiveWebView;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import java.util.LinkedHashMap;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HtmlViewWrapper
extends RelativeLayout {
    private static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.35f;
    private static final String JS_FUNC_ON_FOCUS_ON_KEY = "kidozOnFocusOn";
    private static final String JS_FUNC_ON_PREPARE_FOCUS_ON_KEY = "kidozOnPrepapreFocusOn";
    private static final String JS_FUNC_ON_FOCUS_OFF_KEY = "kidozOnFocusOff";
    private static final String JS_FUNC_ON_MAXIMIZE_KEY = "kidozOnMaximize";
    private static final String JS_FUNC_ON_MINIMIZE_KEY = "kidozOnMinimize";
    private static final int ON_LOAD_FINISHED = 0;
    private static final int ON_LOAD_STARTED = 1;
    private static final int ON_VIEW_READY = 2;
    private static final int ON_CLOSE = 3;
    private static final int ON_RECEIVED_ERROR = 4;
    private static final int ON_NOTIFY_VAST_AD_READY = 5;
    private static final String TAG = HtmlViewWrapper.class.getSimpleName();
    private HtmlFiveWebView mWebView;
    private HtmlAndroidJavaScriptInterface mHtmlAndroidWebInterface;
    private String mStyleId;
    private String mWidgetType = "";
    private boolean mAllowClickHandling = true;
    private ContentItem mContentItem;
    private String mHtmlPageUrl;
    private IOnHtmlWebViewInterface mHtmlWeViewListener;
    private JSONObject mCustomFunctionsMap = new JSONObject();
    private boolean mShowMaximize = false;
    private boolean mIsShowClose = true;
    private boolean mIsAvoidAutoImpression = false;
    protected LoadingProgressView mLoadingProgressView;
    private Utils.StaticHandler mEventHandler;
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    private Utils.StaticHandler mExecutionHandler = new Utils.StaticHandler(Looper.getMainLooper());
    public Context mInFocusActivityContext;

    public HtmlViewWrapper(Context context, boolean clearCache) {
        super(context);
        this.initView(clearCache);
    }

    public void setWidgetType(String widgetType) {
        this.mWidgetType = widgetType;
    }

    public void setStyleID(String styleID) {
        this.mStyleId = styleID;
    }

    public void setData(ContentItem contentItem) {
        this.mContentItem = contentItem;
        this.mHtmlPageUrl = contentItem.getData();
        this.setAndApplyExternalProperties(contentItem.getExtraParameters());
    }

    public void setInFocusActivityContext(Context context) {
        this.mInFocusActivityContext = context;
    }

    private void setAndApplyExternalProperties(JSONObject jsonObject) {
        if (jsonObject != null) {
            JSONObject mwbViewPropertiesMap;
            if (jsonObject.has("webview_properties") && !jsonObject.isNull("webview_properties") && (mwbViewPropertiesMap = jsonObject.optJSONObject("webview_properties")) != null) {
                this.mWebView.applyProperties(mwbViewPropertiesMap);
            }
            if (jsonObject.has("customFunctions") && !jsonObject.isNull("customFunctions")) {
                this.mCustomFunctionsMap = jsonObject.optJSONObject("customFunctions");
            }
            this.mShowMaximize = jsonObject.optBoolean("showMaximize", false);
            this.mIsShowClose = jsonObject.optBoolean("showClose", false);
            this.mIsAvoidAutoImpression = jsonObject.optBoolean("avoidAutoImpression", false);
        }
    }

    public void loadHtml() {
        this.loadHtml(this.mHtmlPageUrl);
    }

    public void loadHtml(String link) {
        this.mHtmlPageUrl = link;
        if (this.mHtmlPageUrl != null) {
            String[] tempVal;
            int index;
            String sub;
            String[] res;
            StringBuilder stringBuilder = new StringBuilder(this.mHtmlPageUrl);
            if (!this.mHtmlPageUrl.contains("?")) {
                stringBuilder.append("?");
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append("publisher_id=" + KidozSDK.getPublisherID());
            stringBuilder.append("&package_id=" + this.getContext().getPackageName());
            stringBuilder.append("&sdk_version=3");
            stringBuilder.append("&os_version=" + Build.VERSION.SDK_INT);
            stringBuilder.append("&os_type=android");
            String webviewVersion = "w";
            String useragent = Utils.getDefaultUserAgent();
            if (useragent != null && useragent.contains("Chrome") && (res = (sub = useragent.substring(index = useragent.indexOf("Chrome"), useragent.length())).split(" ")) != null && res.length > 0 && (tempVal = res[0].split("/")) != null && tempVal.length > 1) {
                webviewVersion = "c_" + tempVal[1];
            }
            stringBuilder.append("&webview_version=" + webviewVersion);
            stringBuilder.append("&device_hash=" + Utils.generateUniqeDeviceID(this.getContext().getPackageName(), KidozSDK.getPublisherID()));
            stringBuilder.append("&widget_type=" + this.mWidgetType);
            stringBuilder.append("&auth_token=" + KidozSDK.getAuthToken());
            stringBuilder.append("&gid=" + DeviceUtils.getGoogleAdvertisingID(this.getContext()));
            this.mWebView.loadUrl(stringBuilder.toString());
        }
    }

    private void initView(boolean clearCache) {
        this.initHandler();
        this.initWebView(clearCache);
        this.initProgressLoadingView();
    }

    private void initHandler() {
        this.mEventHandler = new Utils.StaticHandler(Looper.getMainLooper()){

            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 1: {
                        if (HtmlViewWrapper.this.mHtmlWeViewListener == null) break;
                        HtmlViewWrapper.this.mHtmlWeViewListener.onHtmlStartLoading();
                        break;
                    }
                    case 0: {
                        if (HtmlViewWrapper.this.mHtmlWeViewListener == null) break;
                        HtmlViewWrapper.this.mHtmlWeViewListener.onHtmlFinishedLoading();
                        break;
                    }
                    case 2: {
                        if (HtmlViewWrapper.this.mHtmlWeViewListener == null) break;
                        HtmlViewWrapper.this.mHtmlWeViewListener.onViewReady();
                        break;
                    }
                    case 3: {
                        if (HtmlViewWrapper.this.mHtmlWeViewListener != null) {
                            HtmlViewWrapper.this.mHtmlWeViewListener.onClose();
                        }
                        WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
                        EventBus.getDefault().post((Object)eventMessage);
                        break;
                    }
                    case 4: {
                        if (HtmlViewWrapper.this.mHtmlWeViewListener == null) break;
                        HtmlViewWrapper.this.mHtmlWeViewListener.onErrorReceived();
                        break;
                    }
                    case 5: {
                        if (HtmlViewWrapper.this.mHtmlWeViewListener == null) break;
                        if (msg.arg1 == 1) {
                            HtmlViewWrapper.this.mHtmlWeViewListener.onNotifyVastReady(true);
                            break;
                        }
                        HtmlViewWrapper.this.mHtmlWeViewListener.onNotifyVastReady(false);
                    }
                }
            }
        };
    }

    private void initWebView(boolean clearCache) {
        this.mWebView = new HtmlFiveWebView(this.getContext());
        if (clearCache) {
            this.clearCache();
        }
        this.mHtmlAndroidWebInterface = this.initJavaScriptInterface();
        this.mWebView.addJavascriptInterface(this.mHtmlAndroidWebInterface, "KidozAndroid");
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                HtmlViewWrapper.this.mEventHandler.sendEmptyMessage(1);
            }

            public void onPageFinished(WebView view, String url) {
                HtmlViewWrapper.this.setVisibility(0);
                super.onPageFinished(view, url);
                HtmlViewWrapper.this.mEventHandler.sendEmptyMessage(0);
            }

            public boolean shouldOverrideUrlLoading(WebView view, final String url) {
                boolean isForwardingToGoogle = false;
                if (url.contains("market://") || url.contains("play.google.com")) {
                    isForwardingToGoogle = true;
                } else if (!(url.startsWith("https://m.youtube") || url.startsWith("http://m.youtube") || url.startsWith("https://www.youtube") || url.startsWith("http://www.youtube"))) {
                    isForwardingToGoogle = true;
                }
                if (isForwardingToGoogle) {
                    Context context = HtmlViewWrapper.this.mInFocusActivityContext;
                    if (context == null) {
                        context = HtmlViewWrapper.this.getContext();
                    }
                    ContentExecutionHandler.checkForParentalLock(context, new ContentExecutionHandler.IOnParentalLockStatusListener(){

                        @Override
                        public void onLockActive(boolean isPasswordCorrect) {
                            if (isPasswordCorrect) {
                                HtmlViewWrapper.this.openGooglePlayStore(url);
                            } else {
                                EventManager.getInstance(HtmlViewWrapper.this.getContext()).logEvent(HtmlViewWrapper.this.getContext(), HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mStyleId, EventManager.LOG_NORMAL_LEVEL, null, "Sponsored Content", "Incorrect Password", HtmlViewWrapper.this.mContentItem.getId());
                            }
                        }

                        @Override
                        public void onLockNotActive() {
                            HtmlViewWrapper.this.openGooglePlayStore(url);
                        }
                    });
                }
                return true;
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
            }
        });
        this.addView((View)this.mWebView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
    }

    private void openGooglePlayStore(String url) {
        try {
            if (this.mContentItem != null && this.mContentItem.getContentType() != null) {
                switch (this.mContentItem.getContentType()) {
                    case PROMOTED_PLAY_APPLICATION: {
                        this.openGooglePlayInBackground(url);
                        break;
                    }
                    case HTML: {
                        if (this.mContentItem.getJSONitem() != null) {
                            try {
                                JSONArray jsonArray = this.mContentItem.getJSONitem();
                                JSONObject extraJsonObject = jsonArray.getJSONObject(11);
                                if (extraJsonObject.optBoolean("cpi_play", false)) {
                                    this.openGooglePlayInBackground(url);
                                    break;
                                }
                                this.openGooglePlayInForground(url);
                            }
                            catch (Exception ex) {
                                this.openGooglePlayInForground(url);
                            }
                            break;
                        }
                        this.openGooglePlayInForground(url);
                        break;
                    }
                    default: {
                        this.openGooglePlayInForground(url);
                        break;
                    }
                }
            } else {
                this.openGooglePlayInForground(url);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to open google play for promoted app: \n" + ex.getMessage());
        }
    }

    private void openGooglePlayInForground(String url) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)url));
        if (this.mInFocusActivityContext != null) {
            this.mHtmlWeViewListener.onClose();
            this.mInFocusActivityContext.startActivity(intent);
        }
    }

    private void openGooglePlayInBackground(String url) {
        Context context = this.mInFocusActivityContext;
        if (context == null) {
            context = this.getContext();
        }
        this.mHtmlWeViewListener.onClose();
        ContentItem contentItem = new ContentItem();
        contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
        contentItem.setData(url);
        contentItem.setId(this.mContentItem.getId());
        ContentExecutionHandler.handleContentItemClick(context, contentItem, this.mWidgetType, this.mStyleId, 0, false, null);
    }

    private void initProgressLoadingView() {
        this.mLoadingProgressView = new LoadingProgressView(this.getContext());
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((float)Math.min(point.x, point.y) * 0.35f);
        RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(size, size);
        prParams.addRule(13);
        this.addView(this.mLoadingProgressView, (ViewGroup.LayoutParams)prParams);
    }

    private HtmlAndroidJavaScriptInterface initJavaScriptInterface() {
        return new HtmlAndroidJavaScriptInterface(new AndroidJSLocalInterface(){

            @Override
            public void onViewReady() {
                HtmlViewWrapper.this.mEventHandler.sendEmptyMessage(2);
            }

            @Override
            public void onImpressionServed(final String item_id, final String item_name, final String ad_id, final String view_index) {
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        int positionIndexAsInteger = 0;
                        try {
                            positionIndexAsInteger = Integer.parseInt(view_index);
                        }
                        catch (Exception ex) {
                            SDKLogger.printErrorLog(TAG, "Error when trying to parse positionIndex: " + ex.getMessage());
                        }
                        EventManager.getInstance(HtmlViewWrapper.this.getContext()).logSponsoredContentImpressionEvent(HtmlViewWrapper.this.getContext(), HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mStyleId, "Impression", item_name, ad_id, item_id, positionIndexAsInteger);
                    }
                });
            }

            @Override
            public void simulateClick(final String json, final int positionIndex) {
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ContentItem item = null;
                        try {
                            JSONArray jsonArray = new JSONArray(json);
                            if (jsonArray != null && jsonArray.length() > 1) {
                                JSONArray keysArray = jsonArray.getJSONArray(0);
                                LinkedHashMap<String, Integer> keysMap = new LinkedHashMap<String, Integer>();
                                if (keysArray != null && keysArray.length() > 0) {
                                    for (int i = 0; i < keysArray.length(); ++i) {
                                        keysMap.put(keysArray.getString(i), i);
                                    }
                                }
                                if (!keysMap.isEmpty() && jsonArray.getJSONArray(1) != null) {
                                    item = new ContentItem(jsonArray.getJSONArray(1), keysMap);
                                }
                            }
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        if (item != null && HtmlViewWrapper.this.mAllowClickHandling) {
                            HtmlViewWrapper.this.mAllowClickHandling = false;
                            if (HtmlViewWrapper.this.mInFocusActivityContext != null) {
                                ContentExecutionHandler.handleContentItemClick(HtmlViewWrapper.this.mInFocusActivityContext, item, HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mStyleId, positionIndex, true, new ContentExecutionHandler.IOnHandleClickListener(){

                                    @Override
                                    public void onRestoreClick() {
                                        HtmlViewWrapper.this.mAllowClickHandling = true;
                                    }
                                });
                            }
                        }
                    }
                });
            }

            @Override
            public void onAboutClick() {
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        HtmlViewWrapper.this.startAboutKidozDialog();
                    }
                });
            }

            @Override
            public void onParentalClick() {
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        HtmlViewWrapper.this.startParentalLockDialog();
                    }
                });
            }

            @Override
            public void onCloseClick() {
                HtmlViewWrapper.this.mEventHandler.sendEmptyMessage(3);
            }

            @Override
            public void onMaximize() {
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (HtmlViewWrapper.this.mHtmlWeViewListener != null) {
                            HtmlViewWrapper.this.mHtmlWeViewListener.onOpenMaximized();
                        }
                    }
                });
            }

            @Override
            public void onInitWebViewWithProperties(final String properties) {
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HtmlViewWrapper.this.mWebView.applyProperties(new JSONObject(properties));
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                });
            }

            @Override
            public void onConversionServed(final String item_id, final String item_name, final String ad_id, final String view_index, final String rewardKey, final String rewardValue) {
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        int positionIndexAsInteger = 0;
                        int rewardKeyAsInteger = 0;
                        int rewardValueAsInteger = 0;
                        try {
                            positionIndexAsInteger = Integer.parseInt(view_index);
                        }
                        catch (Exception ex) {
                            SDKLogger.printErrorLog(TAG, "Error when trying to parse positionIndex: " + ex.getMessage());
                        }
                        try {
                            rewardKeyAsInteger = Integer.parseInt(rewardKey);
                        }
                        catch (Exception ex) {
                            SDKLogger.printErrorLog(TAG, "Error when trying to parse rewardKey: " + ex.getMessage());
                        }
                        try {
                            rewardValueAsInteger = Integer.parseInt(rewardValue);
                        }
                        catch (Exception ex) {
                            SDKLogger.printErrorLog(TAG, "Error when trying to parse rewardValue: " + ex.getMessage());
                        }
                        Event event = new Event();
                        EventManager.getInstance(HtmlViewWrapper.this.getContext()).logSponsoredConversionEvent(HtmlViewWrapper.this.getContext(), HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mStyleId, event, item_name, ad_id, item_id, positionIndexAsInteger, rewardKeyAsInteger, rewardValueAsInteger);
                    }
                });
            }

            @Override
            public void onStoreLocalParam(final String key, final String value, final String scope_type) {
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CookieManager.saveData(HtmlViewWrapper.this.getContext(), HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mHtmlPageUrl, key, value, StorageLife.valueOf(scope_type));
                    }
                });
            }

            @Override
            public void getLocalParam(String function, final String key) {
                final String value = CookieManager.loadData(HtmlViewWrapper.this.getContext(), HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mHtmlPageUrl, key);
                String defaultName = "kidozReturnedValue";
                if (function != null) {
                    defaultName = function;
                }
                final String finalDefaultName = defaultName;
                HtmlViewWrapper.this.mEventHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        HtmlViewWrapper.this.invokeJSfunction("javascript:" + finalDefaultName + "('" + key + "','" + value + "'  );");
                    }
                });
            }

            @Override
            public void getDonePlayback() {
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (HtmlViewWrapper.this.mHtmlWeViewListener != null) {
                            HtmlViewWrapper.this.mHtmlWeViewListener.onDonePlayBack();
                        }
                    }
                });
            }

            @Override
            public void getParentalLockStatus(final String function) {
                final boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(HtmlViewWrapper.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        HtmlViewWrapper.this.invokeJSfunction("javascript:" + function + "('" + isLockActive + "'  );");
                    }
                });
            }

            @Override
            public void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex) {
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        int itemIndexAsInteger = 0;
                        try {
                            itemIndexAsInteger = Integer.parseInt(itemIndex);
                        }
                        catch (Exception ex) {
                            SDKLogger.printErrorLog(TAG, "Error when trying to parse item index: " + ex.getMessage());
                        }
                        ContentItem contentItem = new ContentItem();
                        contentItem.setId(appID);
                        contentItem.setName("");
                        contentItem.setData(googlePlayLink);
                        contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
                        contentItem.setAdvertiserID(advertiserID);
                        contentItem.setIsPromoted(true);
                        if (HtmlViewWrapper.this.mViewPagerItemClickListener != null) {
                            HtmlViewWrapper.this.mViewPagerItemClickListener.onClickEnd(contentItem, itemIndexAsInteger);
                        } else if (HtmlViewWrapper.this.mInFocusActivityContext != null) {
                            ContentExecutionHandler.handleContentItemClick(HtmlViewWrapper.this.mInFocusActivityContext, contentItem, widgetType, styleID, itemIndexAsInteger, false, null);
                        }
                    }
                });
            }

            @Override
            public void sendEvent(final String type, final String category, final String action, final String label, final String jsonData) {
                HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        SDKLogger.printDebbugLog("RONY", "type = " + type);
                        SDKLogger.printDebbugLog("RONY", "category = " + category);
                        SDKLogger.printDebbugLog("RONY", "action = " + action);
                        SDKLogger.printDebbugLog("RONY", "label = " + label);
                        SDKLogger.printDebbugLog("RONY", "jsonData = " + jsonData);
                        SDKLogger.printDebbugLog("RONY", "mStyleId = " + HtmlViewWrapper.this.mStyleId);
                        SDKLogger.printDebbugLog("RONY", "mWidgetType = " + HtmlViewWrapper.this.mWidgetType);
                        Event event = new Event();
                        event.setLogLevel(EventManager.LOG_NORMAL_LEVEL);
                        event.addParameterToJsonObject(jsonData);
                        EventManager.getInstance(HtmlViewWrapper.this.getContext()).logEvent(HtmlViewWrapper.this.getContext(), HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mStyleId, EventManager.LOG_NORMAL_LEVEL, event, category, action, label);
                    }
                });
            }

            @Override
            public void toggleLoadingState(final boolean isLoading) {
                if (HtmlViewWrapper.this.mLoadingProgressView != null) {
                    HtmlViewWrapper.this.mExecutionHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (isLoading) {
                                HtmlViewWrapper.this.mLoadingProgressView.startLoadingAnimation();
                            } else {
                                HtmlViewWrapper.this.mLoadingProgressView.stopLoadingAnimation();
                            }
                        }
                    });
                }
            }

            @Override
            public void notifyIsVastAdReady(boolean isVastReady) {
                Message message = Message.obtain();
                message.what = 5;
                message.arg1 = isVastReady ? 1 : 0;
                HtmlViewWrapper.this.mEventHandler.sendMessage(message);
            }
        });
    }

    private void setParentalLockState(boolean locked) {
        this.invokeJSfunction("javascript:kidozOnParentalLockStateChanged('" + locked + "');");
    }

    private void startParentalLockDialog() {
        int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(this.getContext(), false) * 0.5f)};
        if (this.mInFocusActivityContext != null) {
            ParentalLockDialog parentalLockDialog = new ParentalLockDialog(this.mInFocusActivityContext, false, popLocation);
            parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    HtmlViewWrapper.this.updateLockIcon();
                }
            });
            parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                @Override
                public void onPasswordEntered(boolean isPasswordCorrect) {
                    HtmlViewWrapper.this.updateLockIcon();
                }
            });
            parentalLockDialog.show();
            this.updateLockIcon();
        }
    }

    private void startAboutKidozDialog() {
        int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(this.getContext(), false) * 0.5f)};
        if (this.mInFocusActivityContext != null) {
            AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(this.mInFocusActivityContext, popLocation);
            aboutKidozDialog.openDialog();
        }
    }

    private void updateLockIcon() {
        try {
            boolean isLockActive;
            boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
            if (isLockActive) {
                this.setParentalLockState(true);
            } else {
                this.setParentalLockState(false);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }

    public void requestFocusOn(boolean isFullScreen) {
        if (this.mContentItem != null) {
            String json = this.mContentItem.getJSONitem().toString();
            String func = "javascript:kidozOnFocusOn('" + this.mContentItem.getId() + "','" + json + "','" + isFullScreen + "','" + this.mWidgetType + "','" + this.mContentItem.getRealViewIndex() + "');";
            if (this.mCustomFunctionsMap != null && this.mCustomFunctionsMap.has(JS_FUNC_ON_FOCUS_ON_KEY)) {
                func = this.mCustomFunctionsMap.optString(JS_FUNC_ON_FOCUS_ON_KEY, func);
            }
            this.invokeJSfunction(func);
        }
    }

    public void requestPrepareFocusOn(boolean isFullScreen) {
        if (this.mContentItem != null) {
            String json = this.mContentItem.getJSONitem().toString();
            String func = "javascript:kidozOnPrepareFocusOn('" + this.mContentItem.getId() + "','" + json + "','" + isFullScreen + "','" + this.mWidgetType + "','" + this.mContentItem.getRealViewIndex() + "');";
            if (this.mCustomFunctionsMap != null && this.mCustomFunctionsMap.has(JS_FUNC_ON_PREPARE_FOCUS_ON_KEY)) {
                func = this.mCustomFunctionsMap.optString(JS_FUNC_ON_PREPARE_FOCUS_ON_KEY, func);
            }
            this.invokeJSfunction(func);
        }
    }

    public void requestFocusOff() {
        if (this.mContentItem != null) {
            String func = "javascript:kidozOnFocusOff('" + this.mContentItem.getId() + "');";
            if (this.mCustomFunctionsMap != null && this.mCustomFunctionsMap.has(JS_FUNC_ON_FOCUS_OFF_KEY)) {
                func = this.mCustomFunctionsMap.optString(JS_FUNC_ON_FOCUS_OFF_KEY, func);
            }
            this.invokeJSfunction(func);
        }
    }

    public void requestMaximize() {
        String func = "javascript:kidozOnMaximize();";
        if (this.mCustomFunctionsMap.has(JS_FUNC_ON_MAXIMIZE_KEY)) {
            func = this.mCustomFunctionsMap.optString(JS_FUNC_ON_MAXIMIZE_KEY, func);
        }
        this.invokeJSfunction(func);
    }

    public void requestMinimize() {
        String func = "javascript:kidozOnMinimize();";
        if (this.mCustomFunctionsMap.has(JS_FUNC_ON_MINIMIZE_KEY)) {
            func = this.mCustomFunctionsMap.optString(JS_FUNC_ON_MINIMIZE_KEY, func);
        }
        this.invokeJSfunction(func);
    }

    public void requestWidgetOpen(String widgetType) {
        if (widgetType != null) {
            this.invokeJSfunction("javascript:kidozOnWidgetOpen('" + widgetType + "');");
        }
    }

    public void requestWidgetClose(String widgetType) {
        if (widgetType != null) {
            this.invokeJSfunction("javascript:kidozOnWidgetClose('" + widgetType + "');");
        }
    }

    public void requestVastAds() {
        this.invokeJSfunction("javascript:requestAds();");
    }

    public void startVastAd() {
        this.invokeJSfunction("javascript:startVastAd();");
    }

    public void stopVastAd() {
        this.invokeJSfunction("javascript:stopVastAd();");
    }

    public void pauseVastAd() {
        this.invokeJSfunction("javascript:pauseVastAd();");
    }

    public void resumeVastAd() {
        this.invokeJSfunction("javascript:resumeVastAd();");
    }

    public void clearHtmlView() {
        this.mWebView.loadUrl("");
        this.mWebView.stopLoading();
    }

    public void setHtmlWebViewListener(IOnHtmlWebViewInterface htmlWeViewListener) {
        this.mHtmlWeViewListener = htmlWeViewListener;
    }

    public void invokeJSfunction(final String function) {
        try {
            this.mExecutionHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 19) {
                        HtmlViewWrapper.this.mWebView.evaluateJavascript(function, null);
                    } else {
                        HtmlViewWrapper.this.mWebView.loadUrl(function);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setOnSwipeGestureListener(OnSwipeTouchListener onSwipeGEstureListener) {
        this.mWebView.setOnTouchListener(onSwipeGEstureListener);
    }

    public HtmlFiveWebView getInnerWebView() {
        return this.mWebView;
    }

    public boolean isAvoidAutoImpression() {
        return this.mIsAvoidAutoImpression;
    }

    public boolean isShowClose() {
        return this.mIsShowClose;
    }

    public void showLoadingProgressView() {
        if (this.mLoadingProgressView != null) {
            this.mLoadingProgressView.startLoadingAnimation();
        }
    }

    public void hideLoadingProgressView() {
        if (this.mLoadingProgressView != null) {
            this.mLoadingProgressView.stopLoadingAnimation();
        }
    }

    public void setWebViewAlpha(float alpha) {
        this.mWebView.setAlpha(alpha);
    }

    public void stopAndReleaseWebView() {
        if (this.mWebView != null) {
            this.mWebView.stopAndReleaseWebView();
        }
    }

    public void stopLoading() {
        if (this.mWebView != null) {
            this.mWebView.stopLoading();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int size;
        super.onSizeChanged(w, h, oldw, oldh);
        this.mLoadingProgressView.getLayoutParams().height = size = (int)((float)Math.min(w, h) * 0.35f);
        this.mLoadingProgressView.getLayoutParams().width = size;
        this.mLoadingProgressView.setCircleWidthRelativeToSize(w);
    }

    public void setViewPagerItemClickListener(ItemViewPagerAdapter.ViewPagerItemClickListener viewPagerItemClickListener) {
        this.mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    public ContentItem getInnerContentData() {
        return this.mContentItem;
    }

    public void clearCache() {
        if (this.mWebView != null) {
            this.mWebView.clearCache(true);
            this.mWebView.clearHistory();
        }
    }

    private static interface AndroidJSLocalInterface {
        public void onViewReady();

        public void simulateClick(String var1, int var2);

        public void onImpressionServed(String var1, String var2, String var3, String var4);

        public void onAboutClick();

        public void onParentalClick();

        public void onCloseClick();

        public void onMaximize();

        public void onInitWebViewWithProperties(String var1);

        public void onConversionServed(String var1, String var2, String var3, String var4, String var5, String var6);

        public void onStoreLocalParam(String var1, String var2, String var3);

        public void getLocalParam(String var1, String var2);

        public void getDonePlayback();

        public void getParentalLockStatus(String var1);

        public void forwardToGooglePlay(String var1, String var2, String var3, String var4, String var5, String var6);

        public void sendEvent(String var1, String var2, String var3, String var4, String var5);

        public void toggleLoadingState(boolean var1);

        public void notifyIsVastAdReady(boolean var1);
    }

    class HtmlAndroidJavaScriptInterface {
        private AndroidJSLocalInterface mScriptInterface;

        HtmlAndroidJavaScriptInterface(AndroidJSLocalInterface scriptInterface) {
            this.mScriptInterface = scriptInterface;
        }

        @JavascriptInterface
        public void onViewReady() {
            this.mScriptInterface.onViewReady();
        }

        @JavascriptInterface
        public void simulateClick(String contentItemJson, int positionIndex) {
            try {
                this.mScriptInterface.simulateClick(contentItemJson, positionIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @JavascriptInterface
        public void onSendImpressionEvent(String item_id, String item_name, String ad_id, String view_index) {
            try {
                this.mScriptInterface.onImpressionServed(item_id, item_name, ad_id, view_index);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @JavascriptInterface
        public void onInvokeAboutClick() {
            this.mScriptInterface.onAboutClick();
        }

        @JavascriptInterface
        public void onInvokeParentalClick() {
            this.mScriptInterface.onParentalClick();
        }

        @JavascriptInterface
        public void onInvokeCloseClick() {
            this.mScriptInterface.onCloseClick();
        }

        @JavascriptInterface
        public void onInvokeMaximize() {
            this.mScriptInterface.onMaximize();
        }

        @JavascriptInterface
        public void onInitWebViewWithProperties(String properties) {
            try {
                this.mScriptInterface.onInitWebViewWithProperties(properties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @JavascriptInterface
        public void onSendConversionEvent(String item_id, String item_name, String ad_id, String view_index, String rewardKey, String rewardValue) {
            try {
                this.mScriptInterface.onConversionServed(item_id, item_name, ad_id, view_index, rewardKey, rewardValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @JavascriptInterface
        public void onStoreLocalParameter(String key, String value, String scope_type) {
            try {
                this.mScriptInterface.onStoreLocalParam(key, value, scope_type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @JavascriptInterface
        public void getLocalParameter(String function, String key) {
            try {
                this.mScriptInterface.getLocalParam(function, key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @JavascriptInterface
        public void onDone() {
            try {
                this.mScriptInterface.getDonePlayback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @JavascriptInterface
        public void getParentalLockStatus(String function) {
            try {
                this.mScriptInterface.getParentalLockStatus(function);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @JavascriptInterface
        public void forwardToGooglePlay(String advertiserID, String appID, String googlePlayLink, String widjetType, String styleID, String itemIndex) {
            this.mScriptInterface.forwardToGooglePlay(advertiserID, appID, googlePlayLink, widjetType, styleID, itemIndex);
        }

        @JavascriptInterface
        public void sendEvent(String type, String category, String action, String label, String jsonData) {
            this.mScriptInterface.sendEvent(type, category, action, label, jsonData);
        }

        @JavascriptInterface
        public void toggleLoadingState(String isLoading) {
            try {
                boolean isLoadingAsBoolean = Boolean.parseBoolean(isLoading);
                this.mScriptInterface.toggleLoadingState(isLoadingAsBoolean);
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to parse isLoading parameter: " + ex.getMessage());
            }
        }

        @JavascriptInterface
        public void notifyIsVastAdReady(boolean isVastReady) {
            this.mScriptInterface.notifyIsVastAdReady(isVastReady);
        }
    }
}

