/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.os.Message;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.events.DeviceUtils;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;
import com.kidoz.sdk.api.ui_views.AboutKidozView;
import com.kidoz.sdk.api.ui_views.AboutKidozWebViewContainer;
import com.kidoz.sdk.api.ui_views.BottomBarView;
import com.kidoz.sdk.api.ui_views.custom_drawables.XViewDrawable;
import java.io.File;
import org.json.JSONObject;

public class KidozBottomBar
extends RelativeLayout {
    public static final float BACKGROUND_RATIO = 0.061458334f;
    private Utils.StaticHandler mStaticHandler;
    private AboutKidozWebViewContainer mAboutKidozContainer;
    private int[] mAboutKidozPivot;
    private boolean mIsOrientationPortrait;
    private KidozWebView mKidozWebView;
    private boolean mIsNeedToCloseWebViewOnClick = true;
    private JSONObject mPropertiesObject;

    public KidozBottomBar(Context context, JSONObject propertiesObject) {
        super(context);
        this.mPropertiesObject = propertiesObject;
        this.initView();
    }

    private void initView() {
        this.mIsOrientationPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
        this.initBackground();
        this.initPromotedByKidozTextView();
        this.initAboutKidoz();
    }

    private void initAboutKidoz() {
        int screenMaxSize = Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        float MARGIN = 0.046296295f;
        AboutKidozView aboutKidozView = new AboutKidozView(this.getContext());
        aboutKidozView.setId(Utils.generateViewId());
        aboutKidozView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(KidozBottomBar.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(KidozBottomBar.this.getContext(), false) * 0.5f)};
                AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(KidozBottomBar.this.getContext(), popLocation);
                aboutKidozDialog.openDialog();
            }
        });
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.rightMargin = (int)((float)screenMaxSize * MARGIN);
        params.addRule(11);
        params.addRule(12);
        this.addView((View)aboutKidozView, (ViewGroup.LayoutParams)params);
        this.mAboutKidozPivot = new int[2];
        this.mAboutKidozPivot[0] = aboutKidozView.getLayoutParams().width / 2;
        this.mAboutKidozPivot[1] = aboutKidozView.getLayoutParams().height;
        this.mKidozWebView = new KidozWebView(this.getContext());
        this.mKidozWebView.getSettings().setUseWideViewPort(true);
        this.mKidozWebView.getSettings().setLoadWithOverviewMode(true);
        this.mKidozWebView.getSettings().setSupportZoom(false);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mKidozWebView.getSettings().setMixedContentMode(0);
        }
        this.mKidozWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                KidozBottomBar.this.mIsNeedToCloseWebViewOnClick = false;
                KidozBottomBar.this.mKidozWebView.setWebViewClient(new WebViewClient(){

                    public boolean shouldOverrideUrlLoading(WebView view, String url) {
                        boolean result = true;
                        if (url.startsWith("mailto:")) {
                            Intent mailIntent = new Intent("android.intent.action.SENDTO", Uri.parse((String)url));
                            KidozBottomBar.this.getContext().startActivity(mailIntent);
                        } else {
                            Intent linkIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                            KidozBottomBar.this.getContext().startActivity(linkIntent);
                        }
                        return true;
                    }
                });
                return true;
            }
        });
        this.mKidozWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean result = false;
                if (event.getAction() == 1) {
                    KidozBottomBar.this.getMyHandlerInstance().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (KidozBottomBar.this.mIsNeedToCloseWebViewOnClick && KidozBottomBar.this.mAboutKidozContainer.getVisibility() == 0) {
                                KidozBottomBar.this.hideAboutView();
                            }
                            KidozBottomBar.this.mIsNeedToCloseWebViewOnClick = true;
                        }
                    }, 150L);
                } else {
                    if (event.getAction() == 2) {
                        KidozBottomBar.this.mIsNeedToCloseWebViewOnClick = false;
                    }
                    if (KidozBottomBar.this.mIsOrientationPortrait) {
                        result = event.getAction() == 2;
                    }
                }
                return result;
            }
        });
        this.mKidozWebView.setLongClickable(true);
        this.mKidozWebView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return true;
            }
        });
        this.mKidozWebView.setVerticalScrollBarEnabled(false);
        this.mKidozWebView.setHorizontalScrollBarEnabled(false);
        this.mKidozWebView.loadUrl("http://kidoz.net/v3policy/");
        this.mAboutKidozContainer = new AboutKidozWebViewContainer(this.getContext());
        this.mAboutKidozContainer.setVisibility(4);
        this.mAboutKidozContainer.addView((View)this.mKidozWebView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        Point point = DeviceUtils.getScreenSize(this.getContext());
        int size = Math.min(point.x, point.y);
        size = (int)((double)size * 0.058);
        XViewDrawable xViewDrawable = new XViewDrawable(this.getContext(), Color.parseColor((String)"#04a0e1"));
        xViewDrawable.setBounds(0, 0, size, size);
        ImageView closeImageView = new ImageView(this.getContext());
        closeImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        closeImageView.setImageDrawable((Drawable)xViewDrawable);
        closeImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 100, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        KidozBottomBar.this.hideAboutView();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
        RelativeLayout.LayoutParams relParams = new RelativeLayout.LayoutParams(size, size);
        relParams.addRule(11);
        relParams.setMargins(0, Utils.dpTOpx(this.getContext(), 5.0f), Utils.dpTOpx(this.getContext(), 5.0f), 0);
        this.mAboutKidozContainer.addView((View)closeImageView, (ViewGroup.LayoutParams)relParams);
        RelativeLayout.LayoutParams webViewContainerParams = new RelativeLayout.LayoutParams(-2, -2);
        webViewContainerParams.addRule(7, aboutKidozView.getId());
        webViewContainerParams.addRule(8, aboutKidozView.getId());
        webViewContainerParams.leftMargin = (int)((float)screenMaxSize * MARGIN);
        this.addView((View)this.mAboutKidozContainer, (ViewGroup.LayoutParams)webViewContainerParams);
    }

    public void hideAboutView() {
        GenAnimator.playPopOutToRightBottom((View)this.mAboutKidozContainer, this.mAboutKidozPivot, new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                KidozBottomBar.this.mAboutKidozContainer.setVisibility(4);
                KidozBottomBar.this.mKidozWebView.goBack();
            }

            public void onAnimationCancel(Animator animation) {
                KidozBottomBar.this.mAboutKidozContainer.setVisibility(4);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public boolean isAboutViewVisible() {
        return this.mAboutKidozContainer.getVisibility() == 0;
    }

    private void initBackground() {
        File imageBg = null;
        if (this.mPropertiesObject != null) {
            imageBg = AssetUtil.getAssetFile(this.getContext(), this.mPropertiesObject.optString("bottomBarBackground", ""));
        }
        BottomBarView bottomBarView = new BottomBarView(this.getContext(), imageBg);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(12);
        params.addRule(14);
        this.addView((View)bottomBarView, (ViewGroup.LayoutParams)params);
    }

    private void initPromotedByKidozTextView() {
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)this.mPropertiesObject.optString("bottomBarTitle", "Promoted content by KIDOZ"));
        textView.setTextSize(14.0f);
        textView.setSingleLine(true);
        textView.setGravity(17);
        textView.setTextColor(-1);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(12);
        params.addRule(14);
        this.addView((View)textView, (ViewGroup.LayoutParams)params);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mIsOrientationPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
        this.mKidozWebView.scrollTo(0, 0);
    }

    private Utils.StaticHandler getMyHandlerInstance() {
        if (this.mStaticHandler == null) {
            this.mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()){

                @Override
                public void handleMessage(Message message) {
                }
            };
        }
        return this.mStaticHandler;
    }
}

