/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.ContentPanelView;
import com.kidoz.sdk.api.ui_views.KidozBottomBar;
import com.kidoz.sdk.api.ui_views.KidozTopBar;
import org.json.JSONObject;

public class FeedFullView
extends FrameLayout {
    private ContentPanelView mContentPanelView;
    private ContentData mContentData;
    private KidozTopBar mKidozTopBar;
    private KidozBottomBar mKidozBottomBar;
    private View.OnClickListener mCloseBtnClickListener = null;
    private JSONObject mPropertiesObject;

    public FeedFullView(Context context, JSONObject propertiesObject) {
        super(context);
        this.mPropertiesObject = propertiesObject;
        this.initView();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        SDKLogger.printDebbugLog("HERE", ">>>>FeedFullVeiw: onConfigurationChanged");
    }

    private void initView() {
        RelativeLayout containerLayout = new RelativeLayout(this.getContext());
        containerLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        String startColor = "#98e0ff";
        String centerColor = "#e0e4ed";
        String endColor = "#98e0ff";
        if (this.mPropertiesObject != null) {
            startColor = this.mPropertiesObject.optString("mainBgColorStart", "#98e0ff");
            centerColor = this.mPropertiesObject.optString("mainBgColorCenter", "#e0e4ed");
            endColor = this.mPropertiesObject.optString("mainBgColorEnd", "#98e0ff");
        }
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor((String)startColor), Color.parseColor((String)centerColor), Color.parseColor((String)endColor)});
        if (Build.VERSION.SDK_INT >= 16) {
            containerLayout.setBackground((Drawable)gradientDrawable);
        } else {
            containerLayout.setBackgroundDrawable((Drawable)gradientDrawable);
        }
        this.mKidozTopBar = new KidozTopBar(this.getContext(), false, WidgetType.WIDGET_TYPE_FEED.getStringValue(), this.mPropertiesObject);
        this.mKidozTopBar.setId(Utils.generateViewId());
        this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

            @Override
            public void onExitClicked(View view) {
                if (FeedFullView.this.mCloseBtnClickListener != null) {
                    FeedFullView.this.mCloseBtnClickListener.onClick(null);
                }
            }
        });
        this.mKidozTopBar.showParentalLockIcon(true);
        this.mKidozBottomBar = new KidozBottomBar(this.getContext(), this.mPropertiesObject);
        this.mKidozBottomBar.setId(Utils.generateViewId());
        this.mContentPanelView = new ContentPanelView(this.getContext(), ContentPanelView.LayoutViewType.STAGGERED);
        Point point = Utils.getScreenSize(this.getContext());
        int paddingBottom = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
        int paddingTop = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
        this.mContentPanelView.getInnerRecyclerView().setPadding(0, paddingTop, 0, paddingBottom);
        this.mContentPanelView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        containerLayout.addView((View)this.mContentPanelView, (ViewGroup.LayoutParams)params);
        params = new RelativeLayout.LayoutParams(-1, -1);
        containerLayout.addView((View)this.mKidozTopBar, (ViewGroup.LayoutParams)params);
        params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(12);
        containerLayout.addView((View)this.mKidozBottomBar, (ViewGroup.LayoutParams)params);
        this.addView((View)containerLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void setContentDataAndRefresh(ContentData contentData) {
        this.mContentData = contentData;
        this.applyViewStyling();
        if (this.mContentData != null) {
            this.mContentPanelView.addDataAndRefreshView(this.mContentData);
        }
    }

    private void applyViewStyling() {
        if (this.mContentData != null) {
            this.mContentPanelView.setRoundingCorenrsValue(this.mContentData.getViewItemCorenrRadiusPx());
        }
    }

    public void setOnCloseButtonClickListenr(View.OnClickListener clickListenr) {
        this.mCloseBtnClickListener = clickListenr;
        if (this.mKidozBottomBar != null) {
            this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

                @Override
                public void onExitClicked(View view) {
                    if (FeedFullView.this.mCloseBtnClickListener != null) {
                        FeedFullView.this.mCloseBtnClickListener.onClick(null);
                    }
                }
            });
        }
    }

    public void setOnContentItemClickListener(AbstractContentPanel.IOnContentItemClickListener listener) {
        if (this.mContentPanelView != null) {
            this.mContentPanelView.setOnContentItemClickListener(listener);
        }
    }

    public KidozBottomBar getViewBottomBar() {
        return this.mKidozBottomBar;
    }

    public void showLoadingProgressView(boolean show) {
        if (this.mContentPanelView != null) {
            this.mContentPanelView.showLoadingProgressView(show);
        }
    }

    public boolean isViewEmpty() {
        return this.mContentData != null && this.mContentData.getContentDataItems().isEmpty();
    }
}

