/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.sdk.api.general.assets_handling.ImageAssetsUtils;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.picasso_related.RoundedTransformation;
import com.kidoz.sdk.api.structure.ContentItem;
import java.io.File;

public class ContentItemView
extends KidozCardView {
    public static final int DEFAULT_CORNER_RADIUS_PIXELS = 6;
    public static final int DEFAULT_SHADOW_ELEVATION_RADIUS_DP = 4;
    public static final int CARD_OUTER_MARGIN = 4;
    public static final int VIEW_CONTENT_PADDING = 2;
    private RelativeLayout.LayoutParams mPromotedIndicationParams;
    private RelativeLayout mInnerContainer;
    private ImageView mMainIconThumb;
    private ImageView mSecondaryThumb;
    private TextView mNameView;
    private ImageView mPromotedIndication;
    private File mImageFile;

    public ContentItemView(Context context) {
        super(context);
        this.initCardViewGeneral(context);
        this.initView(context);
    }

    public ContentItemView(Context context, ContentType contentType) {
        super(context);
        if (contentType == ContentType.HTML) {
            this.initViewForHtmlContent(context);
        } else {
            this.initCardViewGeneral(context);
            this.initView(context);
        }
    }

    public ContentItemView(Context context, int roundingCorenrs) {
        super(context);
        this.initCardViewGeneral(context);
        this.initView(context);
    }

    private void initCardViewGeneral(Context context) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        int mOuterMargin = Utils.dpTOpx(context, 4.0f);
        params.setMargins(mOuterMargin, mOuterMargin, mOuterMargin, mOuterMargin);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        int pad = Utils.dpTOpx(context, 2.0f);
        this.setContentPadding(pad, pad, pad, pad);
        this.mInnerContainer = new RelativeLayout(context);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.mInnerContainer, (ViewGroup.LayoutParams)layoutParams);
        this.setRadius(Utils.dpTOpx(context, 6.0f));
        this.setCardElevation(Utils.dpTOpx(context, 4.0f));
    }

    public void disableCardElevation() {
        this.setCardElevation(0.0f);
    }

    private void initView(Context context) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.createMainThumbView(context, layoutParams);
        this.createSponsoredIndicator(context, layoutParams);
        this.mSecondaryThumb = new ImageView(context);
        this.mSecondaryThumb.setId(Utils.generateViewId());
        this.mSecondaryThumb.setScaleType(ImageView.ScaleType.FIT_CENTER);
        layoutParams = new RelativeLayout.LayoutParams(Utils.dpTOpx(context, 30.0f), Utils.dpTOpx(context, 30.0f));
        layoutParams.addRule(11);
        layoutParams.addRule(8, this.mMainIconThumb.getId());
        layoutParams.setMargins(0, 0, Utils.dpTOpx(context, 10.0f), Utils.dpTOpx(context, -25.0f));
        this.mInnerContainer.addView((View)this.mSecondaryThumb, (ViewGroup.LayoutParams)layoutParams);
        this.mNameView = new TextView(context);
        this.mNameView.setId(Utils.generateViewId());
        this.mNameView.setTextColor(Color.parseColor((String)"#484848"));
        this.mNameView.setTextSize(2, (float)ContentItemView.getNameTextSizeByScreenLayout(this.getContext()));
        this.mNameView.setLines(2);
        this.mNameView.setEllipsize(TextUtils.TruncateAt.END);
        this.mNameView.setGravity(16);
        this.mNameView.setPadding(0, Utils.dpTOpx(context, 4.0f), 0, Utils.dpTOpx(context, 4.0f));
        layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(3, this.mMainIconThumb.getId());
        layoutParams.addRule(0, this.mSecondaryThumb.getId());
        layoutParams.setMargins(Utils.dpTOpx(context, 6.0f), Utils.dpTOpx(context, 0.0f), Utils.dpTOpx(context, 6.0f), 0);
        this.mInnerContainer.addView((View)this.mNameView, (ViewGroup.LayoutParams)layoutParams);
    }

    private void createMainThumbView(Context context, RelativeLayout.LayoutParams layoutParams) {
        this.mMainIconThumb = new ImageView(context);
        this.mMainIconThumb.setId(Utils.generateViewId());
        this.mMainIconThumb.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mInnerContainer.addView((View)this.mMainIconThumb, (ViewGroup.LayoutParams)layoutParams);
    }

    private void createSponsoredIndicator(Context context, RelativeLayout.LayoutParams layoutParams) {
        this.mPromotedIndication = new ImageView(context);
        this.mPromotedIndication.setId(Utils.generateViewId());
        this.mPromotedIndication.setScaleType(ImageView.ScaleType.FIT_CENTER);
        layoutParams = new RelativeLayout.LayoutParams(Utils.dpTOpx(context, 54.0f), Utils.dpTOpx(context, 19.0f));
        layoutParams.addRule(5, this.mMainIconThumb.getId());
        layoutParams.addRule(6, this.mMainIconThumb.getId());
        this.mInnerContainer.addView((View)this.mPromotedIndication, (ViewGroup.LayoutParams)layoutParams);
        this.mPromotedIndicationParams = (RelativeLayout.LayoutParams)this.mPromotedIndication.getLayoutParams();
    }

    public void setPromotedIndication(ContentItem contentItem, int containerWidth, int containerHeight, int roundedCorners) {
        this.mImageFile = ImageAssetsUtils.getAssetFile(this.getContext(), ImageAssetsUtils.APP_ASSET_TYPE.PROMOTED_INDICATION);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)this.mImageFile.getAbsolutePath(), (BitmapFactory.Options)options);
        float ratio = (float)options.outHeight / (float)options.outWidth;
        this.mPromotedIndication.setImageBitmap(null);
        this.mPromotedIndicationParams.width = (int)((double)containerWidth * 0.3);
        this.mPromotedIndicationParams.height = this.mPromotedIndication.getLayoutParams().height = (int)((float)this.mPromotedIndicationParams.width * ratio);
        if (contentItem != null && contentItem.isPromoted() && this.mImageFile.exists() && this.mImageFile != null) {
            PicassoOk.getPicasso(this.getContext()).load(this.mImageFile).transform(new RoundedTransformation(roundedCorners, 0, true)).resize(this.mPromotedIndicationParams.width, this.mPromotedIndicationParams.height).into(this.mPromotedIndication);
        }
    }

    private void initViewForHtmlContent(Context context) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        int mOuterMargin = Utils.dpTOpx(context, 4.0f);
        params.setMargins(mOuterMargin, mOuterMargin, mOuterMargin, mOuterMargin);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mInnerContainer = new RelativeLayout(context);
        this.setRadius(Utils.dpTOpx(context, 1.0f));
        this.setCardElevation(0.0f);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.mInnerContainer, (ViewGroup.LayoutParams)layoutParams);
        this.createMainThumbView(context, layoutParams);
        this.createSponsoredIndicator(context, layoutParams);
    }

    public ImageView getMainThumbView() {
        return this.mMainIconThumb;
    }

    public ImageView getSecondaryThumbView() {
        return this.mSecondaryThumb;
    }

    public TextView getNameTextView() {
        return this.mNameView;
    }

    public void setItemBgColor(int color) {
        this.setCardBackgroundColor(color);
    }

    public static int getNameTextSizeByScreenLayout(Context context) {
        int size = 16;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        switch (screenLayout &= 0xF) {
            case 1: {
                size = 14;
                break;
            }
            case 2: {
                size = 15;
                break;
            }
            case 3: {
                size = 17;
                break;
            }
            case 4: {
                size = 21;
            }
        }
        return size;
    }

    public static int getViewMargin(Context context) {
        return Utils.dpTOpx(context, 4.0f);
    }
}

