/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.view.View;

public class ConfigurationView
extends View {
    private final String TAG = ConfigurationView.class.getSimpleName();
    private boolean mHasWindowFocus;
    private int mWindowVisibility;
    private int mVisibility;
    private ConfigurationViewListener mConfigurationViewListener;

    public ConfigurationView(Context context, ConfigurationViewListener configurationViewListener) {
        super(context);
        this.mConfigurationViewListener = configurationViewListener;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == 2) {
            // empty if block
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        this.mHasWindowFocus = hasWindowFocus;
        this.checkIsViewCompletelyInvisible();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mVisibility = visibility;
        this.checkIsViewCompletelyInvisible();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mWindowVisibility = visibility;
        this.checkIsViewCompletelyInvisible();
    }

    private void checkIsViewCompletelyInvisible() {
        boolean result = false;
        if (!this.mHasWindowFocus && this.mVisibility == 4 && this.mWindowVisibility == 8) {
            result = true;
        }
        if (this.mConfigurationViewListener != null) {
            this.mConfigurationViewListener.onIsViewCompletelyInvisible(result);
        }
    }

    public static interface ConfigurationViewListener {
        public void onIsViewCompletelyInvisible(boolean var1);
    }
}

