/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.widget.ImageView;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import java.io.File;

public class BottomBarView
extends ImageView {
    private final String TAG = BottomBarView.class.getSimpleName();
    private File mImageFile;
    private int mWidth;
    private int mHeight;
    private Paint mPaint;

    public BottomBarView(Context context, File bgImage) {
        super(context);
        this.mImageFile = bgImage;
        this.setScaleType(ImageView.ScaleType.FIT_XY);
        this.initView();
    }

    private void initView() {
        this.initImageParameters();
        this.initPaints();
    }

    private void loadImage() {
        if (this.mImageFile.exists() && this.getDrawable() == null && this.mImageFile != null) {
            PicassoOk.getPicasso(this.getContext()).load(this.mImageFile).into(this);
        }
    }

    private void initImageParameters() {
        float mScaleFactor = ScreenUtils.getScaleFactor(this.getContext());
        this.mWidth = 3069;
        this.mHeight = 118;
        if (this.mImageFile != null && this.mImageFile.exists()) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)this.mImageFile.getAbsolutePath(), (BitmapFactory.Options)options);
            this.mWidth = options.outWidth;
            this.mHeight = options.outHeight;
        }
        this.mWidth = (int)((float)this.mWidth * mScaleFactor);
        this.mHeight = (int)((float)this.mHeight * mScaleFactor);
    }

    private void initPaints() {
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.setLayerType(1, this.mPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mImageFile == null || !this.mImageFile.exists()) {
            float radius = 0.40348437f * (float)this.mWidth;
            float centerX = 0.21427605f * (float)this.mWidth;
            float centerY = 6.7261863f * (float)this.mHeight;
            this.mPaint.setColor(Color.parseColor((String)"#94bc18"));
            canvas.drawCircle(centerX, centerY, radius, this.mPaint);
            radius = 0.48307812f * (float)this.mWidth;
            centerX = 0.7813541f * (float)this.mWidth;
            centerY = 8.021356f * (float)this.mHeight;
            this.mPaint.setColor(Color.parseColor((String)"#94bc18"));
            canvas.drawCircle(centerX, centerY, radius, this.mPaint);
            radius = 0.27447918f * (float)this.mWidth;
            centerX = -0.026041666f * (float)this.mWidth;
            centerY = 4.4661016f * (float)this.mHeight;
            this.mPaint.setColor(Color.parseColor((String)"#a9d817"));
            canvas.drawCircle(centerX, centerY, radius, this.mPaint);
            radius = 0.48014584f * (float)this.mWidth;
            centerX = 0.48014584f * (float)this.mWidth;
            centerY = 7.8125424f * (float)this.mHeight;
            this.mPaint.setColor(Color.parseColor((String)"#a9d817"));
            canvas.drawCircle(centerX, centerY, radius, this.mPaint);
            radius = 0.54347396f * (float)this.mWidth;
            centerX = 1.0494949f * (float)this.mWidth;
            centerY = 8.842796f * (float)this.mHeight;
            this.mPaint.setColor(Color.parseColor((String)"#a9d817"));
            canvas.drawCircle(centerX, centerY, radius, this.mPaint);
        } else {
            this.loadImage();
        }
    }
}

