/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.structure;

import android.graphics.Color;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class ContentItem {
    private static final String DATA_KEY = "data";
    private static final String TITLE_KEY = "title";
    private static final String THUMB_KEY = "thumb";
    private static final String SEC_THUMB_KEY = "sec_thumb";
    private static final String ID_KEY = "id";
    private static final String PROMOTED_KEY = "promoted";
    private static final String LANG_KEY = "lang";
    private static final String CONTENT_TYPE_KEY = "type";
    private static final String ADVERTISER_KEY = "advertiser_id";
    private static final String BG_COLOR_KEY = "bg_color";
    private static final String IMAGE_RATIO_KEY = "img_ratio";
    private static final String EXTERNAL_PARAMETERS__KEY = "ext";
    private String mId;
    private String mThumb;
    public String mSecThumb;
    private ContentType mContentType = ContentType.NONE;
    private String mData;
    private String mTiltle;
    private String mLang;
    private boolean mPromoted;
    private String mAdvertiserID;
    private int mRealViewIndex;
    private JSONArray mJSONitem = new JSONArray();
    private JSONObject mExtraParameters = new JSONObject();
    private int[] mMainThumbSize;
    public float mMainThumbImageRatio = 0.5f;
    private int mPalliteBgColor = -1;
    private int mPalliteTextColor = Color.parseColor((String)"#484848");

    public void setAdvertiserID(String mAdvertiserID) {
        this.mAdvertiserID = mAdvertiserID;
    }

    public ContentItem() {
    }

    public ContentItem(JSONArray jsonArray, HashMap<String, Integer> keysMap) {
        if (jsonArray != null) {
            String color;
            int val;
            this.mJSONitem = jsonArray;
            if (keysMap.containsKey(ID_KEY)) {
                this.mId = jsonArray.optString(keysMap.get(ID_KEY).intValue(), "");
            }
            if (keysMap.containsKey(THUMB_KEY)) {
                this.mThumb = jsonArray.optString(keysMap.get(THUMB_KEY).intValue(), "");
                this.mThumb = Utils.fixUrlLink(this.mThumb);
            }
            if (keysMap.containsKey(SEC_THUMB_KEY)) {
                this.mSecThumb = jsonArray.optString(keysMap.get(SEC_THUMB_KEY).intValue(), "");
                this.mSecThumb = Utils.fixUrlLink(this.mSecThumb);
            }
            if (keysMap.containsKey(CONTENT_TYPE_KEY)) {
                try {
                    val = jsonArray.optInt(keysMap.get(CONTENT_TYPE_KEY).intValue(), -1);
                    this.mContentType = ContentType.getTypeByValue(val);
                }
                catch (Exception e) {
                    SDKLogger.printErrorLog("Error parsing single content item Action : \n" + e.getMessage());
                    this.mContentType = ContentType.NONE;
                }
            }
            if (keysMap.containsKey(DATA_KEY)) {
                this.mData = jsonArray.optString(keysMap.get(DATA_KEY).intValue(), "");
            }
            if (keysMap.containsKey(TITLE_KEY)) {
                this.mTiltle = jsonArray.optString(keysMap.get(TITLE_KEY).intValue(), "");
            }
            if (keysMap.containsKey(LANG_KEY)) {
                this.mLang = jsonArray.optString(keysMap.get(LANG_KEY).intValue(), "");
            }
            if (keysMap.containsKey(ADVERTISER_KEY)) {
                this.mAdvertiserID = jsonArray.optString(keysMap.get(ADVERTISER_KEY).intValue(), "0");
            }
            if (keysMap.containsKey(PROMOTED_KEY)) {
                val = jsonArray.optInt(keysMap.get(PROMOTED_KEY).intValue(), 0);
                boolean bl = this.mPromoted = val == 1;
            }
            if (keysMap.containsKey(BG_COLOR_KEY) && (color = jsonArray.optString(keysMap.get(BG_COLOR_KEY).intValue(), "#ffffff")) != null) {
                try {
                    this.mPalliteBgColor = Color.parseColor((String)color);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.mPalliteBgColor == -1 && this.mContentType != null) {
                try {
                    if (this.mContentType == ContentType.EXTERNAL_BROWSER_URL || this.mContentType == ContentType.WEB_GAME_URL) {
                        this.mPalliteBgColor = Color.parseColor((String)"#b0d63a");
                    } else if (this.mContentType == ContentType.WEBSITE_URL) {
                        this.mPalliteBgColor = Color.parseColor((String)"#f8a850");
                    } else if (this.mContentType == ContentType.GOOGLE_PLAY_APPLICATION || this.mContentType == ContentType.PROMOTED_PLAY_APPLICATION) {
                        this.mPalliteBgColor = Color.parseColor((String)"#4aaed3");
                    } else if (this.mContentType == ContentType.YOUTUBE_VIDEO || this.mContentType == ContentType.VIMEO_VIDEO || this.mContentType == ContentType.STREAMING_VIDEO) {
                        this.mPalliteBgColor = Color.parseColor((String)"#f8de46");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (keysMap.containsKey(IMAGE_RATIO_KEY)) {
                this.mMainThumbImageRatio = (float)jsonArray.optDouble(keysMap.get(IMAGE_RATIO_KEY).intValue());
            }
            if (keysMap.containsKey(EXTERNAL_PARAMETERS__KEY)) {
                this.mExtraParameters = jsonArray.optJSONObject(keysMap.get(EXTERNAL_PARAMETERS__KEY).intValue());
            }
        }
    }

    public int getPaliteBgColor() {
        return this.mPalliteBgColor;
    }

    public void setPaliteBgColor(int paliteBgColor) {
    }

    public int getPaliteTextColor() {
        return this.mPalliteTextColor;
    }

    public void setPaliteTextColor(int paliteTextColor) {
        this.mPalliteTextColor = paliteTextColor;
    }

    public float getMainThumbImageRatio() {
        return this.mMainThumbImageRatio;
    }

    public int[] getMainThumbSize() {
        return this.mMainThumbSize;
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String setId) {
        this.mId = setId;
    }

    public String getThumb() {
        return this.mThumb;
    }

    public void setThumb(String thumb) {
        this.mThumb = thumb;
    }

    public ContentType getContentType() {
        return this.mContentType;
    }

    public String getSecThumb() {
        return this.mSecThumb;
    }

    public String getData() {
        return this.mData;
    }

    public void setData(String data) {
        this.mData = data;
    }

    public String getName() {
        return this.mTiltle;
    }

    public void setName(String name) {
        this.mTiltle = name;
    }

    public String getLang() {
        return this.mLang;
    }

    public boolean isPromoted() {
        return this.mPromoted;
    }

    public String getAdvertiserID() {
        return this.mAdvertiserID;
    }

    public void setContentType(ContentType contentType) {
        this.mContentType = contentType;
    }

    public int getRealViewIndex() {
        return this.mRealViewIndex;
    }

    public void setRealViewIndex(int viewIndex) {
        this.mRealViewIndex = viewIndex;
    }

    public JSONArray getJSONitem() {
        return this.mJSONitem;
    }

    public JSONObject getExtraParameters() {
        return this.mExtraParameters;
    }

    public boolean getIsAvoidAutoImpression() {
        boolean avoid = false;
        if (this.mExtraParameters != null) {
            avoid = this.mExtraParameters.optBoolean("avoidAutoImpression", false);
        }
        return avoid;
    }

    public boolean getIsNonDefaultHtml() {
        boolean non = false;
        if (this.mExtraParameters != null) {
            non = this.mExtraParameters.optBoolean("nonDefaultHTML", false);
        }
        return non;
    }

    public boolean getShouldDisplayMaximizeButton() {
        boolean show = false;
        if (this.mExtraParameters != null) {
            show = this.mExtraParameters.optBoolean("showMaximize", false);
        }
        return show;
    }

    public void setIsPromoted(boolean isPromoted) {
        this.mPromoted = isPromoted;
    }
}

