/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;

public class WebPlayerView
extends RelativeLayout {
    private static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.25f;
    private KidozWebView mKidozWebView;
    private WebPlayerType mWebPlayerType;
    private IOnRemoveViewRequestListener mRemoveViewRequestListener;
    private LoadingProgressView mLoadingProgressView;

    public WebPlayerView(Context context, WebPlayerType webPlayerType, String widgetType) {
        super(context);
        this.mWebPlayerType = webPlayerType;
        this.initiateView();
    }

    private void initiateView() {
        this.initWebView();
        if (this.mWebPlayerType != null && this.mWebPlayerType == WebPlayerType.EXTERNAL_LINK) {
            this.mKidozWebView.setAlpha(0.0f);
            this.mLoadingProgressView = new LoadingProgressView(this.getContext());
            Point point = Utils.getScreenSize(this.getContext());
            int size = (int)((float)Math.min(point.x, point.y) * 0.25f);
            RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(size, size);
            prParams.addRule(13);
            this.addView(this.mLoadingProgressView, (ViewGroup.LayoutParams)prParams);
            this.mLoadingProgressView.startLoadingAnimation();
        }
    }

    private void initWebView() {
        int paddingTop;
        this.mKidozWebView = new KidozWebView(this.getContext(), this.mWebPlayerType);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        Point point = Utils.getScreenSize(this.getContext());
        params.topMargin = paddingTop = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
        this.addView((View)this.mKidozWebView, (ViewGroup.LayoutParams)params);
        this.mKidozWebView.setOnLounchExternalAppFromRedirect(new KidozWebView.IOnLounchExternalAppFromRedirectListener(){

            @Override
            public void onLounch() {
                if (WebPlayerView.this.mRemoveViewRequestListener != null) {
                    WebPlayerView.this.mRemoveViewRequestListener.onRemoveView();
                }
            }
        });
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public void loadWebUrl(String url, String googlePlayAppId) {
        this.mKidozWebView.loadWebUrl(url, googlePlayAppId);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mKidozWebView != null) {
            this.mKidozWebView.stopLoading();
        }
    }

    public void setOnRemoveViewRequestListener(IOnRemoveViewRequestListener listener) {
        this.mRemoveViewRequestListener = listener;
    }

    public void releaseAndcloseView() {
        if (this.mKidozWebView != null) {
            this.mKidozWebView.stopAndReleaseWebView();
        }
        if (this.mLoadingProgressView != null) {
            this.mLoadingProgressView.stopLoadingAnimation();
        }
    }

    public static interface IOnRemoveViewRequestListener {
        public void onRemoveView();
    }
}

