/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.content.Context;
import android.content.SharedPreferences;

public class SharedPreferencesUtils {
    private static final String SDK_SHARED_PREFERENCES_FILE_NAME = "SDK_SHARED_PREFERENCES_FILE_NAME";

    public static void saveSharedPreferencesData(Context context, String key, String value, int mode) {
        if (context != null) {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, mode);
            if (key != null) {
                SharedPreferences.Editor editor = settings.edit();
                editor.putString(key, value);
                editor.apply();
            }
        }
    }

    public static String loadSharedPreferencesData(Context context, String key, int mode) {
        String result = null;
        if (context != null && key != null) {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, mode);
            result = settings.getString(key, null);
        }
        return result;
    }

    public static String loadSharedPreferencesData(Context context, String key, String defaultVal, int mode) {
        String result = null;
        if (context != null && key != null) {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, mode);
            result = settings.getString(key, defaultVal);
        }
        return result;
    }

    public static void removeSharedPreferencesData(Context context, String key, int mode) {
        if (context != null && key != null) {
            SharedPreferences settings = context.getSharedPreferences(SDK_SHARED_PREFERENCES_FILE_NAME, mode);
            SharedPreferences.Editor editor = settings.edit();
            editor.remove(key);
            editor.apply();
        }
    }

    public static void saveSharedPreferencesData(Context context, String key, String value) {
        if (context != null) {
            SharedPreferencesUtils.saveSharedPreferencesData(context, key, value, 0);
        }
    }

    public static String loadSharedPreferencesData(Context context, String key) {
        String result = null;
        if (context != null) {
            result = SharedPreferencesUtils.loadSharedPreferencesData(context, key, 0);
        }
        return result;
    }

    public static String loadSharedPreferencesData(Context context, String key, String defaultVal) {
        String result = null;
        if (context != null) {
            result = SharedPreferencesUtils.loadSharedPreferencesData(context, key, 0);
        }
        return result;
    }

    public static void removeSharedPreferencesData(Context context, String key) {
        if (context != null) {
            SharedPreferencesUtils.removeSharedPreferencesData(context, key, 0);
        }
    }
}

