/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.kidoz.sdk.api.general.database.BaseTable;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.IsEventRecord;

public class IsEventTable
extends BaseTable {
    private final String TAG = IsEventTable.class.getName();
    private static final String TABLE_NAME = "InstallEventTable";
    private static final String COLUMN_APP_ID = "COLUMN_APP_ID";
    private static final String COLUMN_PARAMS = "COLUMN_PARAMS";

    public IsEventTable(DatabaseManager databaseManager, Object syncObject) {
        super(databaseManager, syncObject);
    }

    public static synchronized void onCreate(SQLiteDatabase database) {
        if (database != null) {
            String CREATE_TABLE_STATEMENT = "CREATE TABLE InstallEventTable(COLUMN_APP_ID TEXT PRIMARY KEY,COLUMN_PARAMS TEXT)";
            database.execSQL(CREATE_TABLE_STATEMENT);
        }
    }

    public static synchronized void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        if (database == null || newVersion > oldVersion) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertRecord(IsEventRecord record) {
        if (this.mDBmanager != null && record != null) {
            Object object = this.mSyncObject;
            synchronized (object) {
                int rowsCount = 0;
                int rowID = -1;
                SQLiteDatabase database = null;
                try {
                    database = this.mDBmanager.openDatabase();
                    database.beginTransaction();
                    ContentValues values = new ContentValues();
                    values.put(COLUMN_APP_ID, record.getPackageName());
                    values.put(COLUMN_PARAMS, record.getStringParams());
                    rowID = (int)database.insertWithOnConflict(TABLE_NAME, null, values, 5);
                    if (rowID != -1) {
                        ++rowsCount;
                    }
                    database.yieldIfContendedSafely();
                    database.setTransactionSuccessful();
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(this.TAG, "Error when trying to insert sdk record data: " + ex.getMessage());
                }
                finally {
                    if (database != null) {
                        database.endTransaction();
                    }
                    this.mDBmanager.closeDatabase();
                }
                IsEventTable.printDBLog(BaseTable.DBactionType.INSERT, "InsertRecord", TABLE_NAME, rowsCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IsEventRecord getRecord(String packageName) {
        IsEventRecord record = null;
        if (this.mDBmanager != null) {
            Object object = this.mSyncObject;
            synchronized (object) {
                int rowsCount = 0;
                SQLiteDatabase database = null;
                try {
                    Cursor cursor;
                    database = this.mDBmanager.openDatabase();
                    String selection = null;
                    String[] selectionArgs = null;
                    if (packageName != null) {
                        selection = "COLUMN_APP_ID=?";
                        selectionArgs = new String[]{packageName};
                    }
                    if ((cursor = database.query(TABLE_NAME, null, selection, selectionArgs, null, null, null)) != null && cursor.getCount() > 0) {
                        rowsCount = cursor.getCount();
                        cursor.moveToFirst();
                        record = new IsEventRecord(cursor.getString(cursor.getColumnIndex(COLUMN_PARAMS)));
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                catch (Exception e) {
                    SDKLogger.printErrorLog(this.TAG, "Error when trying to load install record: " + e.getMessage());
                }
                finally {
                    this.mDBmanager.closeDatabase();
                }
                IsEventTable.printDBLog(BaseTable.DBactionType.LOAD, "load sdk record", TABLE_NAME, rowsCount);
            }
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteRecord(String packageName) {
        if (this.mDBmanager != null) {
            Object object = this.mSyncObject;
            synchronized (object) {
                int rowsCount = 0;
                int rowID = -1;
                if (packageName == null) {
                    this.clearTable(TABLE_NAME);
                } else {
                    SQLiteDatabase database = null;
                    try {
                        database = this.mDBmanager.openDatabase();
                        database.beginTransaction();
                        String selection = "COLUMN_APP_ID=?";
                        String[] selectionArgs = new String[]{packageName};
                        rowID = database.delete(TABLE_NAME, selection, selectionArgs);
                        if (rowID != -1) {
                            rowsCount = rowID;
                        }
                        database.yieldIfContendedSafely();
                        database.setTransactionSuccessful();
                    }
                    catch (Exception e) {
                        if (e != null) {
                            SDKLogger.printErrorLog(this.TAG, "Error when trying to delete sdk record: " + e.getMessage());
                        }
                    }
                    finally {
                        if (database != null) {
                            database.endTransaction();
                        }
                        this.mDBmanager.closeDatabase();
                    }
                    IsEventTable.printDBLog(BaseTable.DBactionType.DELETE, "Delete Install App SDK record", TABLE_NAME, rowsCount);
                }
            }
        }
    }
}

