/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.kidoz.sdk.api.general.database.BaseTable;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import java.util.Iterator;
import org.json.JSONObject;

public class ConfigurationTable
extends BaseTable {
    private final String TAG = ConfigurationTable.class.getName();
    public static final String TABLE_NAME = "PropertiesTable";
    private static final String COLUMN_PROPERTY_KEY = "COLUMN_PROPERTY_KEY";
    private static final String COLUMN_PROPERTY_VALUE = "COLUMN_PROPERTY_VALUE";

    public ConfigurationTable(DatabaseManager databaseManager, Object mSyncObject) {
        super(databaseManager, mSyncObject);
    }

    public static synchronized void onCreate(SQLiteDatabase database) {
        if (database != null) {
            String CREATE_TABLE_STATEMENT = "CREATE TABLE PropertiesTable(COLUMN_PROPERTY_KEY TEXT PRIMARY KEY ,COLUMN_PROPERTY_VALUE TEXT)";
            database.execSQL(CREATE_TABLE_STATEMENT);
        }
    }

    public static synchronized void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        if (database == null || newVersion > oldVersion) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertAppProperties(PropertiesObj propertiesObj) {
        if (this.mDBmanager != null && propertiesObj != null && propertiesObj.getProperties() != null && propertiesObj.getProperties().length() > 0) {
            Object object = this.mSyncObject;
            synchronized (object) {
                int rowsCount = 0;
                int rowID = -1;
                SQLiteDatabase database = null;
                try {
                    database = this.mDBmanager.openDatabase();
                    database.beginTransaction();
                    ContentValues values = new ContentValues();
                    JSONObject jsonObject = propertiesObj.getProperties();
                    Iterator it = jsonObject.keys();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        values.put(COLUMN_PROPERTY_KEY, key);
                        values.put(COLUMN_PROPERTY_VALUE, jsonObject.getString(key));
                        rowID = (int)database.insertWithOnConflict(TABLE_NAME, null, values, 5);
                        if (rowID == -1) continue;
                        ++rowsCount;
                    }
                    database.yieldIfContendedSafely();
                    database.setTransactionSuccessful();
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(this.TAG, "Error when trying to insert app properties : " + ex.getMessage());
                }
                finally {
                    if (database != null && database.inTransaction()) {
                        database.endTransaction();
                    }
                    this.mDBmanager.closeDatabase();
                }
                ConfigurationTable.printDBLog(BaseTable.DBactionType.INSERT, "insertAppProperties", TABLE_NAME, rowsCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertProperties(String key, JSONObject jsonObject) {
        if (this.mDBmanager != null && jsonObject != null && key != null) {
            Object object = this.mSyncObject;
            synchronized (object) {
                int rowsCount = 0;
                int rowID = -1;
                SQLiteDatabase database = null;
                try {
                    database = this.mDBmanager.openDatabase();
                    database.beginTransaction();
                    ContentValues values = new ContentValues();
                    values.put(COLUMN_PROPERTY_KEY, key);
                    values.put(COLUMN_PROPERTY_VALUE, jsonObject.toString());
                    rowID = (int)database.insertWithOnConflict(TABLE_NAME, null, values, 5);
                    database.yieldIfContendedSafely();
                    database.setTransactionSuccessful();
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(this.TAG, "Error when trying to insert properties : " + ex.getMessage());
                }
                finally {
                    if (database != null && database.inTransaction()) {
                        database.endTransaction();
                    }
                    this.mDBmanager.closeDatabase();
                }
                ConfigurationTable.printDBLog(BaseTable.DBactionType.INSERT, "insertProperties", TABLE_NAME, rowsCount);
            }
        }
    }

    public synchronized void insertAppPropertiesAsync(final PropertiesObj propertiesObj) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ConfigurationTable.this.insertAppProperties(propertiesObj);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PropertiesObj loadAppProperties() {
        PropertiesObj serverPropertiesObj = null;
        if (this.mDBmanager != null) {
            Object object = this.mSyncObject;
            synchronized (object) {
                int rowsCount = 0;
                SQLiteDatabase database = null;
                try {
                    database = this.mDBmanager.openDatabase();
                    Cursor cursor = database.query(TABLE_NAME, null, null, null, null, null, null);
                    if (cursor != null && cursor.getCount() > 0) {
                        JSONObject jsonObject = new JSONObject();
                        cursor.moveToFirst();
                        do {
                            jsonObject.put(cursor.getString(cursor.getColumnIndex(COLUMN_PROPERTY_KEY)), (Object)cursor.getString(cursor.getColumnIndex(COLUMN_PROPERTY_VALUE)));
                        } while (cursor.moveToNext());
                        cursor.close();
                        serverPropertiesObj = new PropertiesObj(jsonObject);
                    }
                }
                catch (Exception e) {
                    SDKLogger.printErrorLog(this.TAG, "Error when trying to load app properties: " + e.getMessage());
                }
                finally {
                    this.mDBmanager.closeDatabase();
                }
                ConfigurationTable.printDBLog(BaseTable.DBactionType.LOAD, "loadAppProperties", TABLE_NAME, rowsCount);
            }
        }
        return serverPropertiesObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JSONObject loadProperties(String key) {
        JSONObject result = null;
        if (this.mDBmanager != null && key != null) {
            Object object = this.mSyncObject;
            synchronized (object) {
                int rowsCount = 0;
                SQLiteDatabase database = null;
                try {
                    database = this.mDBmanager.openDatabase();
                    String selection = "COLUMN_PROPERTY_KEY=?";
                    String[] selectionArgs = new String[]{key};
                    Cursor cursor = database.query(TABLE_NAME, null, selection, selectionArgs, null, null, null);
                    if (cursor != null && cursor.getCount() > 0) {
                        cursor.moveToFirst();
                        result = new JSONObject(cursor.getString(cursor.getColumnIndex(COLUMN_PROPERTY_VALUE)));
                        cursor.close();
                    }
                }
                catch (Exception e) {
                    SDKLogger.printErrorLog(this.TAG, "Error when trying to load properties: " + e.getMessage());
                }
                finally {
                    this.mDBmanager.closeDatabase();
                }
                ConfigurationTable.printDBLog(BaseTable.DBactionType.LOAD, "loadProperties", TABLE_NAME, rowsCount);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String deleteProperty(String propertyKey) {
        String result = null;
        Object object = this.mSyncObject;
        synchronized (object) {
            if (propertyKey != null) {
                int rowsCount = 0;
                int rowID = -1;
                SQLiteDatabase database = null;
                try {
                    database = this.mDBmanager.openDatabase();
                    String selection = "COLUMN_PROPERTY_KEY=?";
                    String[] selectionArgs = new String[]{propertyKey};
                    rowID = database.delete(TABLE_NAME, selection, selectionArgs);
                    if (rowID != -1) {
                        rowsCount = rowID;
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.mDBmanager.closeDatabase();
                }
                ConfigurationTable.printDBLog(BaseTable.DBactionType.DELETE, "deleteProperty", TABLE_NAME, rowsCount);
            }
        }
        return result;
    }

    public synchronized void deleteProperties() {
        if (this.mDBmanager != null) {
            this.clearTable(TABLE_NAME);
        }
    }
}

