/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.assets_handling;

import android.content.Context;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import java.io.File;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class SoundAssetsUtils {
    private static final String TAG = SoundAssetsUtils.class.getSimpleName();
    public static final String SOUND_ASSETS_SYNCED_FLAG = "SOUND_ASSETS_SYNCED_FLAG";
    private static final String DATA = "data";
    private static final String SOUNDS = "sounds";

    public static boolean parseSounds(Context context, String dataResponse) {
        boolean result = false;
        if (dataResponse != null) {
            try {
                JSONArray soundsArray;
                JSONObject rootObject = new JSONObject(dataResponse);
                JSONObject data = rootObject.optJSONObject(DATA);
                if (data != null && (soundsArray = data.optJSONArray(SOUNDS)) != null) {
                    HashMap<String, Integer> keysHashMap = new HashMap<String, Integer>();
                    JSONArray keysJSONArray = soundsArray.getJSONArray(0);
                    for (int keyIndex = 0; keyIndex < keysJSONArray.length(); ++keyIndex) {
                        keysHashMap.put(keysJSONArray.getString(keyIndex), keyIndex);
                    }
                    JSONArray parentalLockConfiguration = new JSONArray();
                    for (int soundIndex = 1; soundIndex < soundsArray.length(); ++soundIndex) {
                        result = false;
                        JSONArray nextJSONArray = soundsArray.getJSONArray(soundIndex);
                        String action = nextJSONArray.getString(((Integer)keysHashMap.get("action")).intValue());
                        String soundURL = nextJSONArray.getString(((Integer)keysHashMap.get("soundURL")).intValue());
                        if (action.equals("ItemClick")) {
                            result = BaseConnectionClient.downloadAndSaveFile(soundURL, SoundAssetsUtils.getSoundAssetFile(context, SOUND_ASSET_TYPE.ITEM_CLICK));
                            continue;
                        }
                        if (!action.equals("FamilyPanelView")) continue;
                        result = BaseConnectionClient.downloadAndSaveFile(soundURL, SoundAssetsUtils.getSoundAssetFile(context, SOUND_ASSET_TYPE.FAMILY_PANEL_VIEW));
                    }
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to parse lock icons: " + ex.getMessage());
            }
        }
        return result;
    }

    public static File getSoundAssetFile(Context context, SOUND_ASSET_TYPE soundAssetType) {
        File result = null;
        if (soundAssetType != null) {
            File directory = context.getFilesDir();
            switch (soundAssetType) {
                case ITEM_CLICK: {
                    result = new File(directory, "ItemClick.mp3");
                }
            }
        }
        return result;
    }

    public static enum SOUND_ASSET_TYPE {
        ITEM_CLICK,
        FAMILY_PANEL_VIEW;

    }
}

