/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.FeedView;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.custom_drawables.KidozLogoDrawable;
import com.kidoz.sdk.api.ui_views.interstitial.LocalIntrst;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.io.File;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class FeedButton
extends RelativeLayout {
    private static final String TAG = FeedButton.class.getSimpleName();
    private static final float BUTTON_SIZE_AS_SCREEN_PORTION = 0.2f;
    private AssetView mAssetView;
    private RelativeLayout.LayoutParams mAssetViewParams;
    private RelativeLayout.LayoutParams mContainerParams;
    private ExtendedFeedView mFeedView;
    private View mRootView;
    private int mDeveloperSize = -1;
    private boolean mSizeInitFinished = false;
    private JSONObject mJsonObject;
    private boolean mIsFeedButtonReady = false;
    private boolean mIsAutoShowFeedButton = true;
    protected LocalIntrst mInterstitial;

    public FeedButton(Context context) {
        super(context);
        this.initView(context);
    }

    public FeedButton(Context context, int size) {
        super(context);
        this.mDeveloperSize = size;
        this.initView(context);
    }

    public FeedButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public FeedButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        this.setVisibility(8);
        this.mIsAutoShowFeedButton = true;
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.mRootView = this;
        int size = FeedButton.getDefaultButtonSize(context);
        if (this.mDeveloperSize != -1) {
            size = this.mDeveloperSize;
        }
        this.mAssetView = new AssetView(context);
        this.mAssetView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mAssetViewParams = new RelativeLayout.LayoutParams(size, size);
        this.mDeveloperSize = size;
        this.addView((View)this.mAssetView, (ViewGroup.LayoutParams)this.mAssetViewParams);
        this.mContainerParams = new RelativeLayout.LayoutParams(size, size);
        this.setLayoutParams((ViewGroup.LayoutParams)this.mContainerParams);
        if (!this.isInEditMode()) {
            this.initFeedView(this.getContext());
        } else {
            this.mAssetView.loadAsset(new File(""), new KidozLogoDrawable(), null);
        }
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_FEED_BUTTON) {
            this.loadExistingAssetsIfExists();
            if (EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().unregister((Object)this);
            }
        }
    }

    private void loadButtonStyle(JSONObject jsonObject) {
        this.mJsonObject = jsonObject;
        int size = FeedButton.getDefaultButtonSize(this.getContext());
        if (this.mDeveloperSize != -1) {
            size = this.mDeveloperSize;
        }
        if (this.mDeveloperSize == -1 || jsonObject.optInt("overrideUserProperties", 0) == 1) {
            float scale = (float)jsonObject.optDouble("feedButtonScale", (double)0.2f);
            Point point = Utils.getScreenSize(this.getContext());
            size = (int)((float)Math.min(point.x, point.y) * scale);
        }
        this.mAssetViewParams.width = size;
        this.mAssetViewParams.height = size;
        this.mContainerParams.width = size;
        this.mContainerParams.height = size;
        this.mSizeInitFinished = true;
        String fileKEy = jsonObject.optString("feedButton");
        this.mAssetView.loadAsset(AssetUtil.getAssetFile(this.getContext(), fileKEy), new KidozLogoDrawable(), new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                if (FeedButton.this.mIsAutoShowFeedButton) {
                    FeedButton.this.showFeedButton();
                }
            }
        });
    }

    private void showFeedButton() {
        if (this.getVisibility() != 0) {
            GenAnimator.playGrowAnimation((View)this, 300L, 0L, (Interpolator)new AccelerateDecelerateInterpolator(), new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    if (FeedButton.this.mIsAutoShowFeedButton) {
                        FeedButton.this.setVisibility(0);
                    }
                    FeedButton.this.requestFocus();
                    FeedButton.this.bringToFront();
                }

                public void onAnimationEnd(Animator animation) {
                    FeedButton.this.requestFocus();
                    FeedButton.this.bringToFront();
                    EventManager.getInstance(FeedButton.this.getContext()).logEvent(FeedButton.this.getContext(), WidgetType.WIDGET_TYPE_FEED.getStringValue(), null, EventManager.LOG_CRITICAL_LEVEL, "SDK", "Button View", "Feed Button View");
                    FeedButton.this.mIsFeedButtonReady = true;
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility != 0) {
            this.mIsAutoShowFeedButton = false;
        } else if (this.mIsFeedButtonReady) {
            EventManager.getInstance(this.getContext()).logEvent(this.getContext(), WidgetType.WIDGET_TYPE_FEED.getStringValue(), null, EventManager.LOG_CRITICAL_LEVEL, "SDK", "Button View", "Feed Button View");
        }
    }

    private void loadExistingAssetsIfExists() {
        JSONObject jsonObject;
        if (KidozSDK.isInitialised() && (jsonObject = DatabaseManager.getInstance(this.getContext()).getConfigTable().loadProperties(FeedView.TAG)) != null) {
            if (jsonObject.optInt("lounchInterstitialOnOpen", 0) == 1 && this.mInterstitial == null) {
                this.mInterstitial = new LocalIntrst(this.getContext());
            }
            this.loadButtonStyle(jsonObject);
        }
    }

    private void initClickListener() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FeedButton.this.mFeedView != null) {
                    GenAnimator.clickItemAnimation(FeedButton.this.mRootView, 70, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            FeedButton.this.mFeedView.showView();
                            if (FeedButton.this.mInterstitial != null) {
                                FeedButton.this.mInterstitial.loadAd();
                            }
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            }
        });
    }

    private void initFeedView(Context context) {
        this.mFeedView = new ExtendedFeedView(new FeedView.Builder(context));
        this.initClickListener();
    }

    public FeedView getFeedView() {
        if (this.mFeedView == null) {
            this.initFeedView(this.getContext());
        }
        return this.mFeedView;
    }

    public void setFeedButtonSize(int sizePx) {
        boolean allowChange = true;
        if (this.mSizeInitFinished && this.mJsonObject != null && this.mJsonObject.optInt("overrideUserProperties", 0) == 1) {
            allowChange = false;
        }
        if (allowChange) {
            this.mDeveloperSize = sizePx;
            if (this.mAssetViewParams != null) {
                this.mAssetViewParams.width = sizePx;
                this.mAssetViewParams.height = sizePx;
                this.mContainerParams.width = sizePx;
                this.mContainerParams.height = sizePx;
            }
        }
    }

    public void setFeedButtonSizeDp(int sizeDp) {
        int sizePx = Utils.dpTOpx(this.getResources(), (float)sizeDp);
        boolean allowChange = true;
        if (this.mSizeInitFinished && this.mJsonObject != null && this.mJsonObject.optInt("overrideUserProperties", 0) == 1) {
            allowChange = false;
        }
        if (allowChange) {
            this.mDeveloperSize = sizePx;
            if (this.mAssetViewParams != null) {
                this.mAssetViewParams.width = sizePx;
                this.mAssetViewParams.height = sizePx;
                this.mContainerParams.width = sizePx;
                this.mContainerParams.height = sizePx;
            }
        }
    }

    public int getButtonSize() {
        if (this.mDeveloperSize == -1) {
            return 0;
        }
        return this.mDeveloperSize;
    }

    private static int getDefaultButtonSize(Context context) {
        Point point = Utils.getScreenSize(context);
        return (int)((float)Math.min(point.x, point.y) * 0.2f);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (KidozSDK.isInitialised() && !this.isInEditMode() && (visibility == 8 || visibility == 4)) {
            EventManager.getInstance(this.getContext()).startEventsSync(this.getContext());
        }
    }

    class ExtendedFeedView
    extends FeedView {
        public ExtendedFeedView(FeedView.Builder builder) {
            super(builder);
        }

        @Override
        public void showView() {
            this.mIsAutomaticInvocation = false;
            this.mShowWhenInitiated = false;
            if (KidozSDK.isInitialised()) {
                super.openSimpleDialog();
            } else {
                this.mShowWhenInitiated = true;
            }
        }
    }
}

