/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.events;

import android.content.Context;
import android.os.AsyncTask;
import com.kidoz.events.EventBulk;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import java.lang.ref.WeakReference;

public class EventSyncAsyncTask
extends AsyncTask<Void, Void, Void> {
    private static final String TAG = EventSyncAsyncTask.class.getSimpleName();
    private static final int MAX_ITERATION_TIMES_IN_SINGLE_SYNC = 3;
    WeakReference<Context> weakActivity = null;

    public EventSyncAsyncTask(Context context) {
        this.weakActivity = new WeakReference<Context>(context);
    }

    protected Void doInBackground(Void ... params) {
        try {
            SDKLogger.printWarningLog(" ----------------------  ********************* ----------------------");
            SDKLogger.printWarningLog(" -----------------    START EVENTS SYNCING THREAD ---------------------");
            SDKLogger.printWarningLog(" ----------------------  ******************** ----------------------");
            if (this.weakActivity != null) {
                Context mContext = (Context)this.weakActivity.get();
                if (mContext != null) {
                    for (int iterCount = 3; EventManager.getInstance(mContext).getIsNeedEventsSync(mContext) && iterCount > 0; --iterCount) {
                        EventBulk bulk = EventManager.getInstance(mContext).getNextBulk(mContext);
                        if (bulk != null) {
                            String json = bulk.toString();
                            SDKLogger.printInfoLog("Log Events Sync info : bulk value:" + json);
                            if (json != null) {
                                ResultData<Boolean> resultCallback = SdkAPIManager.getSdkApiInstance(mContext).sendKidozEventsToServerNotAsync(json);
                                if (resultCallback != null && resultCallback.getResponseStatus().getIsSuccessful()) {
                                    EventManager.getInstance(mContext).removeBulkFromDB(mContext, bulk);
                                    continue;
                                }
                                SDKLogger.printInfoLog(TAG, "Log Events Sync Info : Server response failed ! Trying again...");
                                continue;
                            }
                            SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Couldn't create JSON representation of an Events BULK !");
                            break;
                        }
                        SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Events BULK object is NULL !");
                        break;
                    }
                }
            }
            if (this.weakActivity != null) {
                this.weakActivity.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

