/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.events;

import com.kidoz.sdk.api.general.utils.SDKLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONObject;

public class Event {
    private final String TAG = Event.class.getName();
    private JSONObject mJsonObject = new JSONObject();
    private String mRowID;
    private int mLogLevel;
    private int mCloseLevel;
    private int mResourceID;
    private long mCreationTime;

    public Event() {
        SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss", Locale.getDefault());
        mSimpleDateFormat.setTimeZone(TimeZone.getDefault());
        this.mCreationTime = System.currentTimeMillis();
        String logTimeUTC = String.valueOf(this.mCreationTime);
        String logTimeLocal = mSimpleDateFormat.format(new Date(System.currentTimeMillis()));
        try {
            this.mJsonObject.put("LogTimeUTC", (Object)logTimeUTC);
            this.mJsonObject.put("LogTimeLocal", (Object)logTimeLocal);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to add parameters to JsonObject: " + ex.getMessage());
        }
    }

    public void addParameterToJsonObject(String key, String value) {
        try {
            if (key != null && value != null) {
                this.mJsonObject.put(key, (Object)value);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to add parameter to JsonObject: " + ex.getMessage());
        }
    }

    public void addParameterToJsonObject(String key, int value) {
        try {
            this.mJsonObject.put(key, value);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to add parameter to JsonObject: " + ex.getMessage());
        }
    }

    public void addParameterToJsonObject(String key, long value) {
        try {
            this.mJsonObject.put(key, value);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to add parameter to JsonObject: " + ex.getMessage());
        }
    }

    public void addParameterToJsonObject(String jsonAsString) {
        try {
            if (jsonAsString != null) {
                if (this.mJsonObject == null) {
                    this.mJsonObject = new JSONObject(jsonAsString);
                } else {
                    JSONObject dataJson = new JSONObject(jsonAsString);
                    Iterator iterator = dataJson.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        try {
                            Object value = dataJson.get(key);
                            this.mJsonObject.put(key, value);
                            this.printData();
                        }
                        catch (Exception ex) {
                            SDKLogger.printErrorLog(this.TAG, "Error when trying to add iterate JsonObject: " + ex.getMessage());
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to add jsonAsString to JsonObject: " + ex.getMessage());
        }
    }

    public void setJsonObject(JSONObject jsonObject) {
        this.mJsonObject = jsonObject;
    }

    public JSONObject getJSONObject() {
        return this.mJsonObject;
    }

    public void setRowID(String rowID) {
        this.mRowID = rowID;
    }

    public String getRowID() {
        return this.mRowID;
    }

    public void setLogLevel(int logLevel) {
        this.mLogLevel = logLevel;
    }

    public int getLogLevel() {
        return this.mLogLevel;
    }

    public void setCloseLevel(int closeLevel) {
        this.mCloseLevel = closeLevel;
    }

    public int getCloseLevel() {
        return this.mCloseLevel;
    }

    public void setResourceID(int resourceID) {
        this.mResourceID = resourceID;
    }

    public int getResourceID() {
        return this.mResourceID;
    }

    public long getEventCreationTime() {
        return this.mCreationTime;
    }

    public void printData() {
        SDKLogger.printInfoLog(this.TAG, "*** KidozEvent ***");
        SDKLogger.printInfoLog(this.TAG, "Row ID = " + this.mRowID);
        SDKLogger.printInfoLog(this.TAG, "JsonObject= " + this.mJsonObject.toString());
    }
}

