package com.kidoz.sdk.api.ui_views.web_unit_view;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;

import org.json.JSONArray;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;

/**
 * Created by RonyBrosh on 6/2/2016.
 */
public class WebUnitView extends RelativeLayout
{
    private final String TAG = WebUnitView.class.getSimpleName();
    private final String WIDGET_TYPE = "6";

    private WebView mWebView;
    private Context mActivityContext;
    private WebUnitListener mWebUnitListener;
    private boolean mIsContentLoaded;
    private boolean mIsShuldBlockClicks;

    public WebUnitView(Context context)
    {
        super(context);
        initView();
    }

    public WebUnitView(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    public WebUnitView(Context context, AttributeSet attrs, int defStyleAttr)
    {
        super(context, attrs, defStyleAttr);
        initView();
    }

    public void setActivityContext(Context context)
    {
        mActivityContext = context;
    }

    public void setWebUnitListener(WebUnitListener webUnitListener)
    {
        mWebUnitListener = webUnitListener;
    }

    public void loadContent()
    {
        mIsContentLoaded = false;
        invokeJavaScript("javascript:loadContent()");
    }

    public boolean getIsContentLoaded()
    {
        return mIsContentLoaded;
    }

    public void show()
    {
        setVisibility(View.VISIBLE);
        invokeJavaScript("focusOn()");
    }

    public void close()
    {
        setVisibility(View.GONE);
        invokeJavaScript("focusOff()");
    }

    public void test()
    {
        invokeJavaScript("test()");
    }

    private void initView()
    {
        // 1. Init root view.
        initRootView();

        // 2. Init configuration view.
        initConfigurationView();

        // 3. Init web view.
        initWebView();

        // 4. Hide view.
        setVisibility(View.GONE);
    }

    private void initRootView()
    {
        setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
    }

    private void initWebView()
    {
        // 1. Create webview.
        mWebView = new WebView(getContext());

        // 2. Init webview settings.
        if (Build.VERSION.SDK_INT >= 17)
        {
            mWebView.getSettings().setMediaPlaybackRequiresUserGesture(true);
        }
        if (Build.VERSION.SDK_INT < 18)
        {
            mWebView.getSettings().setPluginState(WebSettings.PluginState.ON);
        }
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP_MR1)
        {
            mWebView.setLayerType(View.LAYER_TYPE_HARDWARE, null);
        }
        else
        {
            mWebView.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
        }
        if (Build.VERSION.SDK_INT >= 21)
        {
            mWebView.getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }
        if (Build.VERSION.SDK_INT >= 21)
        {
            mWebView.getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }

        mWebView.getSettings().setJavaScriptEnabled(true);

        mWebView.setDrawingCacheBackgroundColor(0x00000000);
        mWebView.setBackgroundColor(Color.TRANSPARENT);
        mWebView.setWebChromeClient(new WebChromeClient());
        mWebView.setWebViewClient(new WebViewClient());
        mWebView.addJavascriptInterface(new WebUnitViewJavaScript(), "WebUnitView");

        // 3. Add the webview.
        addView(mWebView, new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));

        //4. Load the html.
        mWebView.loadUrl(generateHtmlBannerURL());
    }

    private void initConfigurationView()
    {
        ConfigurationView configurationView = new ConfigurationView(getContext(), new ConfigurationView.ConfigurationViewInterface()
        {
            @Override
            public void onViewVisibilityChanged(boolean isVisible)
            {
                if (isVisible == true)
                {
                    invokeJavaScript("focusOn()");
                }
                else
                {
                    invokeJavaScript("focusOff()");
                }
            }
        });
        addView(configurationView);
    }

    private String generateHtmlBannerURL()
    {
        StringBuilder result = new StringBuilder();
        result.append("http://s3.amazonaws.com/kidoz.test.bucket/ronybrosh/test_html_view_builder/WebUnitView.html");
        result.append("?");
        result.append("publisher_id=");
        result.append(KidozSDK.getPublisherID());
        result.append("&package_id=");
        result.append(getContext().getPackageName());
        result.append("&style_id=");
        result.append("0");
        result.append("&version=");
        result.append(ConstantDef.SDK_VERSION);
        result.append("&os_version=");
        result.append(Build.VERSION.SDK_INT);
        result.append("&country_code=");
        result.append(Locale.getDefault().getCountry());
        result.append("&hash=");
        result.append(Utils.generateUniqeDeviceID(getContext().getPackageName(), KidozSDK.getPublisherID()));
        result.append("&device_lang=");
        result.append(String.valueOf(Locale.getDefault().getLanguage()));
        result.append("&widget_type=");
        result.append(WIDGET_TYPE);
        result.append("&auth_token=");
        result.append(KidozSDK.getAuthToken());

        return result.toString();
    }

    private void invokeJavaScript(String javaScriptMethod)
    {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT)
        {
            mWebView.evaluateJavascript(javaScriptMethod, null);
        }
        else
        {
            mWebView.loadUrl(javaScriptMethod);
        }
    }

    private final class WebUnitViewJavaScript
    {
        @android.webkit.JavascriptInterface
        public void setViewSize(final String width, final String height, final String xPoint, final String yPoint, final String alignmentFlags)
        {
            SDKLogger.printDebbugLog(TAG, "setViewSize: width = " + width + ", height = " + height + ", xPoint = " + xPoint + ", yPoint = " + yPoint + ", alignmentFlags = " + alignmentFlags);
            try
            {
                new Handler(Looper.getMainLooper()).post(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        try
                        {
                            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(Integer.parseInt(width), Integer.parseInt(height));

                            final int ALIGN_TOP = 0;
                            final int ALIGN_RIGHT = 1;
                            final int ALIGN_BOTTOM = 2;
                            final int ALIGN_LEFT = 3;
                            final int CENTER_HORIZONTAL = 4;
                            final int CENTER_VERTICAL = 5;
                            final int CENTER_IN_PARENT = 6;

                            JSONArray alignmentFlagsArray = new JSONArray(alignmentFlags);
                            if (alignmentFlagsArray != null)
                            {
                                for (int flagIndex = 0; flagIndex < alignmentFlagsArray.length(); flagIndex++)
                                {
                                    int nextFlag = alignmentFlagsArray.getInt(flagIndex);
                                    switch (nextFlag)
                                    {
                                        case ALIGN_TOP:
                                        {
                                            params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                                            break;
                                        }
                                        case ALIGN_RIGHT:
                                        {
                                            params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                                            break;
                                        }
                                        case ALIGN_BOTTOM:
                                        {
                                            params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                                            break;
                                        }
                                        case ALIGN_LEFT:
                                        {
                                            params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                                            break;
                                        }
                                        case CENTER_HORIZONTAL:
                                        {
                                            params.addRule(RelativeLayout.CENTER_HORIZONTAL);
                                            break;
                                        }
                                        case CENTER_VERTICAL:
                                        {
                                            params.addRule(RelativeLayout.CENTER_VERTICAL);
                                            break;
                                        }
                                        case CENTER_IN_PARENT:
                                        {
                                            params.addRule(RelativeLayout.CENTER_IN_PARENT);
                                            break;
                                        }
                                    }
                                }
                            }

                            mWebView.setLayoutParams(params);

                            final int NONE = -1;
                            int xPosition = Integer.parseInt(xPoint);
                            if (xPosition != NONE)
                            {
                                mWebView.setX(xPosition);
                            }

                            int yPosition = Integer.parseInt(yPoint);
                            if (yPosition != NONE)
                            {
                                mWebView.setY(yPosition);
                            }
                        }
                        catch (Exception ex)
                        {
                            SDKLogger.printErrorLog(TAG, "Error when trying to setViewSize: " + ex.getMessage());
                        }
                    }
                });
            }
            catch (Exception ex)
            {
                SDKLogger.printErrorLog(TAG, "Error setting webview size: " + ex.getMessage());
            }
        }

        @android.webkit.JavascriptInterface
        public void onContentLoaded()
        {
            mIsContentLoaded = true;
            if (mWebUnitListener != null)
            {
                new Handler(Looper.getMainLooper()).post(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        mWebUnitListener.onWebUnitContentLoaded();
                    }
                });
            }
        }

        @android.webkit.JavascriptInterface
        public void simulateClick(final String contentItemJson, final String positionIndex, final String styleID)
        {
            if (mWebUnitListener != null)
            {
                new Handler(Looper.getMainLooper()).post(new Runnable()
                {
                    @Override
                    public void run()
                    {

                        try
                        {
                            ContentItem item = null;
                            JSONArray jsonArray = new JSONArray(contentItemJson);
                            if (jsonArray != null && jsonArray.length() > 1)
                            {
                                JSONArray keysArray = jsonArray.getJSONArray(0);
                                HashMap<String, Integer> keysMap = new LinkedHashMap<String, Integer>();
                                if (keysArray != null && keysArray.length() > 0)
                                {
                                    for (int i = 0; i < keysArray.length(); i++)
                                    {
                                        keysMap.put(keysArray.getString(i), i);
                                    }
                                }

                                if (keysMap.isEmpty() == false && jsonArray.getJSONArray(1) != null)
                                {
                                    item = new ContentItem(jsonArray.getJSONArray(1), keysMap);
                                }
                            }

                            if (item != null)
                            {
                                if (mIsShuldBlockClicks == false)
                                {
                                    mIsShuldBlockClicks = true;
                                    if (mActivityContext != null)
                                    {
                                        ContentExecutionHandler.handleContentItemClick(mActivityContext, item, WIDGET_TYPE, styleID, Integer.parseInt(positionIndex), true, new ContentExecutionHandler.IOnHandleClickListener()
                                        {
                                            @Override
                                            public void onRestoreClick()
                                            {
                                                mIsShuldBlockClicks = false;
                                            }
                                        });
                                    }
                                }
                            }
                        }
                        catch (Exception ex)
                        {
                            SDKLogger.printDebbugLog(TAG, "Error when trying to simulate click: " + ex.getMessage());
                        }
                    }
                });
            }
        }

        @android.webkit.JavascriptInterface
        public void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex)
        {
            SDKLogger.printDebbugLog(TAG, "forwardToGooglePlay: advertiserID = " + advertiserID + ", appID = " + appID + ", googlePlayLink = " + googlePlayLink + ", widgetType = " + widgetType + ", styleID = " + styleID + ", itemIndex = " + itemIndex);

            if (mActivityContext != null)
            {
                try
                {
                    new Handler(Looper.getMainLooper()).post(new Runnable()
                    {
                        @Override
                        public void run()
                        {
                            int itemIndexAsInteger = 0;
                            try
                            {
                                itemIndexAsInteger = Integer.parseInt(itemIndex);
                            }
                            catch (Exception ex)
                            {
                                SDKLogger.printErrorLog(TAG, "Error when trying to parse item index: " + ex.getMessage());
                            }
                            ContentItem contentItem = new ContentItem();
                            contentItem.setId(appID);
                            contentItem.setName("");
                            contentItem.setData(googlePlayLink);
                            contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
                            contentItem.setAdvertiserID(advertiserID);
                            contentItem.setIsPromoted(true);

                            ContentExecutionHandler.handleContentItemClick(mActivityContext, contentItem, widgetType, styleID, itemIndexAsInteger, false, null);
                        }
                    });
                }
                catch (Exception ex)
                {
                    SDKLogger.printErrorLog(TAG, "Error when trying to forward to google play: " + ex.getMessage());
                }
            }
        }
    }
}
