package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Point;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.custom_drawables.DefaultPanelDrawable;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

import java.io.File;

/**
 * Created by Eugine on 12/10/2015.
 */
class PanelHandle extends RelativeLayout
{

    public enum PANEL_HANDLE_VIEW_STATE
    {
        OPENED, CLOSED
    }

    private static final float DEFAULT_HANDLE_SCALE_SIZE = 0.15f;
    private AssetView mOpenAssetView;
    private AssetView mOpenSposoredAssetView;
    private AssetView mCloseAssetView;
    private AssetView mThumbnailAssetView;
    private RelativeLayout.LayoutParams mInnerOpenBtnLayParams;
    private RelativeLayout.LayoutParams mInnerCloseBtnLayParams;
    private RelativeLayout.LayoutParams mThumbnailLayParams;

    private DefaultPanelDrawable mOpenDefaultDrawable;
    private DefaultPanelDrawable mCloseDefaultDrawable;

    private int mHandleSize = 0;
    private PANEL_TYPE mPanelType;
    private int mAnimType = 1;
    private int mColor = Color.WHITE;
    private float mThumbFactor = 0.5f;

    private IOnPanelHandleClickListener mClickListener;
    private PANEL_HANDLE_VIEW_STATE mPanelHandleViewState;

    public PanelHandle(Context context, PANEL_TYPE panelType, int animationType, int size, float thumbFactor, IOnPanelHandleClickListener handleClickListener)
    {
        super(context);
        mHandleSize = size;
        mPanelType = panelType;
        mClickListener = handleClickListener;
        mAnimType = animationType;
        mThumbFactor = thumbFactor;
        initHandle();
    }

    private void initHandle()
    {

        if (mHandleSize == 0)
        {
            Point point = Utils.getScreenSize(getContext());
            mHandleSize = (int) (Math.min(point.x, point.y) * DEFAULT_HANDLE_SCALE_SIZE);
        }

        mInnerOpenBtnLayParams = new RelativeLayout.LayoutParams(mHandleSize, mHandleSize);
        mInnerCloseBtnLayParams = new RelativeLayout.LayoutParams(mHandleSize, mHandleSize);
        mThumbnailLayParams = new RelativeLayout.LayoutParams((int) (mHandleSize * mThumbFactor), (int) (mHandleSize * mThumbFactor));
        mThumbnailLayParams.addRule(RelativeLayout.CENTER_IN_PARENT);

        mOpenAssetView = new AssetView(getContext());
        mOpenAssetView.setVisibility(View.INVISIBLE);
        mOpenSposoredAssetView = new AssetView(getContext());
        mOpenSposoredAssetView.setVisibility(View.INVISIBLE);
        mCloseAssetView = new AssetView(getContext());
        mCloseAssetView.setVisibility(View.INVISIBLE);

        mThumbnailAssetView = new AssetView(getContext());
        mThumbnailAssetView.setVisibility(View.INVISIBLE);
        mThumbnailAssetView.setScaleType(ImageView.ScaleType.CENTER_CROP);

        addView(mThumbnailAssetView, mThumbnailLayParams);
        addView(mOpenAssetView, mInnerOpenBtnLayParams);
        addView(mOpenSposoredAssetView, mInnerOpenBtnLayParams);
        addView(mCloseAssetView, mInnerCloseBtnLayParams);

        setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                playHandleClickAnimation(v);
            }
        });
    }

    /**
     * @param openViewAsset  the asset in the closed state (Button that says OPEN me)
     * @param closeViewAsset the asset in the opemed state (Button that says CLOSE me)
     * @param listener       prepared listener
     */
    public void loadAssets(final File openViewAsset, final File closeViewAsset, final File sponsoredAsset, final IonPanelHandlePreparedListener listener)
    {
        mOpenDefaultDrawable = new DefaultPanelDrawable(getContext(), mPanelType, DefaultPanelDrawable.PanelDrawableType.OPEN_VIEW);
        mCloseDefaultDrawable = new DefaultPanelDrawable(getContext(), mPanelType, DefaultPanelDrawable.PanelDrawableType.CLOSE_VIEW);

        mOpenDefaultDrawable.setBaseColor(mColor);
        mCloseDefaultDrawable.setBaseColor(mColor);

        if (openViewAsset != null)
        {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(openViewAsset.getAbsolutePath(), options);
            if (options.outHeight != 0 && options.outWidth != 0)
            {
                float ratio = options.outHeight / ((float) options.outWidth);
                int size = (int) (mHandleSize * ratio);
                if (size != 0)
                {
                    mInnerOpenBtnLayParams.height = size;
                }
            }
        }

        if (closeViewAsset != null)
        {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(closeViewAsset.getAbsolutePath(), options);
            if (options.outHeight != 0 && options.outWidth != 0)
            {
                float ratio = options.outHeight / ((float) options.outWidth);
                int size = (int) (mHandleSize * ratio);
                if (size != 0)
                {
                    mInnerCloseBtnLayParams.height = size;
                }
            }
        }

        mOpenAssetView.loadAsset(openViewAsset, mOpenDefaultDrawable, new AssetView.IOnAssetLoadedListener()
        {
            @Override
            public void onAssetLoaded(boolean successfull)
            {
                if (successfull == false)
                {
                    mOpenSposoredAssetView.loadAsset(sponsoredAsset, null, new AssetView.IOnAssetLoadedListener()
                    {
                        @Override
                        public void onAssetLoaded(boolean successfull)
                        {
                            if (successfull)
                            {
                                mOpenDefaultDrawable.setDrawXImage(false);
                            } else
                            {
                                mOpenDefaultDrawable.setDrawXImage(true);
                                mOpenSposoredAssetView.setVisibility(View.INVISIBLE);
                            }

                            mCloseAssetView.loadAsset(closeViewAsset, mCloseDefaultDrawable, new AssetView.IOnAssetLoadedListener()
                            {
                                @Override
                                public void onAssetLoaded(boolean successfull)
                                {
                                    if (listener != null)
                                    {
                                        listener.onPanelPrepared();
                                    }
                                }
                            });
                        }
                    });
                } else
                {
                    mCloseAssetView.loadAsset(closeViewAsset, mCloseDefaultDrawable, new AssetView.IOnAssetLoadedListener()
                    {
                        @Override
                        public void onAssetLoaded(boolean successfull)
                        {
                            if (listener != null)
                            {
                                listener.onPanelPrepared();
                            }
                        }
                    });
                }
            }
        });
    }

    public void setBaseColor(int baseColor)
    {
        mColor = baseColor;
        if (mOpenDefaultDrawable != null && mCloseDefaultDrawable != null)
        {
            mOpenDefaultDrawable.setBaseColor(baseColor);
            mCloseDefaultDrawable.setBaseColor(baseColor);
        }
        mOpenAssetView.postInvalidate();
        mCloseAssetView.postInvalidate();
    }

    public void setPanelType(PANEL_TYPE panelType)
    {
        mPanelType = panelType;
        if (mOpenDefaultDrawable != null && mCloseDefaultDrawable != null)
        {
            mCloseDefaultDrawable.setPanelType(mPanelType);
            mOpenDefaultDrawable.setPanelType(mPanelType);
        }
        mOpenAssetView.postInvalidate();
        mCloseAssetView.postInvalidate();
    }

    public interface IOnPanelHandleClickListener
    {
        void onHandleClick();
    }

    public void setPanelButtonState(PANEL_HANDLE_VIEW_STATE panelHandleState)
    {
        mPanelHandleViewState = panelHandleState;

        switch (mPanelHandleViewState)
        {
            case CLOSED:
            {
                mOpenAssetView.setVisibility(View.VISIBLE);
                mThumbnailAssetView.setVisibility(View.VISIBLE);
                mCloseAssetView.setVisibility(View.INVISIBLE);

                mOpenSposoredAssetView.setVisibility(View.VISIBLE);
                break;
            }

            case OPENED:
            {
                mOpenAssetView.setVisibility(View.INVISIBLE);
                mThumbnailAssetView.setVisibility(View.INVISIBLE);
                mCloseAssetView.setVisibility(View.VISIBLE);

                mOpenSposoredAssetView.setVisibility(View.INVISIBLE);
                break;
            }
        }
        postInvalidate();
    }

    private void playHandleClickAnimation(View v)
    {
        switch (mAnimType)
        {
            case 1:
            {
                GenAnimator.playPanelButtonClickAnimation(v, mPanelType, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {
                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        if (mClickListener != null)
                        {
                            mClickListener.onHandleClick();
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {
                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {
                    }
                });
                break;
            }
            default:
            {
                GenAnimator.playPanelButtonClickAnimation(v, mPanelType, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {
                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        if (mClickListener != null)
                        {
                            mClickListener.onHandleClick();
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {
                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {
                    }
                });
                break;
            }
        }
    }

    public interface IonPanelHandlePreparedListener
    {
        void onPanelPrepared();
    }

    public AssetView getThumbLayerAsset()
    {
        return mThumbnailAssetView;
    }
}
/* private void setHandleCorrectRotation() {
        switch (mPanelType) {
            case BOTTOM: {
                mOpenAssetView.setRotation(0f);
                mCloseAssetView.setRotation(0f);
                break;
            }
            case TOP: {
                mOpenAssetView.setRotation(180f);
                mCloseAssetView.setRotation(180f);
                break;
            }
            case LEFT: {

                mOpenAssetView.setRotation(90f);
                mCloseAssetView.setRotation(90f);
                break;
            }
            case RIGHT: {
                mOpenAssetView.setRotation(-90f);
                mCloseAssetView.setRotation(-90f);
                break;
            }
        }
    }*/
