package com.kidoz.sdk.api.ui_views.interstitial;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class KidozAdActivity extends Activity
{
    public static final String STYLE_ID_KEY = "styleId";

    protected HtmlViewWrapper mWebView;
    protected RelativeLayout mInnerContainer;
    protected int mBgColor = Color.BLACK;
    private boolean mIsImmersive = true;
    private boolean mIsFirstLaunch = true;

    private Utils.StaticHandler mHandler;
    private IntrstWrapper.InnerHelperInterface mInnerHelperInterface;

    @Override
    public void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        if(Build.VERSION.SDK_INT < 18)
        {
            mWebView.setVisibility(View.INVISIBLE);
            mHandler.postDelayed(new Runnable()
            {
                @Override
                public void run()
                {
                    mWebView.setVisibility(View.VISIBLE);
                    mWebView.bringToFront();
                }
            }, 500);
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        if (EventBus.getDefault().isRegistered(this) == false)
        {
            EventBus.getDefault().register(this);
        }

        setTheme(android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);

        getWindow().setFlags(WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED, WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED);

        mHandler = new Utils.StaticHandler(getMainLooper());
        Intent intent = getIntent();
        if (intent != null)
        {
            mInnerHelperInterface = IntrstWrapper.initInstance(this).getHelperInterface();

            String styleId = intent.getStringExtra(STYLE_ID_KEY);

            mWebView = HtmlManager.getIntrstDefaultHtmlView(this);
            if (mWebView != null)
            {
                mWebView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                mWebView.setStyleID(styleId);
                mWebView.setInFocusActivityContext(KidozAdActivity.this);
                if(Build.VERSION.SDK_INT < 16)
                {
                    mWebView.setLayerType(View.LAYER_TYPE_NONE, null);
                }
                mInnerContainer = new RelativeLayout(this);
                mInnerContainer.setBackgroundColor(mBgColor);
                mInnerContainer.addView(mWebView, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));
                setContentView(mInnerContainer, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

                EventManager.getInstance(this).logEvent(this, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), styleId, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.INTERSTITIAL_VIEW);

                if (mInnerHelperInterface != null)
                {
                    mInnerHelperInterface.onAdOpen();
                }
            }
            else
            {
                finish();
            }
        }
        else
        {
            finish();
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus)
    {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus)
        {
            if (mIsImmersive)
            {
                applyImmersiveMode();
            }
        }
    }

    private void applyImmersiveMode()
    {
        int flags = View.SYSTEM_UI_FLAG_HIDE_NAVIGATION;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
        {
            flags = View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN;
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT)
        {
            flags = View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
        }

        getWindow().getDecorView().setSystemUiVisibility(flags);
    }

    @Override
    protected void onResume()
    {
        super.onResume();
        if (mWebView != null)
        {
            if (mIsFirstLaunch == true)
            {
                mIsFirstLaunch = false;
                mWebView.startVastAd();
            }
            else
            {
                mWebView.resumeVastAd();
            }

            if(Build.VERSION.SDK_INT < 18)
            {
                mWebView.setVisibility(View.INVISIBLE);
                mHandler.postDelayed(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        mWebView.setVisibility(View.VISIBLE);
                        mWebView.bringToFront();
                    }
                }, 500);
            }
            else
            {
                mHandler.postDelayed(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        mWebView.bringToFront();
                    }
                }, 200);
            }
        }
    }

    @Override
    protected void onPause()
    {
        mHandler.removeCallbacksAndMessages(null);
        if (mWebView != null)
        {
            mWebView.pauseVastAd();
        }



        super.onPause();
    }

    @Override
    protected void onDestroy()
    {
        if (mWebView != null)
        {
            mWebView.stopVastAd();
        }

        if (mInnerHelperInterface != null)
        {
            mInnerHelperInterface.onAdClose();
        }

        if (EventBus.getDefault().isRegistered(this) == true)
        {
            EventBus.getDefault().unregister(this);
        }

        super.onDestroy();
    }

    @Subscribe
    public void onHandleEvent(WidgetEventMessage event)
    {
        if (event.getMessageType() == EventMessage.MessageType.INTERSTITIAL_AD_CLOSE)
        {
            mHandler.removeCallbacksAndMessages(null);
            if (isFinishing() == false)
            {
                finish();
            }
        }
    }

    /**
     * Restore user original orientation
     */
    /*public void restoreUserOriginalOrientation()
    {
        if (isFinishing() == false)
        {
            switch (mCurrentOrientationState)
            {
                case Configuration.ORIENTATION_LANDSCAPE:
                {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
                    break;
                }
                case Configuration.ORIENTATION_PORTRAIT:
                {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);
                    break;
                }
                case Configuration.ORIENTATION_UNDEFINED:
                {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
                    break;
                }
            }
        }
    }*/
}
