package com.kidoz.sdk.api.ui_views.html_view;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.KidozTopBar;

import org.greenrobot.eventbus.EventBus;

public class MaximizedViewDialog extends BaseInterstitialDialog
{
    private static final int DEFAULT_TOP_BAR_COLOR = Color.parseColor("#36a7ec");
    private static final String ORIENTATION_STATE_SAVE_STATE_KEY = "ORIENTATION_STATE_SAVE_STATE_KEY_BID";


    private KidozTopBar mKidozTopBar;
    private boolean mFocusLost = false;

    public MaximizedViewDialog(Context context, String widgetType, HtmlViewWrapper htmlViewWrapper)
    {
        super(context, widgetType, htmlViewWrapper);

        initTopBar();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        mInnerContainer.setBackgroundColor(Color.parseColor("#77000000"));
    }

    /**
     * Initiate Top header bar
     */
    private void initTopBar()
    {
        //Create top header view
        mKidozTopBar = new KidozTopBar(getContext(), true, mWidgetType, null);
        mKidozTopBar.setId(Utils.generateViewId());
        mKidozTopBar.setTopBarBackgroundColor(DEFAULT_TOP_BAR_COLOR);
        mKidozTopBar.showParentalLockIcon(false);
        mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener()
        {
            @Override
            public void onExitClicked(View view)
            {
                closeDialog();
            }
        });

        // Add header lay mo view
        mInnerContainer.addView(mKidozTopBar, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT));

        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) mWebView.getLayoutParams();
        params.addRule(RelativeLayout.BELOW, mKidozTopBar.getId());
        params.setMargins(0, -Utils.dpTOpx(getContext(), 7), 0, 0);
    }

    @Override
    public void openDialog()
    {
        // This is'nt working properly.. need to find better solution..
        mWebView.setAlpha(0.01f);
        super.openDialog();
        new Handler().postDelayed(new Runnable()
        {
            @Override
            public void run()
            {
                mWebView.setAlpha(1.0f);
            }
        }, 500);

        WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.MAXIMIZED_PLAYER_OPEN, WidgetType.createFromString(mWidgetType));
        EventBus.getDefault().post(eventMessage);

        EventManager.getInstance(getContext()).logEvent(getContext(), mWidgetType, null, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SDK, EventParameters.ACTION_OPEN_DIALOG, EventParameters.LABEL_WEB);
    }

    @Override
    public void onDetachedFromWindow()
    {
        super.onDetachedFromWindow();

        EventMessage eventMsg = new EventMessage(EventMessage.MessageType.HTML_FULL_VIEW_CLOSE);
        eventMsg.setAdditionalParam(mWidgetType);
        EventBus.getDefault().post(eventMsg);

        WidgetEventMessage widgetEventMessage = new WidgetEventMessage(EventMessage.MessageType.MAXIMIZED_PLAYER_CLOSE, WidgetType.createFromString(mWidgetType));
        EventBus.getDefault().post(widgetEventMessage);

        EventManager.getInstance(getContext()).logEvent(getContext(), mWidgetType, null, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SDK, EventParameters.ACTION_CLOSE_DIALOG, EventParameters.LABEL_WEB);
    }

    public void loadHtmlView(ContentItem contentItem)
    {
        mKidozTopBar.setTitle(contentItem.getName());
        mWebView.setData(contentItem);
        if (contentItem.getIsNonDefaultHtml())
        {
            mWebView.loadHtml();
        } else
        {
            mWebView.requestMaximize();
        }
    }

    public HtmlViewWrapper getInnerWebView()
    {
        return mWebView;
    }

    @Override
    protected void onDialogFocusChange(boolean isVisible)
    {
        super.onDialogFocusChange(isVisible);
        if (isVisible == false)
        {
            mFocusLost = true;
            if (mWebView != null)
            {
                mWebView.requestFocusOff();
            }
        }
    }

    @Override
    protected void onDialogWindowVisibilityChange(boolean visible)
    {
        super.onDialogWindowVisibilityChange(visible);

        if (visible && mFocusLost == true)
        {
            mFocusLost = false;
            if (mWebView != null)
            {
                mWebView.requestFocusOn(true);
            }
        }
    }
}
