package com.kidoz.sdk.api.structure;

import org.json.JSONException;
import org.json.JSONObject;

public class IsEventRecord {

    private static final String PACKAGE_NAME = "packageName";
    private static final String TIME_STAMP = "timeStamp";
    private static final String CONTENT_TYPE = "contentType";
    private static final String POSITION_INDEX = "positionIndex";
    private static final String NAME = "name";
    private static final String ADVERTISING_ID = "advertisingId";
    private static final String STYLE_ID = "styleId";
    private static final String WIDGET_TYPE = "widgetType";

    private JSONObject mJsonObject = new JSONObject();

    public IsEventRecord(String json) {
        try {
            mJsonObject = new JSONObject(json);
        } catch (JSONException e) {

        }
    }

    public IsEventRecord() {
        mJsonObject = new JSONObject();
    }

    public String getAdvertiserId() {
        return mJsonObject.optString(ADVERTISING_ID, "");
    }

    public void setAdvertiserId(String mAdvertiserId) {
        try {
            mJsonObject.put(ADVERTISING_ID, mAdvertiserId);
        } catch (JSONException e) {
        }
    }

    public String getPackageName() {
        return mJsonObject.optString(PACKAGE_NAME, "");
    }

    public void setPackageName(String mPackageName) {
        try {
            mJsonObject.put(PACKAGE_NAME, mPackageName);
        } catch (JSONException e) {
        }
    }

    public String getTimeStamp() {
        return mJsonObject.optString(TIME_STAMP, "-1");
    }

    public void setTimeStamp(String mTimeStamp) {
        try {
            mJsonObject.put(TIME_STAMP, mTimeStamp);
        } catch (JSONException e) {
        }
    }

    public String getContentType() {
        return mJsonObject.optString(CONTENT_TYPE, "");
    }

    public void setContentType(String itemType) {
        try {
            mJsonObject.put(CONTENT_TYPE, itemType);
        } catch (JSONException e) {
        }
    }

    public int getPositionIndex() {
        return mJsonObject.optInt(POSITION_INDEX);
    }

    public void setPositionIndex(int positionIndex) {
        try {
            mJsonObject.put(POSITION_INDEX, positionIndex);
        } catch (JSONException e) {
        }
    }

    public String getName() {
        return mJsonObject.optString(NAME, "");
    }

    public void setName(String name) {
        try {
            mJsonObject.put(NAME, name);
        } catch (JSONException e) {
        }
    }


    public String getStyleId() {
        return mJsonObject.optString(STYLE_ID, null);
    }

    public void setStyleId(String styleID) {
        try {
            mJsonObject.put(STYLE_ID, styleID);
        } catch (JSONException e) {
        }
    }

    public String getWidgetType() {
        return mJsonObject.optString(WIDGET_TYPE, null);
    }

    public void setWidgetType(String widgetType) {
        try {
            mJsonObject.put(WIDGET_TYPE, widgetType);
        } catch (JSONException e) {
        }
    }

    public String getStringParams() {
        return mJsonObject.toString();
    }
}
