package com.kidoz.sdk.api.general.utils;

import android.content.Context;
import android.content.SharedPreferences;



/**
 * Created by orikam on 22/03/16.
 */
public class CookieManager
{
    static private final String APP_STORAGE = "app";
    static private final String SESSION_STORAGE = "session";
    static private final String WIDGET_STORAGE = "widget";

    public static final String TAG = CookieManager.class.getSimpleName();

    private static CookieManager instance = null;

    public static CookieManager getInstance()
    {
        if (instance == null)
        {
            synchronized (CookieManager.class) {
                if (instance == null) {
                    instance = new CookieManager();
                }
                return  instance;
            }
        }
        return instance;
    }//end getInstance


    public static void saveData(Context context, String widgetType, String site, String key, String value, StorageLife lifeTime)
    {
        synchronized (CookieManager.class)
        {
            try
            {
                String hash = EncoderUtils.SHA1(site + key);
                String prefernce = getSharedPreferenceName(widgetType,lifeTime);

                SharedPreferences sharedpreferences = context.getSharedPreferences(prefernce, Context.MODE_PRIVATE);

                SharedPreferences.Editor editor = sharedpreferences.edit();
                editor.putString(hash, value);
                editor.commit();
            } catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to save data to cookie \n" + ex.getMessage());
            }
        }
    }//end save data

    public static String loadData(Context context,String widgetType,  String site, String key)
    {
        synchronized (CookieManager.class)
        {
            try
            {
                String hash = EncoderUtils.SHA1(site + key);
                String preference = getSharedPreferenceName(widgetType, StorageLife.WIDGET);

                SharedPreferences sharedpreferences = context.getSharedPreferences(preference, Context.MODE_PRIVATE);
                String value = sharedpreferences.getString(hash, null);
                if (value == null)
                {
                    preference = getSharedPreferenceName(widgetType, StorageLife.SESSION);
                    sharedpreferences = context.getSharedPreferences(preference, Context.MODE_PRIVATE);
                    value = sharedpreferences.getString(hash, null);
                    if (value == null)
                    {
                        preference = getSharedPreferenceName(widgetType, StorageLife.APP);
                        sharedpreferences = context.getSharedPreferences(preference, Context.MODE_PRIVATE);
                        value = sharedpreferences.getString(hash, null);
                    }
                }
                return value;
            } catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load data to cookie \n" + ex.getMessage());
            }
            return null;
        }

    }//end load data

    public static void resetStorage(Context context, String widgetType, StorageLife lifeTime)
    {
        synchronized (CookieManager.class)
        {
            try
            {
                String prefernce = getSharedPreferenceName(widgetType,lifeTime);
                SharedPreferences sharedpreferences = context.getSharedPreferences(prefernce, Context.MODE_PRIVATE);

                SharedPreferences.Editor editor = sharedpreferences.edit();
                editor.clear();
                editor.commit();
            } catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to reset  cookie \n" + ex.getMessage());
            }
        }
    }//end resetstorage


    static private String getSharedPreferenceName(String widgetType, StorageLife lifeTime)
    {
        String fileName=null;
        switch (lifeTime)
        {
            case APP:
                fileName = APP_STORAGE;
                break;
            case SESSION:
                fileName = SESSION_STORAGE;
                break;
            case WIDGET:
                fileName = widgetType+WIDGET_STORAGE;
                break;
        }
        return fileName;
    }
}//end class CookieManager
