package com.kidoz.sdk.api;

import android.content.Context;

import com.kidoz.sdk.api.ui_views.interstitial.BaseInterstitial;
import com.kidoz.sdk.api.ui_views.interstitial.IntrstWrapper;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

/**
 * KIDOZ Interstitial
 */
public class KidozInterstitial extends BaseInterstitial
{
    public static final String TAG = KidozInterstitial.class.getSimpleName();
    public static final EventSignObj mEventObj = new EventSignObj();

    /**
     * Initiate kidoz interstitial
     */
    public KidozInterstitial(Context context)
    {
        super(context);
        if (EventBus.getDefault().isRegistered(mEventObj) == false)
        {
            EventBus.getDefault().register(mEventObj);
        }
    }

    /**
     * Show interstitial view
     */
    public void show()
    {
        if (mInterstitialView != null)
        {
            mInterstitialView.show();
        }
    }

    /**
     * Load interstitial ad view
     */
    public void loadAd()
    {
        if (mInterstitialView != null)
        {
            mInterstitialView.load(true);
        }
    }

    /**
     * Get is interstitial ad is loaded
     */
    public boolean isLoaded()
    {
        if (mInterstitialView != null)
        {
            return mInterstitialView.isInterstitialLoaded();
        }
        else
        {
            return false;
        }
    }

    /**
     * Set interstitial  view events listener
     *
     * @param listener event listener
     */
    public void setOnInterstitialEventListener(IOnInterstitialEventListener listener)
    {
        mEventObj.setOnListener(listener);
    }

    private static final class EventSignObj
    {
        protected IOnInterstitialEventListener eventLinstener;

        @Subscribe
        public void onHandleEvent(IntrstWrapper.InterstitialEvents event)
        {
            if (eventLinstener != null)
            {
                if (event == IntrstWrapper.InterstitialEvents.OPENED)
                {
                    eventLinstener.onOpened();
                }
                else if (event == IntrstWrapper.InterstitialEvents.CLOSED)
                {
                    eventLinstener.onClosed();
                }
                else if (event == IntrstWrapper.InterstitialEvents.READY)
                {
                    eventLinstener.onReady();
                }
                else if (event == IntrstWrapper.InterstitialEvents.LOAD_FAILED)
                {
                    eventLinstener.onLoadFailed();
                }
            }
        }

        public void setOnListener(IOnInterstitialEventListener listener)
        {
            eventLinstener = listener;
        }
    }
}


