/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.graphics.Point;
import android.os.Looper;
import android.os.Message;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import com.kidoz.sdk.api.ui_views.panel_view.EqualSpaceItemDecoration;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PanelAdapter;
import com.kidoz.sdk.api.ui_views.panel_view.PanelViewListener;
import java.util.ArrayList;

public class PanelSliderView
extends RelativeLayout {
    private static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.12f;
    private PANEL_TYPE mPanelType;
    private RecyclerView mCustomRecyclerView;
    private PanelAdapter mPanelAdapter;
    private LoadingProgressView mLoadingProgressView;
    private Utils.StaticHandler mStaticHandler;
    private PanelViewListener mPanelViewListener;
    private int mScrollingValue;
    private RelativeLayout.LayoutParams innerParams;
    private String mWidgetType;
    private String mStyleID;

    public PanelSliderView(Context context, String widgetType, String styleID) {
        super(context);
        this.mWidgetType = widgetType;
        this.mStyleID = styleID;
        this.initView();
    }

    private void initView() {
        this.initRecyclerView();
        this.initProgressBar();
    }

    public void initRecyclerView() {
        this.mCustomRecyclerView = new RecyclerView(this.getContext());
        this.mCustomRecyclerView.setHasFixedSize(true);
        this.mCustomRecyclerView.setClipToPadding(false);
        LinearLayoutManager customLinearLayoutManager = new LinearLayoutManager(this.getContext(), 0, false);
        this.mCustomRecyclerView.setLayoutManager((RecyclerView.LayoutManager)customLinearLayoutManager);
        this.mPanelAdapter = new PanelAdapter(this.getContext(), this.mPanelType, this.mWidgetType, this.mStyleID);
        this.mCustomRecyclerView.setAdapter((RecyclerView.Adapter)this.mPanelAdapter);
        this.innerParams = new RelativeLayout.LayoutParams(-2, -2);
        this.innerParams.addRule(13);
        this.addView((View)this.mCustomRecyclerView, (ViewGroup.LayoutParams)this.innerParams);
    }

    private void initProgressBar() {
        this.mLoadingProgressView = new LoadingProgressView(this.getContext());
        this.mLoadingProgressView.setVisibility(8);
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((float)Math.min(point.x, point.y) * 0.12f);
        RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(size, size);
        prParams.addRule(13);
        this.addView(this.mLoadingProgressView, (ViewGroup.LayoutParams)prParams);
    }

    public void setPanelType(PANEL_TYPE panelType) {
        this.mPanelType = panelType;
        this.mPanelAdapter.setPanelType(this.mPanelType);
        if (this.mPanelType != null) {
            switch (this.mPanelType) {
                case TOP: {
                    this.mScrollingValue = ScreenUtils.getScreenSize(this.getContext(), true);
                    break;
                }
                case LEFT: {
                    this.mScrollingValue = ScreenUtils.getScreenSize(this.getContext(), false);
                    break;
                }
                case RIGHT: {
                    this.mScrollingValue = ScreenUtils.getScreenSize(this.getContext(), false);
                    break;
                }
                case BOTTOM: {
                    this.mScrollingValue = ScreenUtils.getScreenSize(this.getContext(), true);
                }
            }
        }
        this.preparePanelSlider();
    }

    private void preparePanelSlider() {
        float SCALE_FACTOR = ScreenUtils.getScaleFactor(this.getContext());
        int itemWidth = (int)(517.0f * SCALE_FACTOR);
        int itemHeight = (int)(402.0f * SCALE_FACTOR);
        LinearLayoutManager customLinearLayoutManager = new LinearLayoutManager(this.getContext(), 0, false);
        switch (this.mPanelType) {
            case LEFT: {
                this.innerParams.width = itemWidth;
                this.innerParams.height = -1;
                customLinearLayoutManager.setOrientation(1);
                this.mCustomRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new EqualSpaceItemDecoration(Utils.dpTOpx(this.getContext(), 1.0f), Utils.dpTOpx(this.getContext(), 2.0f)));
                this.mPanelAdapter.setSizePropertiesAndUpdate(itemWidth - Utils.dpTOpx(this.getContext(), 2.0f) * 2 - Utils.dpTOpx(this.getContext(), 6.0f) * 3, itemHeight);
                break;
            }
            case TOP: {
                this.innerParams.width = -1;
                this.innerParams.height = itemHeight;
                customLinearLayoutManager.setOrientation(0);
                this.mCustomRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new EqualSpaceItemDecoration(Utils.dpTOpx(this.getContext(), 2.0f), Utils.dpTOpx(this.getContext(), 1.2f)));
                this.mPanelAdapter.setSizePropertiesAndUpdate(itemWidth, itemHeight);
                break;
            }
            case RIGHT: {
                this.innerParams.width = itemWidth;
                this.innerParams.height = -1;
                customLinearLayoutManager.setOrientation(1);
                this.mCustomRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new EqualSpaceItemDecoration(Utils.dpTOpx(this.getContext(), 1.0f), Utils.dpTOpx(this.getContext(), 2.0f)));
                this.mPanelAdapter.setSizePropertiesAndUpdate(itemWidth - Utils.dpTOpx(this.getContext(), 2.0f) * 2 - Utils.dpTOpx(this.getContext(), 5.0f) * 3, itemHeight);
                break;
            }
            case BOTTOM: {
                this.innerParams.width = -1;
                this.innerParams.height = itemHeight;
                customLinearLayoutManager.setOrientation(0);
                this.mCustomRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new EqualSpaceItemDecoration(Utils.dpTOpx(this.getContext(), 2.0f), Utils.dpTOpx(this.getContext(), 1.2f)));
                this.mPanelAdapter.setSizePropertiesAndUpdate(itemWidth, itemHeight);
            }
        }
        this.mCustomRecyclerView.setLayoutManager((RecyclerView.LayoutManager)customLinearLayoutManager);
    }

    public void setContentData(ArrayList<ContentItem> content) {
        this.mPanelAdapter.setContent(content);
        this.mPanelAdapter.toggleClick(false);
        this.mCustomRecyclerView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.setScrollingStartPosition();
        this.getMyHandlerInstance().postDelayed(new Runnable(){

            @Override
            public void run() {
                PanelSliderView.this.animateScrollingToStartPosition();
            }
        }, 1000L);
        this.getMyHandlerInstance().postDelayed(new Runnable(){

            @Override
            public void run() {
                PanelSliderView.this.mCustomRecyclerView.setOnTouchListener(null);
                PanelSliderView.this.mPanelAdapter.toggleClick(true);
            }
        }, 1500L);
    }

    public void clearContent() {
        this.mPanelAdapter.clearContent();
    }

    public void setPanelViewListener(PanelViewListener panelViewListener) {
        this.mPanelViewListener = panelViewListener;
        if (this.mPanelAdapter != null) {
            this.mPanelAdapter.setPanelViewListener(panelViewListener);
        }
    }

    private void setScrollingStartPosition() {
        if (this.mPanelType != null) {
            switch (this.mPanelType) {
                case TOP: {
                    this.mCustomRecyclerView.scrollBy(this.mScrollingValue, 0);
                    break;
                }
                case LEFT: {
                    this.mCustomRecyclerView.scrollBy(0, this.mScrollingValue);
                    break;
                }
                case RIGHT: {
                    this.mCustomRecyclerView.scrollBy(0, this.mScrollingValue);
                    break;
                }
                case BOTTOM: {
                    this.mCustomRecyclerView.scrollBy(this.mScrollingValue, 0);
                }
            }
        }
    }

    private void animateScrollingToStartPosition() {
        if (this.mPanelType != null) {
            switch (this.mPanelType) {
                case TOP: {
                    this.mCustomRecyclerView.smoothScrollBy(-this.mScrollingValue, 0);
                    break;
                }
                case LEFT: {
                    this.mCustomRecyclerView.smoothScrollBy(0, -this.mScrollingValue);
                    break;
                }
                case RIGHT: {
                    this.mCustomRecyclerView.smoothScrollBy(0, -this.mScrollingValue);
                    break;
                }
                case BOTTOM: {
                    this.mCustomRecyclerView.smoothScrollBy(-this.mScrollingValue, 0);
                }
            }
        }
    }

    public void showLoadingProgressView(boolean show) {
        if (show) {
            this.mLoadingProgressView.setVisibility(0);
            this.mLoadingProgressView.startLoadingAnimation();
        } else {
            this.mLoadingProgressView.stopLoadingAnimation();
            this.mLoadingProgressView.setVisibility(8);
        }
    }

    private Utils.StaticHandler getMyHandlerInstance() {
        if (this.mStaticHandler == null) {
            this.mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()){

                @Override
                public void handleMessage(Message message) {
                }
            };
        }
        return this.mStaticHandler;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }
}

