/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.custom_drawables.DefaultPanelDrawable;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.io.File;

class PanelHandle
extends RelativeLayout {
    private static final float DEFAULT_HANDLE_SCALE_SIZE = 0.15f;
    private AssetView mOpenAssetView;
    private AssetView mCloseAssetView;
    private AssetView mThumbnailAssetView;
    private RelativeLayout.LayoutParams mInnerOpenBtnLayParams;
    private RelativeLayout.LayoutParams mInnerCloseBtnLayParams;
    private RelativeLayout.LayoutParams mThumbnailLayParams;
    private DefaultPanelDrawable mCloseDefaultDrawable;
    private DefaultPanelDrawable mOpenedDefaultDrawable;
    private int mHandleSize = 0;
    private PANEL_TYPE mPanelType;
    private int mAnimType = 1;
    private int mColor = -1;
    private float mThumbFactor = 0.5f;
    private IOnPanelHandleClickListener mClickListener;
    private PANEL_HANDLE_VIEW_STATE mPanelHandleViewState;

    public PanelHandle(Context context, PANEL_TYPE panelType, int animationType, int size, float thumbFactor, IOnPanelHandleClickListener handleClickListener) {
        super(context);
        this.mHandleSize = size;
        this.mPanelType = panelType;
        this.mClickListener = handleClickListener;
        this.mAnimType = animationType;
        this.mThumbFactor = thumbFactor;
        this.initHandle();
    }

    private void initHandle() {
        if (this.mHandleSize == 0) {
            Point point = Utils.getScreenSize(this.getContext());
            this.mHandleSize = (int)((float)Math.min(point.x, point.y) * 0.15f);
        }
        this.mInnerOpenBtnLayParams = new RelativeLayout.LayoutParams(this.mHandleSize, this.mHandleSize);
        this.mInnerCloseBtnLayParams = new RelativeLayout.LayoutParams(this.mHandleSize, this.mHandleSize);
        this.mThumbnailLayParams = new RelativeLayout.LayoutParams((int)((float)this.mHandleSize * this.mThumbFactor), (int)((float)this.mHandleSize * this.mThumbFactor));
        this.mThumbnailLayParams.addRule(13);
        this.mOpenAssetView = new AssetView(this.getContext());
        this.mOpenAssetView.setVisibility(4);
        this.mCloseAssetView = new AssetView(this.getContext());
        this.mCloseAssetView.setVisibility(4);
        this.mThumbnailAssetView = new AssetView(this.getContext());
        this.mThumbnailAssetView.setVisibility(4);
        this.mThumbnailAssetView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.addView((View)this.mThumbnailAssetView, (ViewGroup.LayoutParams)this.mThumbnailLayParams);
        this.addView((View)this.mOpenAssetView, (ViewGroup.LayoutParams)this.mInnerOpenBtnLayParams);
        this.addView((View)this.mCloseAssetView, (ViewGroup.LayoutParams)this.mInnerCloseBtnLayParams);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PanelHandle.this.playHandleClickAnimation(v);
            }
        });
        this.setHandleCorrectRotation();
    }

    private void setHandleCorrectRotation() {
        switch (this.mPanelType) {
            case BOTTOM: {
                this.mOpenAssetView.setRotation(0.0f);
                this.mCloseAssetView.setRotation(0.0f);
                break;
            }
            case TOP: {
                this.mOpenAssetView.setRotation(180.0f);
                this.mCloseAssetView.setRotation(180.0f);
                break;
            }
            case LEFT: {
                this.mOpenAssetView.setRotation(90.0f);
                this.mCloseAssetView.setRotation(90.0f);
                break;
            }
            case RIGHT: {
                this.mOpenAssetView.setRotation(-90.0f);
                this.mCloseAssetView.setRotation(-90.0f);
            }
        }
    }

    public void loadAssets(File openViewAsset, final File closeViewAsset, final IonPanelHandlePreparedListener listener) {
        float ratio;
        int size;
        BitmapFactory.Options options;
        this.mCloseDefaultDrawable = new DefaultPanelDrawable(this.getContext(), PANEL_TYPE.BOTTOM, DefaultPanelDrawable.PanelDrawableType.CLOSED_VIEW);
        this.mOpenedDefaultDrawable = new DefaultPanelDrawable(this.getContext(), PANEL_TYPE.BOTTOM, DefaultPanelDrawable.PanelDrawableType.OPENED_VIEW);
        this.mCloseDefaultDrawable.setBaseColor(this.mColor);
        this.mOpenedDefaultDrawable.setBaseColor(this.mColor);
        if (openViewAsset != null) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)openViewAsset.getAbsolutePath(), (BitmapFactory.Options)options);
            if (options.outHeight != 0 && options.outWidth != 0 && (size = (int)((float)this.mHandleSize * (ratio = (float)options.outHeight / (float)options.outWidth))) != 0) {
                this.mInnerOpenBtnLayParams.height = size;
            }
        }
        if (closeViewAsset != null) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)closeViewAsset.getAbsolutePath(), (BitmapFactory.Options)options);
            if (options.outHeight != 0 && options.outWidth != 0 && (size = (int)((float)this.mHandleSize * (ratio = (float)options.outHeight / (float)options.outWidth))) != 0) {
                this.mInnerCloseBtnLayParams.height = size;
            }
        }
        this.mOpenAssetView.loadAsset(openViewAsset, this.mCloseDefaultDrawable, new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                PanelHandle.this.mCloseAssetView.loadAsset(closeViewAsset, PanelHandle.this.mOpenedDefaultDrawable, new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        listener.onPanelPrepared();
                    }
                });
            }
        });
    }

    public void setBaseColor(int baseColor) {
        this.mColor = baseColor;
        if (this.mCloseDefaultDrawable != null && this.mOpenedDefaultDrawable != null) {
            this.mCloseDefaultDrawable.setBaseColor(baseColor);
            this.mOpenedDefaultDrawable.setBaseColor(baseColor);
        }
        this.mOpenAssetView.postInvalidate();
        this.mCloseAssetView.postInvalidate();
    }

    public void setPanelType(PANEL_TYPE panelType) {
        this.mPanelType = panelType;
        if (this.mCloseDefaultDrawable != null && this.mOpenedDefaultDrawable != null) {
            this.mOpenedDefaultDrawable.setPanelType(this.mPanelType);
            this.mCloseDefaultDrawable.setPanelType(this.mPanelType);
        }
        this.mOpenAssetView.postInvalidate();
        this.mCloseAssetView.postInvalidate();
        this.setHandleCorrectRotation();
    }

    public void setPanelButtonState(PANEL_HANDLE_VIEW_STATE panelHandleState) {
        this.mPanelHandleViewState = panelHandleState;
        switch (this.mPanelHandleViewState) {
            case CLOSED: {
                this.mOpenAssetView.setVisibility(0);
                this.mThumbnailAssetView.setVisibility(0);
                this.mCloseAssetView.setVisibility(4);
                break;
            }
            case OPENED: {
                this.mOpenAssetView.setVisibility(4);
                this.mThumbnailAssetView.setVisibility(4);
                this.mCloseAssetView.setVisibility(0);
            }
        }
        this.postInvalidate();
    }

    private void playHandleClickAnimation(View v) {
        switch (this.mAnimType) {
            case 1: {
                GenAnimator.playPanelButtonClickAnimation(v, this.mPanelType, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (PanelHandle.this.mClickListener != null) {
                            PanelHandle.this.mClickListener.onHandleClick();
                        }
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                break;
            }
            default: {
                GenAnimator.playPanelButtonClickAnimation(v, this.mPanelType, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (PanelHandle.this.mClickListener != null) {
                            PanelHandle.this.mClickListener.onHandleClick();
                        }
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        }
    }

    public AssetView getThumbLayerAsset() {
        return this.mThumbnailAssetView;
    }

    public static interface IonPanelHandlePreparedListener {
        public void onPanelPrepared();
    }

    public static interface IOnPanelHandleClickListener {
        public void onHandleClick();
    }

    public static enum PANEL_HANDLE_VIEW_STATE {
        OPENED,
        CLOSED;

    }
}

