/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.support.v4.view.ViewPager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozBanner;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.kidoz_banner.BannerViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.kidoz_banner.BaseBanner;
import com.kidoz.sdk.api.ui_views.one_item_view.AutoScrollViewPager;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class KidozBanner3
extends BaseBanner {
    private final String TAG = KidozBanner3.class.getSimpleName();
    private int AUTO_SCROLL_DELAY = 10000;
    private RelativeLayout mContainer;
    private RelativeLayout mKidozRelatedContainer;
    private AssetView mParentalLockButton;
    private AssetView mInstallButton;
    private AssetView mNextButton;
    private AutoScrollViewPager mViewPager;
    private BannerViewPagerAdapter mAdapter;
    private TextView mKidozLabelTextView;
    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap();
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    private ContentLogicLoader mContentLogicLoader;
    private boolean mAllowClickHandle = true;
    private String mStyleId;
    public static final String BACKGROUND_IMAGE = "bgImage";
    public static final String LABEL_TEXT = "labelText";
    public static final String LABEL_COLOR = "labelColor";
    public static final String INSTALL_BUTTON = "installBtn";
    public static final String INSTALL_BUTTON_ANIMATION = "installBtnAnimation";
    public static final String REFRESH_BUTTON = "refreshBtn";
    public static final String REFRESH_BUTTON_ANIMATION = "refreshBtnAnimation";
    public static final String LOCK_ACTIVE = "parentalLockActive";
    public static final String LOCK_NOT_ACTIVE = "parentalLockNotActive";
    public static final String LOCK_ANIMATION = "parentalLockAnimation";
    public static final String IS_SMART_BANNER = "isSmartBanner";

    public KidozBanner3(Context context) {
        super(context);
    }

    @Override
    public void setProperties(JSONObject properties) {
        this.mProperties = properties;
        this.initView();
    }

    @Override
    public void initView() {
        super.initView();
        this.mStyleId = this.mProperties.optString("style_id");
        this.AUTO_SCROLL_DELAY = this.mProperties.optInt("swapContentRefreshRateSec", 10) * 1000;
        try {
            if (this.mIsOverrideUser) {
                this.mIsSmartBanner = this.mProperties.optBoolean(IS_SMART_BANNER);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to load is smart flag: " + ex.getMessage());
        }
        this.initContainer();
        this.initKidozContainer();
        this.initParentalLockButton();
        this.initViewPager();
        this.initNextButton();
        this.initInstallButton();
        this.initKidozText();
        this.initContentLogicLoader();
        this.hideBanner();
    }

    @Override
    public void loadContent() {
        super.loadContent();
        if (this.mContentLogicLoader != null) {
            this.mContentLogicLoader.loadContent(this.getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), this.mStyleId);
        }
    }

    private void initKidozContainer() {
        this.mKidozRelatedContainer = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -1);
        params.addRule(13);
        this.mContainer.addView((View)this.mKidozRelatedContainer, (ViewGroup.LayoutParams)params);
    }

    private void initInstallButton() {
        this.mInstallButton = new AssetView(this.getContext());
        this.mInstallButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mInstallButton.setId(Utils.generateViewId());
        String lockClickAnimation = this.mProperties.optString(INSTALL_BUTTON_ANIMATION);
        if (lockClickAnimation != null && lockClickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
            this.mInstallButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    KidozBanner3.this.mInstallButton.setClickable(false);
                    GenAnimator.clickItemAnimation((View)KidozBanner3.this.mInstallButton, 150, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            int pos;
                            KidozBanner3.this.mInstallButton.setClickable(true);
                            if (KidozBanner3.this.mViewPager != null && KidozBanner3.this.mAdapter != null && !KidozBanner3.this.mAdapter.isAdapterEmpty() && (pos = KidozBanner3.this.mViewPager.getCurrentItem() % KidozBanner3.this.mAdapter.getRealCount()) < KidozBanner3.this.mAdapter.getRealCount()) {
                                KidozBanner3.this.handleClick(KidozBanner3.this.mAdapter.getContentItem(pos), pos);
                            }
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            });
        }
        float width = TypedValue.applyDimension((int)1, (float)120.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(12);
        params.addRule(1, this.mViewPager.getId());
        params.bottomMargin = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.leftMargin = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mKidozRelatedContainer.addView((View)this.mInstallButton, (ViewGroup.LayoutParams)params);
        this.mInstallButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(INSTALL_BUTTON)), new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                KidozBanner3.this.autoOpen();
            }
        });
    }

    private void initNextButton() {
        this.mNextButton = new AssetView(this.getContext());
        this.mNextButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.mNextButton.setId(Utils.generateViewId());
        float width = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(11);
        this.mNextButton.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mContainer.addView((View)this.mNextButton, (ViewGroup.LayoutParams)params);
        String lockClickAnimation = this.mProperties.optString(REFRESH_BUTTON_ANIMATION);
        if (lockClickAnimation != null && lockClickAnimation.equals(GenAnimator.PRESS_TOP)) {
            this.mNextButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    KidozBanner3.this.mNextButton.setClickable(false);
                    GenAnimator.playPressTopAnimation((View)KidozBanner3.this.mNextButton, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            KidozBanner3.this.mNextButton.setClickable(true);
                            KidozBanner3.this.mViewPager.setCurrentItem(KidozBanner3.this.mViewPager.getCurrentItem() + 1);
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                }
            });
        }
        this.mNextButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(REFRESH_BUTTON)), new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                KidozBanner3.this.autoOpen();
            }
        });
    }

    private void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                if (contentData != null) {
                    KidozBanner3.this.setContent(contentData.getContentDataItems());
                    if (KidozBanner3.this.mKidozBannerListener != null) {
                        KidozBanner3.this.mKidozBannerListener.onBannerContentLoaded();
                    }
                }
            }

            @Override
            public void onLoadContentFailed() {
                if (KidozBanner3.this.mKidozBannerListener != null) {
                    KidozBanner3.this.mKidozBannerListener.onBannerContentLoadFailed();
                }
            }
        });
    }

    private void initContainer() {
        this.mContainer = new RelativeLayout(this.getContext());
        this.mContainer.setBackgroundColor(0);
        this.mContainer.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });
        float width = TypedValue.applyDimension((int)1, (float)320.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
        AssetView backgroundImage = new AssetView(this.getContext());
        backgroundImage.setScaleType(ImageView.ScaleType.FIT_XY);
        params = new RelativeLayout.LayoutParams(-1, -1);
        this.mContainer.addView((View)backgroundImage, (ViewGroup.LayoutParams)params);
        backgroundImage.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(BACKGROUND_IMAGE)), new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                KidozBanner3.this.autoOpen();
            }
        });
    }

    private void initParentalLockButton() {
        this.mParentalLockButton = new AssetView(this.getContext());
        this.mParentalLockButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.mParentalLockButton.setId(Utils.generateViewId());
        String lockClickAnimation = this.mProperties.optString(LOCK_ANIMATION);
        if (lockClickAnimation != null && lockClickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
            this.mParentalLockButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    KidozBanner3.this.mParentalLockButton.setClickable(false);
                    GenAnimator.clickItemAnimation((View)KidozBanner3.this.mParentalLockButton, 150, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            KidozBanner3.this.mParentalLockButton.setClickable(true);
                            if (ParentalLockDialog.getIsCanShowDialog(KidozBanner3.this.getContext())) {
                                int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(KidozBanner3.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(KidozBanner3.this.getContext(), false) * 0.5f)};
                                ParentalLockDialog parentalLockDialog = new ParentalLockDialog(KidozBanner3.this.getContext(), false, popLocation);
                                parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                                    public void onDismiss(DialogInterface dialog) {
                                        KidozBanner3.this.updateLockIcon();
                                    }
                                });
                                parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                                    @Override
                                    public void onPasswordEntered(boolean isPasswordCorrect) {
                                        KidozBanner3.this.updateLockIcon();
                                    }
                                });
                                parentalLockDialog.show();
                            }
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            });
        }
        int padding = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mParentalLockButton.setPadding(padding, padding, padding, padding);
        float width = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(9);
        this.mContainer.addView((View)this.mParentalLockButton, (ViewGroup.LayoutParams)params);
        this.updateLockIcon();
    }

    private void updateLockIcon() {
        try {
            boolean isLockActive;
            boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
            if (isLockActive) {
                this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(LOCK_ACTIVE)), new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        KidozBanner3.this.autoOpen();
                    }
                });
            } else {
                this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(LOCK_NOT_ACTIVE)), new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        KidozBanner3.this.autoOpen();
                    }
                });
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }

    private void initKidozText() {
        this.mKidozLabelTextView = new TextView(this.getContext());
        this.mKidozLabelTextView.setTextColor(Color.parseColor((String)this.mProperties.optString(LABEL_COLOR)));
        this.mKidozLabelTextView.setShadowLayer(20.0f, 0.0f, 0.0f, Color.parseColor((String)"#80666666"));
        this.mKidozLabelTextView.setText((CharSequence)this.mProperties.optString(LABEL_TEXT));
        this.mKidozLabelTextView.setGravity(17);
        if (ScreenUtils.getIsTablet(this.getContext())) {
            this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        } else {
            this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        }
        this.mKidozLabelTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                KidozBanner3.this.mInstallButton.performClick();
            }
        });
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(5, this.mInstallButton.getId());
        params.addRule(7, this.mInstallButton.getId());
        params.addRule(6);
        float margin = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.topMargin = (int)margin;
        this.mKidozRelatedContainer.addView((View)this.mKidozLabelTextView, (ViewGroup.LayoutParams)params);
    }

    private void initViewPager() {
        this.mViewPager = new AutoScrollViewPager(this.getContext());
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
        gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
        this.mViewPager.setBackgroundColor(0);
        this.mViewPager.setInterval(this.AUTO_SCROLL_DELAY);
        this.mViewPager.clearOnPageChangeListeners();
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                KidozBanner3.this.sendImpressionLog(position % KidozBanner3.this.mAdapter.getRealCount());
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mViewPager.setId(Utils.generateViewId());
        int margin = Utils.dpTOpx(this.getContext(), 1.0f);
        this.mViewPager.setPadding(margin, margin, margin, margin);
        margin = Utils.dpTOpx(this.getContext(), 6.0f);
        this.mViewPager.setPageMargin(margin);
        float width = TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(15);
        this.mKidozRelatedContainer.addView((View)this.mViewPager, (ViewGroup.LayoutParams)params);
        this.mViewPagerItemClickListener = new ItemViewPagerAdapter.ViewPagerItemClickListener(){

            @Override
            public void onClickEnd(ContentItem contentItem, int position) {
                KidozBanner3.this.handleClick(contentItem, position);
            }
        };
    }

    private void handleClick(ContentItem contentItem, int position) {
        if (contentItem != null && this.mAllowClickHandle) {
            this.mAllowClickHandle = false;
            ContentExecutionHandler.handleContentItemClick(this.getContext(), contentItem, WidgetType.WIDGET_TYPE_BANNER.getStringValue(), this.mStyleId, position, true, new ContentExecutionHandler.IOnHandleClickListener(){

                @Override
                public void onRestoreClick() {
                    KidozBanner3.this.mAllowClickHandle = true;
                }
            });
        }
    }

    private void sendImpressionLog(int position) {
        ContentItem contentItem = this.mAdapter.getContentItem(position);
        if (contentItem != null && contentItem.isPromoted() && this.mSponsoredContentDisplayed != null && !contentItem.getIsAvoidAutoImpression() && !this.mSponsoredContentDisplayed.containsKey(contentItem.getId())) {
            this.mSponsoredContentDisplayed.put(contentItem.getId(), position);
            EventManager.getInstance(this.getContext()).logSponsoredContentImpressionEvent(this.getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), this.mStyleId, "Impression", contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
        }
    }

    private void setContent(ArrayList<ContentItem> content) {
        this.mSponsoredContentDisplayed.clear();
        this.mAdapter = new BannerViewPagerAdapter(this.getContext(), false);
        this.mAdapter.setViewPagerItemClickListener(this.mViewPagerItemClickListener);
        this.mAdapter.setContent(content);
        this.mViewPager.setAdapter(this.mAdapter);
        if (!this.mViewPager.isAutoScrollOn()) {
            this.mViewPager.startAutoScroll(this.AUTO_SCROLL_DELAY);
        }
        if (content != null && !content.isEmpty()) {
            this.mViewPager.setCurrentItem(0);
            this.sendImpressionLog(0);
        }
    }

    @Override
    public boolean getIsCanOpen() {
        boolean result = false;
        if (this.mParentalLockButton != null && this.mInstallButton != null && this.mNextButton != null) {
            result = this.mParentalLockButton.getIsAssetLoaded() && this.mInstallButton.getIsAssetLoaded() && this.mNextButton.getIsAssetLoaded();
        }
        return result;
    }

    @Override
    protected void showInner() {
        GenAnimator.fade(true, (View)this, 400, null);
        this.setVisibility(0);
        if (this.mKidozBannerListener != null) {
            this.mKidozBannerListener.onBannerShow();
        }
        if (this.mViewPager != null) {
            if (this.mAdapter != null && !this.mAdapter.isAdapterEmpty()) {
                this.mViewPager.startAutoScroll();
            } else {
                this.mViewPager.stopAutoScroll();
            }
        }
        this.sendActionWidgetViewImpression();
    }

    @Override
    public void hideBanner() {
        super.hideBanner();
        if (this.mKidozBannerListener != null) {
            this.mKidozBannerListener.onBannerHide();
        }
        if (this.mViewPager != null) {
            this.mViewPager.stopAutoScroll();
        }
    }

    @Override
    protected void autoOpen() {
        if (this.mIsWaitingToOpen && this.getIsCanOpen()) {
            this.showBanner();
        }
    }

    public static boolean parseKidozBanner(Context context, JSONObject jsonObject) {
        boolean result = false;
        if (jsonObject != null) {
            try {
                jsonObject.put(KidozBanner.TAG, (Object)KidozBanner3.class.getSimpleName());
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(KidozBanner.TAG);
                result = AssetUtil.loadAsset(context, oldData, jsonObject, BACKGROUND_IMAGE);
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_ACTIVE);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_NOT_ACTIVE);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, REFRESH_BUTTON);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, INSTALL_BUTTON);
                }
                if (result) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(KidozBanner.TAG, jsonObject);
                }
            }
            catch (Exception ex) {
                result = false;
                SDKLogger.printErrorLog(KidozBanner.TAG, "Error when trying to parse kidoz banner3: " + ex.getMessage());
            }
        }
        return result;
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mViewPager != null) {
            this.mViewPager.stopAutoScroll();
        }
        super.onDetachedFromWindow();
    }

    @Override
    public void setIsSmartBanner(boolean isSmartBanner) {
        super.setIsSmartBanner(isSmartBanner);
        try {
            if (this.mIsOverrideUser) {
                this.mIsSmartBanner = this.mProperties.optBoolean(IS_SMART_BANNER);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to load is smart flag: " + ex.getMessage());
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }
}

