/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.v4.view.ViewPager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozBanner;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.kidoz_banner.BannerViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.kidoz_banner.BaseBanner;
import com.kidoz.sdk.api.ui_views.one_item_view.AutoScrollViewPager;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class KidozBanner1
extends BaseBanner {
    private final String TAG = KidozBanner1.class.getSimpleName();
    private int AUTO_SCROLL_DELAY = 10000;
    private RelativeLayout mContainer;
    private RelativeLayout mKidozRelatedContainer;
    private RelativeLayout mContentContainer;
    private AssetView mParentalLockButton;
    private AssetView mNextButton;
    private AssetView mGifView;
    private AutoScrollViewPager mViewPager;
    private TextView mKidozLabelTextView;
    private RelativeLayout mAnimationContainer;
    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap();
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    private ContentLogicLoader mContentLogicLoader;
    private AnimatorSet mMoveThumbAnim;
    private String mStyleId = null;
    private float mAnimationWidth;
    private boolean mIsAnimationStopped;
    public static final String STYLE_ID = "style_id";
    public static final String BACKGROUND_GRADIENT_COLOR_1 = "bgGradientColor1";
    public static final String BACKGROUND_GRADIENT_COLOR_2 = "bgGradientColor2";
    public static final String LOCK_ACTIVE = "parentalLockActive";
    public static final String LOCK_NOT_ACTIVE = "parentalLockNotActive";
    public static final String LOCK_ANIMATION = "parentalLockAnimation";
    public static final String LABEL_TEXT = "labelText";
    public static final String LABEL_COLOR = "labelColor";
    public static final String PROMOTION_ANIMATION = "animationUrl";
    public static final String REFRESH_BUTTON = "refreshBtn";
    public static final String REFRESH_BUTTON_ANIMATION = "refreshBtnAnimation";
    public static final String THUMBNAIL_ANIMATION = "thumbAnimation";
    public static final String IS_SMART_BANNER = "isSmartBanner";

    public KidozBanner1(Context context) {
        super(context);
    }

    @Override
    public void initView() {
        super.initView();
        this.mStyleId = this.mProperties.optString(STYLE_ID);
        this.AUTO_SCROLL_DELAY = this.mProperties.optInt("swapContentRefreshRateSec", 10) * 1000;
        try {
            if (this.mIsOverrideUser) {
                this.mIsSmartBanner = this.mProperties.optBoolean(IS_SMART_BANNER);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to load is smart flag: " + ex.getMessage());
        }
        this.initContainer();
        this.initContentContainer();
        this.initKidozRelatedContainer();
        this.initParentalLockButton();
        this.initKidozText();
        this.initNextButton();
        this.initViewPager();
        this.initAdapter();
        this.initAnimation();
        this.initContentLogicLoader();
        this.hideBanner();
        this.applyContainerParams();
        this.applyParentalLockParams();
        this.applyKidozLabelParams();
        this.applyRefreshButtonParams();
        this.applyContentContainerParams();
    }

    private void initAdapter() {
        this.mAdapter = new BannerViewPagerAdapter(this.getContext(), false);
        this.mAdapter.setViewPagerItemClickListener(this.mViewPagerItemClickListener);
        this.mViewPager.setAdapter(this.mAdapter);
    }

    @Override
    public void loadContent() {
        super.loadContent();
        if (this.mContentLogicLoader != null) {
            this.mContentLogicLoader.loadContent(this.getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), this.mStyleId);
        }
    }

    private void initThumbnailAnimation() {
        if (this.mMoveThumbAnim == null) {
            try {
                String animationType = this.mProperties.optString(THUMBNAIL_ANIMATION);
                if (animationType != null && animationType.equals(GenAnimator.ROTATE_HORIZONTAL)) {
                    this.mMoveThumbAnim = GenAnimator.getBanner((View)this.mAnimationContainer, (int)this.mAnimationWidth, 800, null, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            if (!KidozBanner1.this.mIsAnimationStopped) {
                                if (KidozBanner1.this.mMoveThumbAnim.isRunning()) {
                                    KidozBanner1.this.mMoveThumbAnim.end();
                                }
                                KidozBanner1.this.mMoveThumbAnim.start();
                            }
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(this.TAG, "Error when trying to initThumbnailAnimation: " + ex.getMessage());
            }
        }
    }

    private void initContentContainer() {
        this.mContentContainer = new RelativeLayout(this.getContext());
        float width = TypedValue.applyDimension((int)1, (float)290.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(14);
        this.addView((View)this.mContentContainer, (ViewGroup.LayoutParams)params);
    }

    private void initAnimation() {
        this.mGifView = new AssetView(this.getContext());
        this.mGifView.setScaleType(ImageView.ScaleType.FIT_END);
        float width = TypedValue.applyDimension((int)1, (float)142.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, -1);
        params.addRule(9);
        this.mContentContainer.addView((View)this.mGifView, (ViewGroup.LayoutParams)params);
        try {
            this.mGifView.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(PROMOTION_ANIMATION)), new AssetView.IOnAssetLoadedListener(){

                @Override
                public void onAssetLoaded(boolean successfull) {
                    KidozBanner1.this.autoOpen();
                }
            });
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to initAnimation: " + ex.getMessage());
        }
    }

    private void initNextButton() {
        this.mNextButton = new AssetView(this.getContext());
        this.mNextButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mNextButton.setId(Utils.generateViewId());
        float width = TypedValue.applyDimension((int)1, (float)25.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.rightMargin = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.addRule(11);
        params.addRule(15);
        this.mContainer.addView((View)this.mNextButton, (ViewGroup.LayoutParams)params);
        String lockClickAnimation = this.mProperties.optString(REFRESH_BUTTON_ANIMATION);
        if (lockClickAnimation != null && lockClickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
            this.mNextButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    KidozBanner1.this.mNextButton.setClickable(false);
                    SdkAnimationsUtils.animateClick((View)KidozBanner1.this.mNextButton, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            KidozBanner1.this.mNextButton.setClickable(true);
                            KidozBanner1.this.mViewPager.setCurrentItem(KidozBanner1.this.mViewPager.getCurrentItem() + 1);
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                }
            });
        }
        try {
            this.mNextButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(REFRESH_BUTTON)), new AssetView.IOnAssetLoadedListener(){

                @Override
                public void onAssetLoaded(boolean successfull) {
                    KidozBanner1.this.autoOpen();
                }
            });
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to initNextButton: " + ex.getMessage());
        }
    }

    private void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                if (contentData != null) {
                    KidozBanner1.this.setContent(contentData.getContentDataItems());
                    KidozBanner1.this.initThumbnailAnimation();
                    KidozBanner1.this.startHandlers();
                    if (KidozBanner1.this.mKidozBannerListener != null) {
                        KidozBanner1.this.mKidozBannerListener.onBannerContentLoaded();
                    }
                }
            }

            @Override
            public void onLoadContentFailed() {
                if (KidozBanner1.this.mKidozBannerListener != null) {
                    KidozBanner1.this.mKidozBannerListener.onBannerContentLoadFailed();
                }
            }
        });
    }

    private void initContainer() {
        block4: {
            this.mContainer = new RelativeLayout(this.getContext());
            this.mContainer.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    int pos;
                    if (KidozBanner1.this.mViewPager != null && KidozBanner1.this.mAdapter != null && !KidozBanner1.this.mAdapter.isAdapterEmpty() && (pos = KidozBanner1.this.mViewPager.getCurrentItem() % KidozBanner1.this.mAdapter.getRealCount()) < KidozBanner1.this.mAdapter.getRealCount()) {
                        KidozBanner1.this.handleClick(KidozBanner1.this.mAdapter.getContentItem(pos), pos);
                    }
                    return true;
                }
            });
            try {
                GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor((String)this.mProperties.optString(BACKGROUND_GRADIENT_COLOR_1).trim()), Color.parseColor((String)this.mProperties.optString(BACKGROUND_GRADIENT_COLOR_2).trim())});
                if (Build.VERSION.SDK_INT >= 16) {
                    this.mContainer.setBackground((Drawable)gradientDrawable);
                } else {
                    this.mContainer.setBackgroundDrawable((Drawable)gradientDrawable);
                }
            }
            catch (Exception ex) {
                if (ex == null) break block4;
                SDKLogger.printErrorLog(this.TAG, "Error when trying to initContainer: " + ex.getMessage());
            }
        }
        float width = TypedValue.applyDimension((int)1, (float)320.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
    }

    private void initKidozRelatedContainer() {
        this.mKidozRelatedContainer = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(9);
        params.topMargin = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.bottomMargin = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.leftMargin = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mContainer.addView((View)this.mKidozRelatedContainer, (ViewGroup.LayoutParams)params);
    }

    private void initParentalLockButton() {
        this.mParentalLockButton = new AssetView(this.getContext());
        this.mParentalLockButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mParentalLockButton.setId(Utils.generateViewId());
        String lockClickAnimation = this.mProperties.optString(LOCK_ANIMATION);
        if (lockClickAnimation != null && lockClickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
            this.mParentalLockButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    KidozBanner1.this.mParentalLockButton.setClickable(false);
                    GenAnimator.clickItemAnimation((View)KidozBanner1.this.mParentalLockButton, 150, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            KidozBanner1.this.mParentalLockButton.setClickable(true);
                            if (ParentalLockDialog.getIsCanShowDialog(KidozBanner1.this.getContext())) {
                                int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(KidozBanner1.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(KidozBanner1.this.getContext(), false) * 0.5f)};
                                ParentalLockDialog parentalLockDialog = new ParentalLockDialog(KidozBanner1.this.getContext(), false, popLocation);
                                parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                                    public void onDismiss(DialogInterface dialog) {
                                        KidozBanner1.this.updateLockIcon();
                                    }
                                });
                                parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                                    @Override
                                    public void onPasswordEntered(boolean isPasswordCorrect) {
                                        KidozBanner1.this.updateLockIcon();
                                    }
                                });
                                parentalLockDialog.show();
                            }
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            });
        }
        float width = TypedValue.applyDimension((int)1, (float)34.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)31.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(14);
        this.mKidozRelatedContainer.addView((View)this.mParentalLockButton, (ViewGroup.LayoutParams)params);
        this.updateLockIcon();
    }

    private void updateLockIcon() {
        try {
            boolean isLockActive;
            float width = TypedValue.applyDimension((int)1, (float)34.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            float height = TypedValue.applyDimension((int)1, (float)31.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
            if (isLockActive) {
                this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(LOCK_ACTIVE)), new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        KidozBanner1.this.autoOpen();
                    }
                });
            } else {
                this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(LOCK_NOT_ACTIVE)), new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        KidozBanner1.this.autoOpen();
                    }
                });
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }

    private void initKidozText() {
        this.mKidozLabelTextView = new TextView(this.getContext());
        this.mKidozLabelTextView.setTextColor(-1);
        this.mKidozLabelTextView.setShadowLayer(20.0f, 0.0f, 0.0f, Color.parseColor((String)"#80000000"));
        this.mKidozLabelTextView.setText((CharSequence)"Recommended\nBy KIDOZ");
        this.mKidozLabelTextView.setGravity(17);
        this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)2.2f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mKidozLabelTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                KidozBanner1.this.mParentalLockButton.performClick();
            }
        });
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(12);
        params.addRule(14);
        this.mKidozRelatedContainer.addView((View)this.mKidozLabelTextView, (ViewGroup.LayoutParams)params);
        try {
            this.mKidozLabelTextView.setText((CharSequence)this.mProperties.optString(LABEL_TEXT));
            this.mKidozLabelTextView.setTextColor(Color.parseColor((String)this.mProperties.optString(LABEL_COLOR).trim()));
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to load label: " + ex.getMessage());
        }
    }

    private void initViewPager() {
        this.mViewPager = new AutoScrollViewPager(this.getContext());
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
        gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
        if (Build.VERSION.SDK_INT >= 16) {
            this.mViewPager.setBackground((Drawable)gradientDrawable);
        } else {
            this.mViewPager.setBackgroundDrawable((Drawable)gradientDrawable);
        }
        this.mViewPager.setInterval(this.AUTO_SCROLL_DELAY);
        this.mViewPager.clearOnPageChangeListeners();
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                KidozBanner1.this.sendImpressionLog(position % KidozBanner1.this.mAdapter.getRealCount());
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mViewPager.setId(Utils.generateViewId());
        int margin = Utils.dpTOpx(this.getContext(), 1.0f);
        this.mViewPager.setPadding(margin, margin, margin, margin);
        margin = Utils.dpTOpx(this.getContext(), 6.0f);
        this.mViewPager.setPageMargin(margin);
        this.mAnimationContainer = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(11);
        params.addRule(12);
        params.bottomMargin = (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mContentContainer.addView((View)this.mAnimationContainer, (ViewGroup.LayoutParams)params);
        float width = TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams viewPagerParams = new RelativeLayout.LayoutParams((int)width, (int)height);
        this.mAnimationContainer.addView((View)this.mViewPager, (ViewGroup.LayoutParams)viewPagerParams);
        this.mViewPagerItemClickListener = new ItemViewPagerAdapter.ViewPagerItemClickListener(){

            @Override
            public void onClickEnd(ContentItem contentItem, int position) {
                KidozBanner1.this.handleClick(contentItem, position);
            }
        };
    }

    private void handleClick(ContentItem contentItem, int position) {
        if (contentItem != null && this.mAllowClickHandling) {
            this.mAllowClickHandling = false;
            ContentExecutionHandler.handleContentItemClick(this.getContext(), contentItem, WidgetType.WIDGET_TYPE_BANNER.getStringValue(), this.mStyleId, position, true, new ContentExecutionHandler.IOnHandleClickListener(){

                @Override
                public void onRestoreClick() {
                    KidozBanner1.this.mAllowClickHandling = true;
                }
            });
        }
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (this.mViewPager != null) {
            if (visibility == 0) {
                this.startHandlers();
            } else {
                this.stopHandlers();
            }
        }
    }

    private void sendImpressionLog(int position) {
        ContentItem contentItem = this.mAdapter.getContentItem(position);
        if (contentItem != null && contentItem.isPromoted() && this.mSponsoredContentDisplayed != null && !contentItem.getIsAvoidAutoImpression() && !this.mSponsoredContentDisplayed.containsKey(contentItem.getId())) {
            this.mSponsoredContentDisplayed.put(contentItem.getId(), position);
            EventManager.getInstance(this.getContext()).logSponsoredContentImpressionEvent(this.getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), this.mStyleId, "Impression", contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
        }
    }

    private void setContent(ArrayList<ContentItem> content) {
        this.mSponsoredContentDisplayed.clear();
        this.mAdapter.setContent(content);
        if (!this.mViewPager.isAutoScrollOn()) {
            this.mViewPager.startAutoScroll(this.AUTO_SCROLL_DELAY);
        }
        if (content != null && !content.isEmpty()) {
            this.mViewPager.setCurrentItem(0);
            this.sendImpressionLog(0);
        }
    }

    @Override
    public boolean getIsCanOpen() {
        boolean result = false;
        if (this.mParentalLockButton != null && this.mNextButton != null && this.mGifView != null) {
            result = this.mParentalLockButton.getIsAssetLoaded() && this.mParentalLockButton.getIsAssetLoaded() && this.mGifView.getIsAssetLoaded();
        }
        return result;
    }

    @Override
    protected void showInner() {
        super.showInner();
        GenAnimator.fade(true, (View)this, 400, null);
        this.setVisibility(0);
        if (this.mKidozBannerListener != null) {
            this.mKidozBannerListener.onBannerShow();
        }
        this.startHandlers();
        this.sendActionWidgetViewImpression();
    }

    @Override
    public void hideBanner() {
        super.hideBanner();
        if (this.mKidozBannerListener != null) {
            this.mKidozBannerListener.onBannerHide();
        }
        this.stopHandlers();
    }

    @Override
    protected void autoOpen() {
        if (this.mIsWaitingToOpen && this.getIsCanOpen()) {
            this.showBanner();
        }
    }

    public static boolean parseKidozBanner(Context context, JSONObject jsonObject) {
        boolean result = false;
        if (jsonObject != null) {
            try {
                jsonObject.put(KidozBanner.TAG, (Object)KidozBanner1.class.getSimpleName());
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(KidozBanner.TAG);
                result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_ACTIVE);
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_NOT_ACTIVE);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, PROMOTION_ANIMATION);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, REFRESH_BUTTON);
                }
                if (result) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(KidozBanner.TAG, jsonObject);
                }
            }
            catch (Exception ex) {
                result = false;
                SDKLogger.printErrorLog(KidozBanner.TAG, "Error when trying to parse kidoz banner properties: " + ex.getMessage());
            }
        }
        return result;
    }

    @Override
    protected void onDetachedFromWindow() {
        this.stopHandlers();
        super.onDetachedFromWindow();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.applyContainerParams();
        this.applyParentalLockParams();
        this.applyKidozLabelParams();
        this.applyRefreshButtonParams();
        this.applyContentContainerParams();
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private void applyContainerParams() {
        if (this.mIsSmartBanner) {
            this.mContainer.getLayoutParams().width = -1;
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            int height = screenHeightDP <= 400 ? (int)TypedValue.applyDimension((int)1, (float)32.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()) : (screenHeightDP > 400 && screenHeightDP <= 720 ? (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()) : (int)TypedValue.applyDimension((int)1, (float)90.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
            this.mContainer.getLayoutParams().height = height;
        } else {
            this.mContainer.getLayoutParams().width = (int)TypedValue.applyDimension((int)1, (float)320.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.mContainer.getLayoutParams().height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        }
    }

    private void applyParentalLockParams() {
        if (this.mIsSmartBanner) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                params.addRule(14);
                params.width = (int)TypedValue.applyDimension((int)1, (float)34.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.height = (int)TypedValue.applyDimension((int)1, (float)31.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                params.addRule(14);
                params.width = (int)TypedValue.applyDimension((int)1, (float)38.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.height = (int)TypedValue.applyDimension((int)1, (float)35.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            } else {
                params.addRule(14);
                params.width = (int)TypedValue.applyDimension((int)1, (float)78.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.height = (int)TypedValue.applyDimension((int)1, (float)70.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            }
            this.mParentalLockButton.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void applyKidozLabelParams() {
        if (this.mIsSmartBanner) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                params.addRule(12);
                params.addRule(14);
                this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                this.mKidozLabelTextView.setSingleLine(true);
                this.mKidozLabelTextView.setMinLines(1);
                this.mKidozLabelTextView.setMaxLines(1);
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                params.addRule(12);
                params.addRule(14);
                this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)2.2f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                this.mKidozLabelTextView.setSingleLine(false);
                this.mKidozLabelTextView.setMinLines(1);
                this.mKidozLabelTextView.setMaxLines(2);
            } else {
                params.addRule(12);
                params.addRule(14);
                this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)5.2f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                this.mKidozLabelTextView.setSingleLine(false);
                this.mKidozLabelTextView.setMinLines(1);
                this.mKidozLabelTextView.setMaxLines(2);
            }
            this.mKidozLabelTextView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void applyRefreshButtonParams() {
        if (this.mIsSmartBanner) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            params.rightMargin = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.addRule(11);
            params.addRule(15);
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                params.addRule(14);
                params.width = (int)TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.height = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                params.addRule(14);
                params.width = (int)TypedValue.applyDimension((int)1, (float)25.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.height = (int)TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            } else {
                params.addRule(14);
                params.width = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.height = (int)TypedValue.applyDimension((int)1, (float)65.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            }
            this.mNextButton.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void applyContentContainerParams() {
        if (this.mIsSmartBanner) {
            int height;
            this.mContentContainer.getLayoutParams().width = (int)TypedValue.applyDimension((int)1, (float)290.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                this.mContentContainer.getLayoutParams().width = (int)TypedValue.applyDimension((int)1, (float)280.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                height = (int)TypedValue.applyDimension((int)1, (float)32.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                this.mViewPager.getLayoutParams().height = this.mViewPager.getLayoutParams().width = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                if (this.mAdapter != null) {
                    this.mAdapter.setContainerHeight(this.mViewPager.getLayoutParams().height);
                }
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                this.mViewPager.getLayoutParams().height = this.mViewPager.getLayoutParams().width = (int)TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                if (this.mAdapter != null) {
                    this.mAdapter.setContainerHeight(this.mViewPager.getLayoutParams().height);
                }
            } else {
                this.mContentContainer.getLayoutParams().width = (int)TypedValue.applyDimension((int)1, (float)320.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                height = (int)TypedValue.applyDimension((int)1, (float)90.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                this.mViewPager.getLayoutParams().height = this.mViewPager.getLayoutParams().width = (int)TypedValue.applyDimension((int)1, (float)88.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                if (this.mAdapter != null) {
                    this.mAdapter.setContainerHeight(this.mViewPager.getLayoutParams().height);
                }
            }
            this.mContentContainer.getLayoutParams().height = height;
            this.mAnimationWidth = TypedValue.applyDimension((int)1, (float)120.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        } else {
            if (this.mAdapter != null) {
                this.mAdapter.setContainerHeight(this.mViewPager.getLayoutParams().height);
            }
            this.mContentContainer.getLayoutParams().width = (int)TypedValue.applyDimension((int)1, (float)250.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.mAnimationWidth = TypedValue.applyDimension((int)1, (float)80.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        }
    }

    @Override
    public void setIsSmartBanner(boolean isSmartBanner) {
        super.setIsSmartBanner(isSmartBanner);
        try {
            if (this.mIsOverrideUser) {
                this.mIsSmartBanner = this.mProperties.optBoolean(IS_SMART_BANNER);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to load is smart flag: " + ex.getMessage());
        }
        this.applyContainerParams();
        this.applyParentalLockParams();
        this.applyKidozLabelParams();
        this.applyRefreshButtonParams();
        this.applyContentContainerParams();
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.startHandlers();
        } else {
            this.stopHandlers();
        }
    }

    private void stopHandlers() {
        if (this.mAdapter != null) {
            this.mViewPager.stopAutoScroll();
        }
        if (this.mMoveThumbAnim != null) {
            this.mIsAnimationStopped = true;
            this.mMoveThumbAnim.cancel();
            this.mAnimationContainer.clearAnimation();
            this.mAnimationContainer.setTranslationX(0.0f);
        }
    }

    private void startHandlers() {
        this.stopHandlers();
        if (this.mAdapter != null && !this.mAdapter.isAdapterEmpty()) {
            this.mViewPager.startAutoScroll();
        }
        if (this.mMoveThumbAnim != null) {
            this.mAnimationContainer.clearAnimation();
            this.mAnimationContainer.setTranslationX(0.0f);
            this.mMoveThumbAnim.start();
            this.mIsAnimationStopped = false;
        }
    }
}

