/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.animation.Animator;
import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.assets_handling.ImageAssetsUtils;
import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.picasso_related.RoundedTransformation;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.squareup.imagelib.Callback;
import java.util.ArrayList;

public class BannerViewPagerAdapter
extends PagerAdapter {
    private ArrayList<ContentItem> mContent = new ArrayList();
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    private boolean mIsCanClick = true;
    private boolean mIsImageCropped;
    private int mContainerHeight;
    private IOnFistItemInstaniateListener mItemInstaniateListener;
    private boolean mFirstItemCreated = false;

    public BannerViewPagerAdapter(Context context, boolean isImageCropped) {
        this.mIsImageCropped = isImageCropped;
    }

    public void setViewPagerItemClickListener(ItemViewPagerAdapter.ViewPagerItemClickListener viewPagerItemClickListener) {
        this.mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    public int getCount() {
        int result = 0;
        if (this.mContent != null && this.mContent.size() > 0) {
            result = this.mContent.size() == 1 ? 1 : Integer.MAX_VALUE;
        }
        return result;
    }

    public int getRealCount() {
        return this.mContent.size();
    }

    public void setContent(ArrayList<ContentItem> content) {
        this.mContent = content;
        this.notifyDataSetChanged();
    }

    public Object instantiateItem(ViewGroup container, int position) {
        final int virtualPosition = position % this.mContent.size();
        RelativeLayout parentView = new RelativeLayout(container.getContext());
        final ContentItem contentItem = this.mContent.get(virtualPosition);
        ImageView imageView = new ImageView(container.getContext());
        if (this.mIsImageCropped) {
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        } else {
            imageView.setScaleType(ImageView.ScaleType.FIT_XY);
        }
        imageView.setDuplicateParentStateEnabled(true);
        int padding = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)container.getContext().getResources().getDisplayMetrics());
        if (this.mContainerHeight == 0) {
            this.mContainerHeight = container.getHeight();
        }
        int size = (int)TypedValue.applyDimension((int)1, (float)(this.mContainerHeight - padding), (DisplayMetrics)container.getContext().getResources().getDisplayMetrics());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(size, size);
        imageView.setLayoutParams(params);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BannerViewPagerAdapter.this.mIsCanClick) {
                    SdkSoundManager.playSound(view.getContext(), SoundAssetsUtils.getSoundAssetFile(view.getContext(), SoundAssetsUtils.SOUND_ASSET_TYPE.ITEM_CLICK).getAbsolutePath());
                    BannerViewPagerAdapter.this.mIsCanClick = false;
                    SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            BannerViewPagerAdapter.this.mViewPagerItemClickListener.onClickEnd(contentItem, virtualPosition);
                            BannerViewPagerAdapter.this.mIsCanClick = true;
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    }, 50, 100);
                }
            }
        });
        if (contentItem != null && contentItem.getThumb() != null && !contentItem.getThumb().equals("")) {
            int roundDP;
            int round = roundDP = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)container.getContext().getResources().getDisplayMetrics());
            PicassoOk.getPicasso(container.getContext()).load(contentItem.getThumb()).transform(new RoundedTransformation(round, 0)).into(imageView, new Callback(){

                @Override
                public void onSuccess() {
                }

                @Override
                public void onError() {
                }
            });
        }
        parentView.addView((View)imageView);
        imageView.setTag((Object)("BannerThumbnailNumber_" + String.valueOf(position)));
        if (contentItem != null && contentItem.isPromoted()) {
            ImageView promotedIndication = this.createPromotedIndication(container.getContext(), size);
            this.loadPromotedIndication(container.getContext(), promotedIndication);
            parentView.addView((View)promotedIndication);
        }
        container.addView((View)parentView);
        if (position == 0 && !this.mFirstItemCreated && contentItem != null) {
            this.mFirstItemCreated = true;
            if (this.mItemInstaniateListener != null) {
                this.mItemInstaniateListener.onFirstItemReady();
            }
        }
        return parentView;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)((RelativeLayout)object));
    }

    public ContentItem getContentItem(int position) {
        ContentItem result = null;
        if (this.mContent != null && this.mContent.size() > position) {
            result = this.mContent.get(position);
        }
        return result;
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public boolean isAdapterEmpty() {
        return this.mContent.isEmpty();
    }

    private ImageView createPromotedIndication(Context context, int containerWidth) {
        float WIDTH = 0.30947775f;
        float HEIGHT = 0.25f;
        int width = containerWidth;
        if (width == 0) {
            width = (int)TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        ImageView result = new ImageView(context);
        result.setId(Utils.generateViewId());
        result.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
        params.width = (int)((float)width * WIDTH);
        params.height = (int)((float)params.width * HEIGHT);
        result.setLayoutParams(params);
        return result;
    }

    private void loadPromotedIndication(Context context, ImageView imageView) {
        int width = imageView.getLayoutParams().width;
        int height = imageView.getLayoutParams().height;
        if (width > 0 && height > 0) {
            PicassoOk.getPicasso(context).load(ImageAssetsUtils.getAssetFile(context, ImageAssetsUtils.APP_ASSET_TYPE.PROMOTED_INDICATION)).transform(new RoundedTransformation(0, 0, true)).resize(width, height).centerInside().into(imageView);
        }
    }

    public void setContainerHeight(int containerHeight) {
        this.mContainerHeight = containerHeight;
    }

    public void setOnFirstItemListener(IOnFistItemInstaniateListener listener) {
        this.mItemInstaniateListener = listener;
    }

    public static interface IOnFistItemInstaniateListener {
        public void onFirstItemReady();
    }
}

