/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.interstitial;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class KidozAdActivity
extends Activity {
    public static ContentItem itm;
    public static final String STYLE_ID_KEY = "styleId";
    protected HtmlViewWrapper mWebView;
    protected RelativeLayout mInnerContainer;
    protected boolean mIsDefault;
    protected boolean mIsImmersive = false;
    protected boolean mIsBlockBackBtn = false;
    protected boolean mIsLandscape = false;
    protected boolean mIsAllowNoSensor = false;
    protected int mBgColor = -16777216;
    protected int mViewDuration = 0;
    private Utils.StaticHandler mHandler;
    protected int mCurrentOrientationState = -1;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mCurrentOrientationState = this.getResources().getConfiguration().orientation;
        this.setRequestedOrientation(1);
        this.setTheme(0x1030011);
        this.mHandler = new Utils.StaticHandler(this.getMainLooper());
        Intent intent = this.getIntent();
        if (intent != null) {
            String styleId = intent.getStringExtra(STYLE_ID_KEY);
            if (itm != null) {
                this.mIsDefault = !itm.getIsNonDefaultHtml();
                this.mIsBlockBackBtn = itm.getExtraParameters().optBoolean("intrstBlockBackBtn", true);
                this.mIsImmersive = itm.getExtraParameters().optBoolean("intrstImmersiveModeOn", false);
                this.mIsLandscape = itm.getExtraParameters().optBoolean("intrstForceLandscape", false);
                this.mViewDuration = itm.getExtraParameters().optInt("viewDurationSec", 0);
                this.mIsAllowNoSensor = itm.getExtraParameters().optBoolean("intrstAllowSensor", false);
                try {
                    this.mBgColor = Color.parseColor((String)itm.getExtraParameters().optString("intrstBgColor", "000000"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.mIsDefault) {
                        this.mWebView = HtmlManager.getIntrstDefaultHtmlView((Context)this);
                        this.mWebView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                        this.mWebView.setStyleID(styleId);
                        this.mWebView.setData(itm);
                    } else {
                        this.mWebView = new HtmlViewWrapper((Context)this, false);
                        this.mWebView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                        this.mWebView.setStyleID(styleId);
                        this.mWebView.setData(itm);
                        this.mWebView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

                            @Override
                            public void onHtmlStartLoading() {
                                super.onHtmlStartLoading();
                                KidozAdActivity.this.mWebView.showLoadingProgressView();
                            }

                            @Override
                            public void onHtmlFinishedLoading() {
                                super.onHtmlFinishedLoading();
                                KidozAdActivity.this.mWebView.hideLoadingProgressView();
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.mWebView != null) {
                    this.mWebView.setInFocusActivityContext((Context)this);
                    this.mInnerContainer = new RelativeLayout((Context)this);
                    this.mInnerContainer.setBackgroundColor(this.mBgColor);
                    this.mInnerContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
                    this.setContentView((View)this.mInnerContainer, new ViewGroup.LayoutParams(-1, -1));
                    if (this.mIsDefault) {
                        this.mWebView.requestWidgetOpen(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                    }
                    EventManager.getInstance((Context)this).logEvent((Context)this, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), styleId, EventManager.LOG_CRITICAL_LEVEL, "Sponsored Content", "Widget View", "Interstitial View");
                    if (this.mIsAllowNoSensor) {
                        this.setRequestedOrientation(4);
                    } else if (this.mIsLandscape) {
                        this.setRequestedOrientation(6);
                    }
                } else {
                    this.finish();
                }
            } else {
                this.finish();
            }
        } else {
            this.finish();
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus && this.mIsImmersive) {
            this.applyImmersiveMode();
        }
    }

    private void applyImmersiveMode() {
        int flags = 2;
        if (Build.VERSION.SDK_INT >= 16) {
            flags = 1798;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            flags = 5894;
        }
        this.getWindow().getDecorView().setSystemUiVisibility(flags);
    }

    protected void onResume() {
        super.onResume();
        this.doOnResume();
        if (this.mWebView != null) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (KidozAdActivity.this.mIsDefault) {
                        KidozAdActivity.this.mWebView.requestFocusOn(true);
                    } else {
                        KidozAdActivity.this.mWebView.loadHtml(itm.getData());
                    }
                    KidozAdActivity.this.mWebView.bringToFront();
                }
            }, 300L);
        }
    }

    protected void onPause() {
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.mWebView != null) {
            this.mWebView.requestFocusOff();
        }
        this.doOnPause();
        super.onPause();
    }

    protected void onStop() {
        if (this.mIsDefault && this.mWebView != null) {
            this.mWebView.requestWidgetClose(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
        }
        super.onStop();
        if (!this.mIsDefault) {
            this.mWebView.stopAndReleaseWebView();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        switch (this.mCurrentOrientationState) {
            case 2: {
                this.setRequestedOrientation(6);
                break;
            }
            case 1: {
                this.setRequestedOrientation(7);
                break;
            }
            case 0: {
                this.setRequestedOrientation(4);
            }
        }
    }

    @Subscribe
    public void onHandleEvent(WidgetEventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INTERSTITIAL_AD_CLOSE) {
            if (!this.isFinishing()) {
                this.finish();
            }
        } else if (event.getMessageType() == EventMessage.MessageType.PLAYER_OPEN) {
            this.mHandler.removeCallbacksAndMessages(null);
            if (this.mWebView != null) {
                this.mWebView.requestFocusOff();
                if (!this.mIsDefault) {
                    this.mWebView.clearHtmlView();
                }
            }
        } else if (event.getMessageType() == EventMessage.MessageType.PLAYER_CLOSE && this.mWebView != null) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (KidozAdActivity.this.mIsDefault) {
                        KidozAdActivity.this.mWebView.requestFocusOn(true);
                    } else {
                        KidozAdActivity.this.mWebView.loadHtml(itm.getData());
                    }
                    KidozAdActivity.this.mWebView.bringToFront();
                }
            }, 300L);
        }
    }

    public void onBackPressed() {
        if (this.mIsBlockBackBtn) {
            if (this.mWebView != null) {
                this.mWebView.requestFocusOff();
            }
            super.onBackPressed();
            WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
            EventBus.getDefault().post((Object)eventMessage);
        }
    }

    public void restoreUserOriginalOrientation() {
        if (!this.isFinishing()) {
            switch (this.mCurrentOrientationState) {
                case 2: {
                    this.setRequestedOrientation(6);
                    break;
                }
                case 1: {
                    this.setRequestedOrientation(7);
                    break;
                }
                case 0: {
                    this.setRequestedOrientation(4);
                }
            }
        }
    }

    private void doOnPause() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.mIsLandscape) {
            this.restoreUserOriginalOrientation();
        }
    }

    private void doOnResume() {
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        if (this.mViewDuration > 0) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    KidozAdActivity.this.finish();
                    WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
                    EventBus.getDefault().post((Object)eventMessage);
                }
            }, this.mViewDuration * 1000);
        }
    }
}

