/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import java.io.File;

public class TitleView
extends RelativeLayout {
    private final String TAG = TitleView.class.getSimpleName();
    private ImageView mImageView;
    private TextView mTitle;
    private Paint mWhitePaint;
    private File mImageFile;
    private int mWidth;
    private int mHeight;

    public TitleView(Context context, File bgImageFile) {
        super(context);
        this.mImageFile = bgImageFile;
        this.initView();
    }

    private void initView() {
        this.setWillNotDraw(false);
        this.initImageParameters();
        this.initPaints();
        this.initImageView();
        this.initTitle();
    }

    private void initTitle() {
        float TEXT_SIZE = 0.35714287f;
        this.mTitle = new TextView(this.getContext());
        this.mTitle.setSingleLine(true);
        this.mTitle.setTextColor(Color.parseColor((String)"#04a0e1"));
        this.mTitle.setTextSize(0, (float)((int)(TEXT_SIZE * (float)this.mHeight)));
        this.mTitle.setGravity(19);
        this.mTitle.setEllipsize(TextUtils.TruncateAt.END);
        this.mTitle.setShadowLayer(2.0f, 1.0f, 1.0f, Color.parseColor((String)"#666666"));
        this.mTitle.setTypeface(null, 1);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.addView((View)this.mTitle, (ViewGroup.LayoutParams)params);
    }

    private void initImageView() {
        this.mImageView = new ImageView(this.getContext());
        this.mImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(this.mWidth, this.mHeight);
        this.addView((View)this.mImageView, (ViewGroup.LayoutParams)params);
    }

    private void initImageParameters() {
        float mScaleFactor = ScreenUtils.getScaleFactor(this.getContext());
        this.mWidth = 710;
        this.mHeight = 140;
        if (this.mImageFile != null && this.mImageFile.exists()) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)this.mImageFile.getAbsolutePath(), (BitmapFactory.Options)options);
            this.mWidth = options.outWidth;
            this.mHeight = options.outHeight;
        }
        this.mWidth = (int)((float)this.mWidth * mScaleFactor);
        this.mHeight = (int)((float)this.mHeight * mScaleFactor);
    }

    private void initPaints() {
        this.mWhitePaint = new Paint(1);
        this.mWhitePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mWhitePaint.setColor(Color.parseColor((String)"#ffffff"));
        this.setLayerType(1, this.mWhitePaint);
    }

    private void loadImage() {
        if (this.mImageFile != null && this.mImageFile.exists() && this.mImageView.getDrawable() == null) {
            PicassoOk.getPicasso(this.getContext()).load(this.mImageFile).into(this.mImageView);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.getChildAt(0).layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
        float TEXT_WIDTH = 0.73802817f;
        float MARGIN_LEFT = 0.15352112f;
        float MARGIN_TOP = 0.14285715f;
        this.getChildAt(1).layout((int)(MARGIN_LEFT * (float)this.mWidth), (int)(MARGIN_TOP * (float)this.mHeight), (int)(TEXT_WIDTH * (float)this.mWidth), this.getMeasuredHeight());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mImageFile == null || !this.mImageFile.exists()) {
            float radius = 0.15492958f * (float)this.mWidth;
            float centerX = 0.11971831f * (float)this.mWidth;
            float centerY = 0.10714286f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.2352676f * (float)this.mWidth;
            centerX = 0.34029576f * (float)this.mWidth;
            centerY = -0.19571428f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.23528169f * (float)this.mWidth;
            centerX = 0.5924084f * (float)this.mWidth;
            centerY = -0.19321428f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.13098592f * (float)this.mWidth;
            centerX = 0.8690141f * (float)this.mWidth;
            centerY = -0.16428572f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
        } else {
            this.loadImage();
        }
    }

    public void setTitle(String title) {
        this.mTitle.setText((CharSequence)title);
    }

    public void setTitleColor(int Color2) {
        this.mTitle.setTextColor(Color2);
    }
}

