/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Bundle;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.players.web_player.WebPlayerView;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.KidozTopBar;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import java.io.Serializable;
import org.greenrobot.eventbus.EventBus;

public class WebPlayerDialog
extends BaseDialog {
    private static final int DEFAULT_TOP_BAR_COLOR = Color.parseColor((String)"#36a7ec");
    private static final String TAG = WebPlayerDialog.class.getSimpleName();
    private static final int WEB_PLAYER_RESOURCE_ID = 1;
    private static final String CONTENT_ITEM_SAVE_STATE_KEY = "CONTENT_ITEM_SAVE_STATE_KEY_WP";
    private static final String WEB_PLAYER_TYPE_SAVE_STATE_KEY = "WEB_PLAYER_TYPE_SAVE_STATE_KEY_WP";
    private static final String ORIENTATION_STATE_SAVE_STATE_KEY = "ORIENTATION_STATE_SAVE_STATE_KEY_WP";
    private static final String ORIENTATION_MODIFY_SAVE_STATE_KEY = "ORIENTATION_MODIFY_SAVE_STATE_KEY_WP";
    private RelativeLayout mInnerContainer;
    private ContentItem mContentItem;
    private WebPlayerType mWebPlayerType;
    private KidozTopBar mKidozTopBar;
    private WebPlayerView mWebPlayerView;
    private HtmlViewWrapper mHtmlViewWrapper;
    private boolean mAllowOrientationModify = false;
    private String mWidgetType = null;
    private String mStyleId = null;
    private Utils.StaticHandler staticHandler = new Utils.StaticHandler(Looper.getMainLooper());

    public WebPlayerDialog(Context context, ContentItem contentItem, String widgetType, String styleId, WebPlayerType webPlayerType, boolean allowOrientationModification) {
        super(context, 0x1030011);
        this.setCancelable(true);
        this.mContentItem = contentItem;
        this.mWebPlayerType = webPlayerType;
        this.mAllowOrientationModify = allowOrientationModification;
        this.mWidgetType = widgetType;
        this.mStyleId = styleId;
    }

    public void setAutoCloseTimer(int millis) {
        this.staticHandler.removeCallbacksAndMessages(null);
        this.staticHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (this != null) {
                    WebPlayerDialog.this.closeDialog();
                }
            }
        }, millis);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mAllowOrientationModify = savedInstanceState.getBoolean(ORIENTATION_MODIFY_SAVE_STATE_KEY);
        }
        if (this.mAllowOrientationModify) {
            if (savedInstanceState != null && savedInstanceState.containsKey(ORIENTATION_STATE_SAVE_STATE_KEY)) {
                this.mCurrentOrientationState = savedInstanceState.getInt(ORIENTATION_STATE_SAVE_STATE_KEY);
            } else if (this.mCallingActivity != null && !this.mCallingActivity.isFinishing()) {
                this.mCurrentOrientationState = this.mCallingActivity.getResources().getConfiguration().orientation;
                this.mCallingActivity.setRequestedOrientation(4);
            }
        }
        if (savedInstanceState != null) {
            if (savedInstanceState.containsKey(CONTENT_ITEM_SAVE_STATE_KEY)) {
                this.mContentItem = (ContentItem)((Object)savedInstanceState.getSerializable(CONTENT_ITEM_SAVE_STATE_KEY));
            }
            this.mWebPlayerType = (WebPlayerType)((Object)savedInstanceState.getSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY));
        }
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
            }
        });
        this.initDialogView();
    }

    private void initDialogView() {
        this.mInnerContainer = new RelativeLayout(this.getContext());
        this.setContentView((View)this.mInnerContainer, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (this.mWebPlayerType == WebPlayerType.HTML_PLAYBACK) {
            this.addHtmlPlaybackView();
        } else {
            this.addWebPlayerView();
        }
        this.initTopBar();
        if (this.mWebPlayerType != null && this.mWebPlayerType == WebPlayerType.EXTERNAL_LINK) {
            this.mInnerContainer.setBackgroundColor(Color.parseColor((String)"#77000000"));
            this.mKidozTopBar.setVisibility(4);
        } else {
            this.mInnerContainer.setBackgroundColor(-1);
        }
        if (this.mContentItem.getName() != null) {
            this.mKidozTopBar.setTitle(this.mContentItem.getName());
        } else {
            this.mKidozTopBar.setTitle("");
        }
    }

    private void addHtmlPlaybackView() {
        int paddingTop;
        this.mHtmlViewWrapper = new HtmlViewWrapper((Context)this.mCallingActivity, false);
        this.mHtmlViewWrapper.setInFocusActivityContext((Context)this.mCallingActivity);
        this.mHtmlViewWrapper.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

            @Override
            public void onHtmlStartLoading() {
                super.onHtmlStartLoading();
                WebPlayerDialog.this.mHtmlViewWrapper.showLoadingProgressView();
            }

            @Override
            public void onHtmlFinishedLoading() {
                super.onHtmlFinishedLoading();
                WebPlayerDialog.this.mHtmlViewWrapper.hideLoadingProgressView();
            }

            @Override
            public void onClose() {
                super.onClose();
                WebPlayerDialog.this.closeDialog();
            }
        });
        this.mHtmlViewWrapper.setData(this.mContentItem);
        this.mHtmlViewWrapper.loadHtml();
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        Point point = Utils.getScreenSize(this.getContext());
        params.topMargin = paddingTop = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
        this.mInnerContainer.addView((View)this.mHtmlViewWrapper, (ViewGroup.LayoutParams)params);
    }

    private void addWebPlayerView() {
        this.mWebPlayerView = new WebPlayerView((Context)this.mCallingActivity, this.mWebPlayerType, this.mWidgetType);
        if (this.mContentItem != null) {
            this.mWebPlayerView.loadWebUrl(this.mContentItem.getData(), this.mContentItem.getId());
        }
        this.mWebPlayerView.setOnRemoveViewRequestListener(new WebPlayerView.IOnRemoveViewRequestListener(){

            @Override
            public void onRemoveView() {
                WebPlayerDialog.this.closeDialog();
            }
        });
        this.mInnerContainer.addView((View)this.mWebPlayerView);
    }

    private void initTopBar() {
        this.mKidozTopBar = new KidozTopBar(this.getContext(), true, this.mWidgetType, null);
        this.mKidozTopBar.setId(Utils.generateViewId());
        this.mKidozTopBar.setTopBarBackgroundColor(DEFAULT_TOP_BAR_COLOR);
        this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

            @Override
            public void onExitClicked(View view) {
                WebPlayerDialog.this.closeDialog();
            }
        });
        this.mKidozTopBar.showParentalLockIcon(false);
        this.mInnerContainer.addView((View)this.mKidozTopBar, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        if (bundle != null) {
            bundle.putSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY, (Serializable)((Object)this.mWebPlayerType));
            bundle.putSerializable(ORIENTATION_STATE_SAVE_STATE_KEY, (Serializable)Integer.valueOf(this.mCurrentOrientationState));
            bundle.putBoolean(ORIENTATION_MODIFY_SAVE_STATE_KEY, this.mAllowOrientationModify);
        }
        return bundle;
    }

    @Override
    public void closeDialog() {
        super.closeDialog();
    }

    public void dismiss() {
        super.dismiss();
        if (this.mWebPlayerType != null && (this.mWebPlayerType == WebPlayerType.ONLINE_GAME || this.mWebPlayerType == WebPlayerType.WEB_BROWSER || this.mWebPlayerType == WebPlayerType.HTML_PLAYBACK)) {
            WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_CLOSE, WidgetType.createFromString(this.mWidgetType));
            EventBus.getDefault().post((Object)eventMessage);
        }
    }

    @Override
    public void openDialog() {
        super.openDialog();
        String action = "";
        switch (this.mWebPlayerType) {
            case EXTERNAL_LINK: {
                action = "Web External Link View";
                break;
            }
            case ONLINE_GAME: {
                WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_OPEN, WidgetType.createFromString(this.mWidgetType));
                EventBus.getDefault().post((Object)eventMessage);
                action = "Online Games Player View";
                break;
            }
            case WEB_BROWSER: {
                WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_OPEN, WidgetType.createFromString(this.mWidgetType));
                EventBus.getDefault().post((Object)eventMessage);
                action = "Website View";
                break;
            }
            case HTML_PLAYBACK: {
                WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_OPEN, WidgetType.createFromString(this.mWidgetType));
                EventBus.getDefault().post((Object)eventMessage);
                action = "Html View";
                break;
            }
        }
        EventManager.getInstance(this.getContext()).logEventWithDuration(this.getContext(), this.mWidgetType, this.mStyleId, EventManager.LOG_NORMAL_LEVEL, 1, EventManager.LOG_CLOSE_RESOURCE_LEVEL, "Web Player", action, this.mContentItem.getName(), this.mContentItem.getId(), false);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.staticHandler.removeCallbacksAndMessages(null);
        if (this.mWebPlayerView != null) {
            try {
                this.mWebPlayerView.releaseAndcloseView();
            }
            catch (Exception ex) {
                SDKLogger.printDebbugLog(TAG, "Error when trying to onDetach: " + ex.getMessage());
            }
        }
        if (this.mHtmlViewWrapper != null) {
            try {
                this.mHtmlViewWrapper.stopAndReleaseWebView();
            }
            catch (Exception ex) {
                SDKLogger.printDebbugLog(TAG, "Error when trying to mHtmlViewWrapper.stopAndReleaseWebView(): " + ex.getMessage());
            }
        }
        if (this.mAllowOrientationModify) {
            this.restoreUserOriginalOrientation();
        }
        EventManager.getInstance(this.getContext()).logEventWithDurationEnd(this.getContext(), this.mWidgetType, this.mStyleId, 1, false);
    }

    @Override
    protected void onDialogVisibilityChange(int isVisible) {
        super.onDialogVisibilityChange(isVisible);
        if (isVisible != 0) {
            this.staticHandler.removeCallbacksAndMessages(null);
        }
    }

    @Override
    protected void onDialogWindowVisibilityChange(boolean visible) {
        super.onDialogWindowVisibilityChange(visible);
        if (!visible) {
            this.staticHandler.removeCallbacksAndMessages(null);
        }
    }
}

