/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class KidozWebView
extends WebView {
    protected static final String HTTP = "http://";
    protected static final String HTTPS = "https://";
    protected static final String WWW = "www.";
    protected static final String WWW2 = "www2.";
    protected static final String KIDOZ_DOMAIN = "kidoz";
    protected static final List<String> PREFIXES_TO_REMOVE = new LinkedList<String>();
    private final String TAG = KidozWebView.class.getSimpleName();
    private static int API;
    private Context mContext;
    private ArrayList<String> mAllowedSitesKeyWords = new ArrayList();
    private IOnLounchExternalAppFromRedirectListener onLounchExternalAppFromRedirectListener;
    private WebPlayerType mWebPlayerType = WebPlayerType.WEB_BROWSER;
    private String mGooglePlayAppId = null;

    public KidozWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initWebView();
        this.initForTarget(this.mWebPlayerType);
    }

    public KidozWebView(Context context) {
        super(context);
        this.mContext = context;
        this.initWebView();
        this.initForTarget(this.mWebPlayerType);
    }

    public KidozWebView(Context context, WebPlayerType webPlayerType) {
        super(context);
        this.mContext = context;
        this.mWebPlayerType = webPlayerType;
        this.initWebView();
        this.initForTarget(webPlayerType);
    }

    public void initForTarget(WebPlayerType webPlayerType) {
        if (webPlayerType != null) {
            switch (webPlayerType) {
                case ONLINE_GAME: {
                    this.initOnlineGameSettings(this.getContext());
                    break;
                }
                case WEB_BROWSER: {
                    this.initializeGeneralSettingsState(this.getContext());
                    break;
                }
                case EXTERNAL_LINK: {
                    this.initializeGeneralSettingsState(this.getContext());
                }
            }
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "NewApi"})
    public void initializeGeneralSettingsState(Context context) {
        if (API < 18) {
            this.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (API < 17) {
            this.getSettings().setEnableSmoothTransition(true);
        }
        if (API >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        if (API < 19) {
            this.getSettings().setDatabasePath(context.getCacheDir() + "/databases");
        }
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setAppCachePath(context.getCacheDir().toString());
        this.getSettings().setCacheMode(-1);
        this.getSettings().setGeolocationDatabasePath(context.getFilesDir().toString());
        this.getSettings().setAllowFileAccess(true);
        this.getSettings().setDatabaseEnabled(true);
        this.getSettings().setSupportZoom(true);
        this.getSettings().setBuiltInZoomControls(true);
        this.getSettings().setDisplayZoomControls(false);
        this.getSettings().setAllowContentAccess(true);
        this.getSettings().setDefaultTextEncodingName("utf-8");
        if (API >= 16) {
            this.getSettings().setAllowFileAccessFromFileURLs(false);
            this.getSettings().setAllowUniversalAccessFromFileURLs(false);
        }
        SharedPreferences mPreferences = context.getSharedPreferences("settings", 0);
        this.getSettings().setGeolocationEnabled(mPreferences.getBoolean("location", false));
        if (API < 19) {
            switch (mPreferences.getInt("enableflash", 0)) {
                case 0: {
                    this.getSettings().setPluginState(WebSettings.PluginState.OFF);
                    break;
                }
                case 1: {
                    this.getSettings().setPluginState(WebSettings.PluginState.ON_DEMAND);
                    break;
                }
                case 2: {
                    this.getSettings().setPluginState(WebSettings.PluginState.ON);
                    break;
                }
            }
        }
        if (mPreferences.getBoolean("passwords", false)) {
            if (API < 18) {
                this.getSettings().setSavePassword(true);
            }
            this.getSettings().setSaveFormData(true);
        }
        if (mPreferences.getBoolean("java", true)) {
            this.getSettings().setJavaScriptEnabled(true);
            this.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        }
        if (mPreferences.getBoolean("textreflow", false)) {
            this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        } else if (API >= 19) {
            try {
                this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.TEXT_AUTOSIZING);
            }
            catch (Exception ex) {
                this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
                SDKLogger.printErrorLog(this.TAG, "Error when trying to set layout algorithm: " + ex.getMessage());
            }
        } else {
            this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }
        this.getSettings().setBlockNetworkImage(mPreferences.getBoolean("blockimages", false));
        this.getSettings().setSupportMultipleWindows(mPreferences.getBoolean("newwindows", true));
        this.getSettings().setUseWideViewPort(mPreferences.getBoolean("wideviewport", true));
        this.getSettings().setLoadWithOverviewMode(mPreferences.getBoolean("overviewmode", true));
        switch (mPreferences.getInt("textsize", 3)) {
            case 1: {
                this.getSettings().setTextZoom(200);
                break;
            }
            case 2: {
                this.getSettings().setTextZoom(150);
                break;
            }
            case 3: {
                this.getSettings().setTextZoom(100);
                break;
            }
            case 4: {
                this.getSettings().setTextZoom(75);
                break;
            }
            case 5: {
                this.getSettings().setTextZoom(50);
            }
        }
        if (Build.VERSION.SDK_INT > 22) {
            this.setLayerType(2, null);
        } else {
            this.setLayerType(1, null);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
    }

    @TargetApi(value=19)
    public synchronized void initOnlineGameSettings(Context context) {
        if (API < 18) {
            this.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (API < 17) {
            this.getSettings().setEnableSmoothTransition(true);
        }
        if (API >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(true);
        }
        if (API < 19) {
            this.getSettings().setDatabasePath(context.getCacheDir() + "/databases");
        }
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setLoadWithOverviewMode(true);
        this.getSettings().setAllowContentAccess(true);
        this.getSettings().setUserAgentString("Mozilla/5.0 (Linux; Android 4.4; Nexus 4 Build/KRT16H) AppleWebKit/537.36(KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36");
        this.getSettings().setUseWideViewPort(false);
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setPluginState(WebSettings.PluginState.ON);
        }
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAllowFileAccess(true);
        this.clearHistory();
        this.clearFormData();
        if (API >= 19) {
            try {
                this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.TEXT_AUTOSIZING);
            }
            catch (Exception ex) {
                this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
                SDKLogger.printErrorLog(this.TAG, "Error when trying to set layout algorithm: " + ex.getMessage());
            }
        } else {
            this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }
        if (Build.VERSION.SDK_INT > 22) {
            this.setLayerType(2, null);
        } else {
            this.setLayerType(1, null);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void initWebView() {
        this.setDrawingCacheBackgroundColor(0);
        this.setFocusableInTouchMode(true);
        this.setFocusable(true);
        this.setAnimationCacheEnabled(true);
        this.setDrawingCacheEnabled(true);
        if (API > 15) {
            this.setBackground(null);
            this.getRootView().setBackground(null);
        } else {
            this.getRootView().setBackgroundDrawable(null);
        }
        this.setWillNotCacheDrawing(false);
        this.setAlwaysDrawnWithCacheEnabled(true);
        this.setScrollbarFadingEnabled(true);
        this.setSaveEnabled(true);
        this.setWebChromeClient(new WebChromeClient(){});
        this.initWebChromeClient();
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
    }

    private void initWebChromeClient() {
        this.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                boolean result = true;
                if (KidozWebView.this.mWebPlayerType == WebPlayerType.ONLINE_GAME || KidozWebView.this.mWebPlayerType == WebPlayerType.WEB_BROWSER) {
                    result = !KidozWebView.this.checkIfSafeUrl(url);
                } else if (KidozWebView.this.mWebPlayerType == WebPlayerType.EXTERNAL_LINK) {
                    if (url.contains("market://") || url.contains("play.google.com") && KidozWebView.this.mGooglePlayAppId != null) {
                        try {
                            String googlePlayMarketURL = "market://details?id=" + KidozWebView.this.mGooglePlayAppId;
                            String[] urlPazzel = url.split(KidozWebView.this.mGooglePlayAppId);
                            if (urlPazzel != null && urlPazzel.length > 1) {
                                googlePlayMarketURL = googlePlayMarketURL + urlPazzel[1];
                            }
                            Intent intent = new Intent("android.intent.action.VIEW");
                            intent.setData(Uri.parse((String)googlePlayMarketURL));
                            if (KidozWebView.this.onLounchExternalAppFromRedirectListener != null) {
                                KidozWebView.this.onLounchExternalAppFromRedirectListener.onLounch();
                            }
                            KidozWebView.this.mContext.startActivity(intent);
                        }
                        catch (Exception ex) {
                            SDKLogger.printErrorLog(KidozWebView.this.TAG, "Error when trying to open google play for promoted app: \n" + ex.getMessage());
                        }
                        result = true;
                    } else {
                        view.loadUrl(url);
                        result = true;
                    }
                } else {
                    view.loadUrl(url);
                    result = true;
                }
                return result;
            }
        });
    }

    public void loadWebUrl(String url, String googlePlayAppID) {
        this.mAllowedSitesKeyWords.clear();
        this.mAllowedSitesKeyWords.add(url);
        this.mGooglePlayAppId = googlePlayAppID;
        this.loadUrl(url);
    }

    public void onResume() {
        super.onResume();
    }

    public void onPause() {
        this.stopLoading();
        super.onPause();
    }

    public synchronized void onDestroy() {
        this.stopLoading();
        this.clearHistory();
        this.removeAllViews();
        this.destroyDrawingCache();
    }

    private boolean checkIfSafeUrl(String url) {
        boolean result = false;
        if (url != null) {
            if (url.contains(KIDOZ_DOMAIN)) {
                result = true;
            } else {
                String fixedUrlString;
                String urlStringWithoutPrefix = KidozWebView.removePrefix(url);
                String string = fixedUrlString = urlStringWithoutPrefix != null ? urlStringWithoutPrefix.toLowerCase(Locale.US) : null;
                if (this.mAllowedSitesKeyWords != null) {
                    for (int i = 0; i < this.mAllowedSitesKeyWords.size(); ++i) {
                        String originalUrl = KidozWebView.removePrefix(this.mAllowedSitesKeyWords.get(i));
                        if (!fixedUrlString.contains(originalUrl != null ? originalUrl.toLowerCase(Locale.US) : null)) continue;
                        result = true;
                        break;
                    }
                } else {
                    SDKLogger.printDebbugLog(this.TAG, "Web Player  Not allowed link!");
                }
            }
        }
        return result;
    }

    private static String removePrefix(String urlString) {
        try {
            String modifiedString = urlString.toLowerCase();
            for (String prefixToRemove : PREFIXES_TO_REMOVE) {
                if (!modifiedString.startsWith(prefixToRemove)) continue;
                int lenght = modifiedString.length();
                modifiedString = modifiedString.substring(prefixToRemove.length(), lenght);
            }
            return modifiedString;
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized void stopAndReleaseWebView() {
        this.loadUrl("");
        this.stopLoading();
        this.clearHistory();
        this.removeAllViews();
        this.destroyDrawingCache();
    }

    public void setOnLounchExternalAppFromRedirect(IOnLounchExternalAppFromRedirectListener listener) {
        this.onLounchExternalAppFromRedirectListener = listener;
    }

    static {
        PREFIXES_TO_REMOVE.add(HTTP);
        PREFIXES_TO_REMOVE.add(HTTPS);
        PREFIXES_TO_REMOVE.add(WWW);
        PREFIXES_TO_REMOVE.add(WWW2);
        API = Build.VERSION.SDK_INT;
    }

    public static interface IOnLounchExternalAppFromRedirectListener {
        public void onLounch();
    }
}

