/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebSettings;
import com.kidoz.sdk.api.dialogs.WebDialog.VideoEnabledWebView;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.players.video_player.VideoJavaScriptInterface;
import java.io.File;

public class VideoManager {
    private static VideoManager sVideoManager = null;
    private boolean sIsLoaded = false;
    private VideoEnabledWebView mIFrameVideo;
    private VideoJavaScriptInterface mVideoJavaScriptInterface;
    private String mHtmlVideoUrl;

    protected VideoManager() {
    }

    private void initIFrameVideo(Context context, String url) {
        File path;
        String state;
        this.mHtmlVideoUrl = url;
        this.mIFrameVideo = new VideoEnabledWebView(context);
        this.mIFrameVideo.setVerticalScrollBarEnabled(false);
        this.mIFrameVideo.setHorizontalScrollBarEnabled(false);
        if (Build.VERSION.SDK_INT < 18) {
            this.mIFrameVideo.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (Build.VERSION.SDK_INT > 16) {
            this.mIFrameVideo.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.mIFrameVideo.setLayerType(2, null);
        }
        if ("mounted".equals(state = Environment.getExternalStorageState()) && (path = context.getCacheDir()) != null) {
            this.mIFrameVideo.getSettings().setAppCachePath(path.toString() + "/VideoCache");
        }
        this.mIFrameVideo.getSettings().setPluginState(WebSettings.PluginState.ON);
        this.mIFrameVideo.getSettings().setCacheMode(-1);
        this.mIFrameVideo.getSettings().setLoadWithOverviewMode(true);
        this.mIFrameVideo.getSettings().setJavaScriptEnabled(true);
        this.mIFrameVideo.getSettings().setUseWideViewPort(true);
        this.mIFrameVideo.getSettings().setAppCacheEnabled(true);
        this.mIFrameVideo.getSettings().setSupportZoom(false);
        this.mVideoJavaScriptInterface = new VideoJavaScriptInterface();
        this.mVideoJavaScriptInterface.setLocalReadyListener(new VideoJavaScriptInterface.IOnReadyLocalListener(){

            @Override
            public void onLocalReady() {
                VideoManager.this.sIsLoaded = true;
            }
        });
        this.mIFrameVideo.addJavascriptInterface(this.mVideoJavaScriptInterface, "VideoJavaScriptInterface");
        this.mIFrameVideo.loadUrl(url);
    }

    public boolean isLoaded() {
        return this.sIsLoaded;
    }

    public void reloadHtml() {
        this.mIFrameVideo.loadUrl(this.mHtmlVideoUrl);
    }

    public static VideoManager getInstance(Context context) {
        if (sVideoManager == null) {
            sVideoManager = new VideoManager();
            PropertiesObj appConfig = DatabaseManager.getInstance(context).getConfigTable().loadAppProperties();
            if (appConfig != null && appConfig.getDefaultYouTubePlayerHtmlLink() != null && !appConfig.getDefaultYouTubePlayerHtmlLink().equals("")) {
                sVideoManager.initIFrameVideo(context, appConfig.getDefaultYouTubePlayerHtmlLink());
            } else {
                sVideoManager.initIFrameVideo(context, "http://cdn.kidoz.net/video_player/video_player_sdk.html");
            }
        }
        return sVideoManager;
    }

    public VideoEnabledWebView getIFrameVideo() {
        ViewParent parent;
        if (this.mIFrameVideo != null && (parent = this.mIFrameVideo.getParent()) != null) {
            ((ViewGroup)parent).removeView((View)this.mIFrameVideo);
        }
        return this.mIFrameVideo;
    }

    public VideoJavaScriptInterface getVideoJavaScriptInterface() {
        return this.mVideoJavaScriptInterface;
    }

    public static interface IOnFinishLoadingListener {
        public void onFinishLoading();
    }
}

