/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import org.json.JSONException;
import org.json.JSONObject;

public class PropertiesObj {
    public static final String DEFAULT_YOUTUBE_HTML_URL = "http://cdn.kidoz.net/video_player/video_player_sdk.html";
    private static final String CONFIG_VERSION_KEY = "configuration_version";
    private static final String SDK_STYLE_VERSION_KEY = "style";
    private static final String HTML_LOADER_DEFAULT_URL_KEY = "htmlLoaderDefaultURL";
    private static final String YOUTUBE_PLAYER_DEFAULT_HTML_KEY = "defaultHTMLPlayerURL";
    JSONObject mProperties = new JSONObject();

    public PropertiesObj(JSONObject data) {
        this.mProperties = data;
    }

    public JSONObject getData() {
        return this.mProperties;
    }

    public int getConfigVersion() {
        int result = -1;
        if (this.mProperties != null) {
            result = this.mProperties.optInt(CONFIG_VERSION_KEY, 1);
        }
        return result;
    }

    public int getSdkStyleVersion() {
        int result = -1;
        if (this.mProperties != null) {
            result = this.mProperties.optInt(SDK_STYLE_VERSION_KEY, 0);
        }
        return result;
    }

    public JSONObject getProperties() {
        return this.mProperties;
    }

    public String getHtmlLoaderDefaultLink() {
        String result = "";
        if (this.mProperties != null) {
            result = this.mProperties.optString(HTML_LOADER_DEFAULT_URL_KEY, "");
        }
        return result;
    }

    public String getDefaultYouTubePlayerHtmlLink() {
        String result = DEFAULT_YOUTUBE_HTML_URL;
        if (this.mProperties != null) {
            result = this.mProperties.optString(YOUTUBE_PLAYER_DEFAULT_HTML_KEY, result);
        }
        return result;
    }

    public void setConfigVersion(int version) {
        try {
            this.mProperties.put(CONFIG_VERSION_KEY, version);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateConfigFromData(PropertiesObj data) {
        try {
            if (data != null) {
                this.mProperties.put(CONFIG_VERSION_KEY, data.getConfigVersion());
                this.mProperties.put(SDK_STYLE_VERSION_KEY, data.getSdkStyleVersion());
                this.mProperties.put(HTML_LOADER_DEFAULT_URL_KEY, (Object)data.getHtmlLoaderDefaultLink());
                this.mProperties.put(YOUTUBE_PLAYER_DEFAULT_HTML_KEY, (Object)data.getDefaultYouTubePlayerHtmlLink());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

