/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.content.Context;
import com.kidoz.events.DeviceUtils;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import com.kidoz.sdk.api.ui_views.feed_view.FeedFamilyViewDialog;
import com.kidoz.sdk.api.ui_views.feed_view.FeedViewDialog;
import com.kidoz.sdk.api.ui_views.flexi_view.MovableView;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner1;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner2;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner3;
import com.kidoz.sdk.api.ui_views.panel_view.FamilyPanelView;
import com.kidoz.sdk.api.ui_views.panel_view.StandardPanelView;
import java.io.File;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AssetUtil {
    private static final String TAG = AssetUtil.class.getSimpleName();
    private static final String PANEL_ASSETS = "panel";
    private static final String PANEL_FAMILY_ASSETS = "panelFamily";
    private static final String BANNER_1_ASSETS = "banner1";
    private static final String BANNER_2_ASSETS = "banner2";
    private static final String BANNER_3_ASSETS = "banner3";
    private static final String FEED_ASSETS = "feed";
    private static final String FEED_FAMILY_ASSETS = "feedFamily";
    private static final String FLEXI_VIEW_ASSETS = "flexiView";
    private static final String IMAGE_URL = "imageURL";
    private static final String IMAGE_RATIO = "imageRatio";
    private static final String ANIMATION_KEY = "animationKey";
    private static final String TEXT = "text";
    private static final String COLOR = "color";

    public static boolean parseAndSaveAssets(Context context, String dataResponse) {
        boolean result = false;
        if (context != null && dataResponse != null) {
            try {
                JSONObject rootObject = new JSONObject(dataResponse);
                if (rootObject != null) {
                    if (rootObject.has(BANNER_1_ASSETS)) {
                        result = KidozBanner1.parseKidozBanner(context, rootObject.getJSONObject(BANNER_1_ASSETS));
                    } else if (rootObject.has(BANNER_2_ASSETS)) {
                        result = KidozBanner2.parseKidozBanner(context, rootObject.getJSONObject(BANNER_2_ASSETS));
                    } else if (rootObject.has(BANNER_3_ASSETS)) {
                        result = KidozBanner3.parseKidozBanner(context, rootObject.getJSONObject(BANNER_3_ASSETS));
                    } else if (rootObject.has(FEED_ASSETS)) {
                        result = FeedViewDialog.parseFeedData(context, rootObject.getJSONObject(FEED_ASSETS));
                    } else if (rootObject.has(FEED_FAMILY_ASSETS)) {
                        result = FeedFamilyViewDialog.parseFamilyFeed(context, rootObject.getJSONObject(FEED_FAMILY_ASSETS));
                    } else if (rootObject.has(PANEL_ASSETS)) {
                        result = StandardPanelView.parsePanelData(context, rootObject.getJSONObject(PANEL_ASSETS));
                    } else if (rootObject.has(PANEL_FAMILY_ASSETS)) {
                        result = FamilyPanelView.parseFamilyPanelData(context, rootObject.getJSONObject(PANEL_FAMILY_ASSETS));
                    } else if (rootObject.has(FLEXI_VIEW_ASSETS)) {
                        result = MovableView.parseFlexiViewData(context, rootObject.getJSONObject(FLEXI_VIEW_ASSETS));
                    }
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to parse assets: " + ex.getMessage());
            }
        }
        return result;
    }

    private static String createAssetFileName(String assetURL) {
        String result = null;
        if (assetURL != null) {
            result = assetURL.substring(assetURL.lastIndexOf("/") + 1, assetURL.length());
        }
        return result;
    }

    public static boolean createAssetFile(Context context, String assetURL) {
        boolean result = true;
        if (assetURL != null) {
            String fileName = AssetUtil.createAssetFileName(assetURL);
            File storageLocation = DeviceUtils.getInnerStoragePathIfPosible(context);
            File newFile = new File(storageLocation, fileName);
            if (!newFile.exists()) {
                result = BaseConnectionClient.downloadAndSaveFile(assetURL, newFile);
            }
        }
        return result;
    }

    public static void deleteAssetFile(Context context, String assetURL) {
        if (assetURL != null) {
            String fileName = AssetUtil.createAssetFileName(assetURL);
            File storageLocation = DeviceUtils.getInnerStoragePathIfPosible(context);
            File fileToDelete = new File(storageLocation, fileName);
            if (fileToDelete != null && fileToDelete.exists()) {
                fileToDelete.delete();
            }
        }
    }

    public static File getAssetFile(Context context, String assetURL) {
        File result = null;
        try {
            if (assetURL != null) {
                String fileName = AssetUtil.createAssetFileName(assetURL);
                File storageLocation = DeviceUtils.getInnerStoragePathIfPosible(context);
                result = new File(storageLocation, fileName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean loadAsset(Context context, JSONObject oldProperties, JSONObject newProperties, String assetKey) throws JSONException {
        boolean result = false;
        ArrayList<String> imgList = AssetUtil.generateAssetFileImageList(context, newProperties, assetKey);
        if (!imgList.isEmpty()) {
            for (int i = 0; i < imgList.size(); ++i) {
                if (oldProperties != null) {
                    result = true;
                    String oldAssetURL = oldProperties.optString(assetKey);
                    if (oldAssetURL == null || !oldAssetURL.equals(imgList.get(i)) || !AssetUtil.getAssetFile(context, oldAssetURL).exists() || AssetUtil.getAssetFile(context, oldAssetURL).length() == 0L) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, imgList.get(i));
                    }
                } else {
                    result = AssetUtil.createAssetFile(context, imgList.get(i));
                }
                if (!result) continue;
                newProperties.put(assetKey, (Object)imgList.get(i));
                break;
            }
        }
        return result;
    }

    public static ArrayList<String> generateAssetFileImageList(Context context, JSONObject jsonObject, String key) {
        JSONArray jsonArray;
        ArrayList<String> list = new ArrayList<String>();
        String link = jsonObject.optString(key);
        if (jsonObject.has(key + "Arr") && (jsonArray = jsonObject.optJSONArray(key + "Arr")) != null && jsonArray.length() > 0 && link != null) {
            String stripedLink = link.substring(0, link.lastIndexOf(".") + 1);
            for (int i = 0; i < jsonArray.length(); ++i) {
                String suffix = jsonArray.optString(i, "");
                if (suffix.equals("webp") || suffix.equals("webP") || suffix.equals("WEBP")) {
                    if (!Utils.checkIfDeviceSupportWebPAnimations(context)) continue;
                    list.add(stripedLink + suffix);
                    continue;
                }
                list.add(stripedLink + suffix);
            }
        }
        if (list.isEmpty()) {
            list.add(link);
        }
        return list;
    }
}

