/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.custom_views.CustomCardView;

import android.content.Context;
import android.view.View;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardViewDelegate;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardViewImpl;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozRoundRectDrawable;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozRoundRectDrawableWithShadow;

class KidozCardViewApi21
implements KidozCardViewImpl {
    KidozCardViewApi21() {
    }

    @Override
    public void initialize(KidozCardViewDelegate cardView, Context context, int backgroundColor, float radius, float elevation, float maxElevation) {
        KidozRoundRectDrawable backgroundDrawable = new KidozRoundRectDrawable(backgroundColor, radius);
        cardView.setBackgroundDrawable(backgroundDrawable);
        View view = (View)cardView;
        view.setClipToOutline(true);
        view.setElevation(elevation);
        this.setMaxElevation(cardView, maxElevation);
    }

    @Override
    public void setRadius(KidozCardViewDelegate cardView, float radius) {
        ((KidozRoundRectDrawable)cardView.getBackground()).setRadius(radius);
    }

    @Override
    public void initStatic() {
    }

    @Override
    public void setMaxElevation(KidozCardViewDelegate cardView, float maxElevation) {
        ((KidozRoundRectDrawable)cardView.getBackground()).setPadding(maxElevation, cardView.getUseCompatPadding(), cardView.getPreventCornerOverlap());
        this.updatePadding(cardView);
    }

    @Override
    public float getMaxElevation(KidozCardViewDelegate cardView) {
        return ((KidozRoundRectDrawable)cardView.getBackground()).getPadding();
    }

    @Override
    public float getMinWidth(KidozCardViewDelegate cardView) {
        return this.getRadius(cardView) * 2.0f;
    }

    @Override
    public float getMinHeight(KidozCardViewDelegate cardView) {
        return this.getRadius(cardView) * 2.0f;
    }

    @Override
    public float getRadius(KidozCardViewDelegate cardView) {
        return ((KidozRoundRectDrawable)cardView.getBackground()).getRadius();
    }

    @Override
    public void setElevation(KidozCardViewDelegate cardView, float elevation) {
        ((View)cardView).setElevation(elevation);
    }

    @Override
    public float getElevation(KidozCardViewDelegate cardView) {
        return ((View)cardView).getElevation();
    }

    @Override
    public void updatePadding(KidozCardViewDelegate cardView) {
        if (!cardView.getUseCompatPadding()) {
            cardView.setShadowPadding(0, 0, 0, 0);
            return;
        }
        float elevation = this.getMaxElevation(cardView);
        float radius = this.getRadius(cardView);
        int hPadding = (int)Math.ceil(KidozRoundRectDrawableWithShadow.calculateHorizontalPadding(elevation, radius, cardView.getPreventCornerOverlap()));
        int vPadding = (int)Math.ceil(KidozRoundRectDrawableWithShadow.calculateVerticalPadding(elevation, radius, cardView.getPreventCornerOverlap()));
        cardView.setShadowPadding(hPadding, vPadding, hPadding, vPadding);
    }

    @Override
    public void onCompatPaddingChanged(KidozCardViewDelegate cardView) {
        this.setMaxElevation(cardView, this.getMaxElevation(cardView));
    }

    @Override
    public void onPreventCornerOverlapChanged(KidozCardViewDelegate cardView) {
        this.setMaxElevation(cardView, this.getMaxElevation(cardView));
    }

    @Override
    public void setBackgroundColor(KidozCardViewDelegate cardView, int color) {
        ((KidozRoundRectDrawable)cardView.getBackground()).setColor(color);
    }
}

