/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Looper;
import android.os.Message;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.FullScreenViewDialog;
import com.kidoz.sdk.api.players.web_player.WebPlayerDialog;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.structure.IsEventRecord;
import java.util.List;

public class ContentExecutionHandler {
    public static final String TAG = ContentExecutionHandler.class.getSimpleName();
    public static final int CLICK_REGULATION_TIME_FRAME = 1700;
    public static final int PROMOTED_CONTENT_CLICK_RESTORE_TIMEOUT = 3000;
    public static long mLastClickActionTimeStamp = 0L;
    protected static Utils.StaticHandler mStaticHandler;

    public static void handleContentItemClick(final Context context, final ContentItem contentItem, final String widgetType, final String styleId, final int position, final boolean allowModifyOrientation, final IOnHandleClickListener handleClickListener) {
        if (System.currentTimeMillis() - mLastClickActionTimeStamp > 1700L) {
            switch (contentItem.getContentType()) {
                case GOOGLE_PLAY_APPLICATION: {
                    ContentExecutionHandler.checkForParentalLock(context, new IOnParentalLockStatusListener(){

                        @Override
                        public void onLockActive(boolean isPasswordCorrect) {
                            if (isPasswordCorrect) {
                                ContentExecutionHandler.onGooglePlayApp(context, contentItem, widgetType, styleId, position);
                            } else {
                                EventManager.getInstance(context).logEvent(context, widgetType, styleId, EventManager.LOG_NORMAL_LEVEL, null, "SDK", "Incorrect Password", contentItem.getId());
                            }
                        }

                        @Override
                        public void onLockNotActive() {
                            ContentExecutionHandler.onGooglePlayApp(context, contentItem, widgetType, styleId, position);
                        }
                    });
                    break;
                }
                case PROMOTED_PLAY_APPLICATION: {
                    if (context == null || contentItem == null) break;
                    ContentExecutionHandler.checkForParentalLock(context, new IOnParentalLockStatusListener(){

                        @Override
                        public void onLockActive(boolean isPasswordCorrect) {
                            if (isPasswordCorrect) {
                                ContentExecutionHandler.onPromotedAppItemClick(context, contentItem, widgetType, styleId, position, allowModifyOrientation);
                                IsEventRecord isEventRecord = new IsEventRecord();
                                isEventRecord.setPackageName(contentItem.getId());
                                isEventRecord.setContentType(contentItem.getContentType().toString());
                                isEventRecord.setName(contentItem.getName());
                                isEventRecord.setPositionIndex(position);
                                isEventRecord.setAdvertiserId(contentItem.getAdvertiserID());
                                isEventRecord.setTimeStamp(System.currentTimeMillis() + "");
                                isEventRecord.setWidgetType(widgetType);
                                isEventRecord.setStyleId(styleId);
                                DatabaseManager.getInstance(context).getIsEventTable().insertRecord(isEventRecord);
                            } else {
                                EventManager.getInstance(context).logEvent(context, widgetType, styleId, EventManager.LOG_NORMAL_LEVEL, null, "Sponsored Content", "Incorrect Password", contentItem.getId());
                            }
                        }

                        @Override
                        public void onLockNotActive() {
                            ContentExecutionHandler.onPromotedAppItemClick(context, contentItem, widgetType, styleId, position, allowModifyOrientation);
                            IsEventRecord isEventRecord = new IsEventRecord();
                            isEventRecord.setPackageName(contentItem.getId());
                            isEventRecord.setContentType(contentItem.getContentType().toString());
                            isEventRecord.setName(contentItem.getName());
                            isEventRecord.setPositionIndex(position);
                            isEventRecord.setAdvertiserId(contentItem.getAdvertiserID());
                            isEventRecord.setTimeStamp(System.currentTimeMillis() + "");
                            isEventRecord.setWidgetType(widgetType);
                            isEventRecord.setStyleId(styleId);
                            DatabaseManager.getInstance(context).getIsEventTable().insertRecord(isEventRecord);
                        }
                    });
                    break;
                }
                case WEB_GAME_URL: {
                    ContentExecutionHandler.onlineGameItemClick(context, contentItem, widgetType, styleId, position, allowModifyOrientation);
                    break;
                }
                case WEBSITE_URL: {
                    if (contentItem.isPromoted()) {
                        EventManager.getInstance(context).logSponsoredContentClickEvent(context, widgetType, styleId, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
                    } else {
                        EventManager.getInstance(context).logClickEvent(context, widgetType, styleId, "Feed Click", "URL", contentItem.getId(), position);
                    }
                    ContentExecutionHandler.onUrlItemClick(context, contentItem, widgetType, styleId, position, allowModifyOrientation);
                    break;
                }
                case YOUTUBE_VIDEO: 
                case STREAMING_VIDEO: {
                    ContentExecutionHandler.onYouTubeVideolItemClick(context, contentItem, widgetType, styleId, position, allowModifyOrientation);
                    break;
                }
                case EXTERNAL_BROWSER_URL: {
                    if (contentItem.isPromoted()) {
                        ContentExecutionHandler.checkForParentalLock(context, new IOnParentalLockStatusListener(){

                            @Override
                            public void onLockActive(boolean isPasswordCorrect) {
                                if (isPasswordCorrect) {
                                    ContentExecutionHandler.onExternalLinkItemClick(context, contentItem, widgetType, styleId, position);
                                } else {
                                    EventManager.getInstance(context).logEvent(context, widgetType, styleId, EventManager.LOG_NORMAL_LEVEL, null, "Sponsored Content", "Incorrect Password", contentItem.getId());
                                }
                            }

                            @Override
                            public void onLockNotActive() {
                                ContentExecutionHandler.onExternalLinkItemClick(context, contentItem, widgetType, styleId, position);
                            }
                        });
                        break;
                    }
                    ContentExecutionHandler.onExternalLinkItemClick(context, contentItem, widgetType, styleId, position);
                    break;
                }
                case HTML: {
                    ContentExecutionHandler.onHtmlItemClick(context, contentItem, widgetType, styleId, position, allowModifyOrientation);
                }
            }
            mLastClickActionTimeStamp = System.currentTimeMillis();
            ContentExecutionHandler.getUiHandlerInstance().removeCallbacksAndMessages(null);
            ContentExecutionHandler.getUiHandlerInstance().postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (handleClickListener != null) {
                            handleClickListener.onRestoreClick();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 3000L);
        }
    }

    protected static void onPromotedAppItemClick(Context context, ContentItem contentItem, String widgetType, String styleId, int position, boolean allowModifyOrientation) {
        block6: {
            if (contentItem != null && contentItem.getData() != null && contentItem.getData().contains("market://") || contentItem.getData().contains("play.google.com")) {
                try {
                    String googlePlayMarketURL = "market://details?id=" + contentItem.getId();
                    String[] urlPazzel = contentItem.getData().split(contentItem.getId());
                    if (urlPazzel != null && urlPazzel.length > 1) {
                        googlePlayMarketURL = googlePlayMarketURL + urlPazzel[1];
                    }
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)googlePlayMarketURL));
                    List availableIntents = context.getPackageManager().queryIntentActivities(intent, 0);
                    if (availableIntents == null || availableIntents.isEmpty()) {
                        EventManager.getInstance(context).logSponsoredContentClickEvent(context, widgetType, styleId, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
                        ContentExecutionHandler.onUrlItemClick(context, contentItem, widgetType, styleId, position, allowModifyOrientation);
                        break block6;
                    }
                    EventManager.getInstance(context).logSponsoredContentClickEvent(context, widgetType, styleId, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
                    context.startActivity(intent);
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(TAG, "Error when trying to open google play for promoted app: \n" + ex.getMessage());
                }
            } else {
                EventManager.getInstance(context).logSponsoredContentClickEvent(context, widgetType, styleId, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
                ContentExecutionHandler.onUrlItemClick(context, contentItem, widgetType, styleId, position, allowModifyOrientation);
            }
        }
    }

    protected static void onGooglePlayApp(Context context, ContentItem contentItem, String widgetType, String styleId, int position) {
        if (contentItem.isPromoted()) {
            EventManager.getInstance(context).logSponsoredContentClickEvent(context, widgetType, styleId, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
        } else {
            EventManager.getInstance(context).logClickEvent(context, widgetType, styleId, "Feed Click", "Google Play App", contentItem.getId(), position);
        }
        Intent googlePlayIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + contentItem.getId())));
        googlePlayIntent.addFlags(0x10000000);
        googlePlayIntent.addFlags(32768);
        context.startActivity(googlePlayIntent);
    }

    protected static void onlineGameItemClick(Context context, ContentItem contentItem, String widgetType, String styleId, int position, boolean allowModifyOrientation) {
        if (contentItem.isPromoted()) {
            EventManager.getInstance(context).logSponsoredContentClickEvent(context, widgetType, styleId, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
        } else {
            EventManager.getInstance(context).logClickEvent(context, widgetType, styleId, "Feed Click", "Online Game", contentItem.getId(), position);
        }
        WebPlayerDialog webPlayerDialog = new WebPlayerDialog(context, contentItem, widgetType, styleId, WebPlayerType.ONLINE_GAME, allowModifyOrientation);
        webPlayerDialog.openDialog();
    }

    protected static void onUrlItemClick(Context context, ContentItem contentItem, String widgetType, String styleId, int position, boolean allowModifyOrientation) {
        WebPlayerType webPlayerType = WebPlayerType.WEB_BROWSER;
        if (contentItem != null && contentItem.getContentType() == ContentType.PROMOTED_PLAY_APPLICATION) {
            webPlayerType = WebPlayerType.EXTERNAL_LINK;
        }
        WebPlayerDialog webPlayerDialog = new WebPlayerDialog(context, contentItem, widgetType, styleId, webPlayerType, allowModifyOrientation);
        if (contentItem != null && contentItem.getContentType() == ContentType.PROMOTED_PLAY_APPLICATION) {
            webPlayerDialog.setAutoCloseTimer(10000);
        }
        webPlayerDialog.openDialog();
    }

    protected static void onHtmlItemClick(Context context, ContentItem contentItem, String widgetType, String styleId, int position, boolean allowModifyOrientation) {
        WebPlayerDialog webPlayerDialog = new WebPlayerDialog(context, contentItem, widgetType, styleId, WebPlayerType.HTML_PLAYBACK, allowModifyOrientation);
        webPlayerDialog.openDialog();
    }

    protected static void onYouTubeVideolItemClick(Context context, ContentItem contentItem, String widgetType, String styleId, int position, boolean allowModifyOrientation) {
        if (context != null && contentItem != null && contentItem.getData() != null) {
            FullScreenViewDialog fullScreenViewDialog = new FullScreenViewDialog(context, widgetType, styleId, allowModifyOrientation);
            fullScreenViewDialog.openDialog(contentItem);
            if (contentItem.isPromoted()) {
                EventManager.getInstance(context).logSponsoredContentClickEvent(context, widgetType, styleId, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
            } else {
                EventManager.getInstance(context).logClickEvent(context, widgetType, styleId, "Feed Click", "Youtube", contentItem.getId(), position);
            }
        }
    }

    private static void onExternalLinkItemClick(Context context, ContentItem contentItem, String widgetType, String styleId, int position) {
        if (contentItem.isPromoted()) {
            EventManager.getInstance(context).logSponsoredContentClickEvent(context, widgetType, styleId, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
        } else {
            EventManager.getInstance(context).logClickEvent(context, widgetType, styleId, "Feed Click", "External Url", contentItem.getId(), position);
        }
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)contentItem.getData()));
        context.startActivity(i);
    }

    public static void checkForParentalLock(Context context, final IOnParentalLockStatusListener lockStatusListener) {
        boolean isLockActive;
        boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(context, "PARENTAL_LOCK_ACTIVE_KEY") != null;
        if (isLockActive && ParentalLockDialog.getIsCanShowDialog(context)) {
            int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(context, true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(context, false) * 0.5f)};
            ParentalLockDialog parentalLockDialog = new ParentalLockDialog(context, true, popLocation);
            parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                @Override
                public void onPasswordEntered(boolean isPasswordCorrect) {
                    lockStatusListener.onLockActive(isPasswordCorrect);
                }
            });
            parentalLockDialog.show();
        } else {
            lockStatusListener.onLockNotActive();
        }
    }

    private static Utils.StaticHandler getUiHandlerInstance() {
        if (mStaticHandler == null) {
            mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()){

                @Override
                public void handleMessage(Message message) {
                }
            };
        }
        return mStaticHandler;
    }

    public static interface IOnParentalLockStatusListener {
        public void onLockActive(boolean var1);

        public void onLockNotActive();
    }

    public static interface IOnHandleClickListener {
        public void onRestoreClick();
    }
}

