/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.dialogs.WebDialog;

import android.media.MediaPlayer;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.VideoView;
import com.kidoz.sdk.api.dialogs.WebDialog.VideoEnabledWebView;

public class VideoEnabledWebChromeClient
extends WebChromeClient
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    private View activityNonVideoView;
    private ViewGroup activityVideoView;
    private View loadingView;
    private VideoEnabledWebView webView;
    private boolean isVideoFullscreen;
    private FrameLayout videoViewContainer;
    private WebChromeClient.CustomViewCallback videoViewCallback;
    private ToggledFullscreenCallback toggledFullscreenCallback;

    public VideoEnabledWebChromeClient() {
    }

    public VideoEnabledWebChromeClient(View activityNonVideoView, ViewGroup activityVideoView) {
        this.activityNonVideoView = activityNonVideoView;
        this.activityVideoView = activityVideoView;
        this.loadingView = null;
        this.webView = null;
        this.isVideoFullscreen = false;
    }

    public VideoEnabledWebChromeClient(View activityNonVideoView, ViewGroup activityVideoView, View loadingView) {
        this.activityNonVideoView = activityNonVideoView;
        this.activityVideoView = activityVideoView;
        this.loadingView = loadingView;
        this.webView = null;
        this.isVideoFullscreen = false;
    }

    public VideoEnabledWebChromeClient(View activityNonVideoView, ViewGroup activityVideoView, View loadingView, VideoEnabledWebView webView) {
        this.activityNonVideoView = activityNonVideoView;
        this.activityVideoView = activityVideoView;
        this.loadingView = loadingView;
        this.webView = webView;
        this.isVideoFullscreen = false;
    }

    public boolean isVideoFullscreen() {
        return this.isVideoFullscreen;
    }

    public void setOnToggledFullscreen(ToggledFullscreenCallback callback) {
        this.toggledFullscreenCallback = callback;
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        if (view instanceof FrameLayout) {
            FrameLayout frameLayout = (FrameLayout)view;
            View focusedChild = frameLayout.getFocusedChild();
            this.isVideoFullscreen = true;
            this.videoViewContainer = frameLayout;
            this.videoViewCallback = callback;
            this.activityNonVideoView.setVisibility(4);
            this.activityVideoView.addView((View)this.videoViewContainer, new ViewGroup.LayoutParams(-1, -1));
            this.activityVideoView.setVisibility(0);
            if (focusedChild instanceof VideoView) {
                VideoView videoView = (VideoView)focusedChild;
                videoView.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
                videoView.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
                videoView.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            } else if (this.webView != null && this.webView.getSettings().getJavaScriptEnabled()) {
                String js = "javascript:";
                js = js + "_ytrp_html5_video = document.getElementsByTagName('video')[0];";
                js = js + "if (_ytrp_html5_video !== undefined) {";
                js = js + "function _ytrp_html5_video_ended() {";
                js = js + "_ytrp_html5_video.removeEventListener('ended', _ytrp_html5_video_ended);";
                js = js + "_VideoEnabledWebView.notifyVideoEnd();";
                js = js + "}";
                js = js + "_ytrp_html5_video.addEventListener('ended', _ytrp_html5_video_ended);";
                js = js + "}";
                this.webView.loadUrl(js);
            }
            if (this.toggledFullscreenCallback != null) {
                this.toggledFullscreenCallback.toggledFullscreen(true);
            }
        }
    }

    public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
        this.onShowCustomView(view, callback);
    }

    public void onHideCustomView() {
        if (this.isVideoFullscreen) {
            this.activityVideoView.setVisibility(4);
            this.activityVideoView.removeView((View)this.videoViewContainer);
            this.activityNonVideoView.setVisibility(0);
            if (this.videoViewCallback != null) {
                this.videoViewCallback.onCustomViewHidden();
            }
            this.isVideoFullscreen = false;
            this.videoViewContainer = null;
            this.videoViewCallback = null;
            if (this.toggledFullscreenCallback != null) {
                this.toggledFullscreenCallback.toggledFullscreen(false);
            }
        }
    }

    public View getVideoLoadingProgressView() {
        if (this.loadingView != null) {
            this.loadingView.setVisibility(0);
            return this.loadingView;
        }
        return super.getVideoLoadingProgressView();
    }

    public void onPrepared(MediaPlayer mp) {
        if (this.loadingView != null) {
            this.loadingView.setVisibility(8);
        }
        this.onShowCustomView((View)this.videoViewContainer, 0, this.videoViewCallback);
    }

    public void onCompletion(MediaPlayer mp) {
        this.onHideCustomView();
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        return false;
    }

    public boolean onBackPressed() {
        if (this.isVideoFullscreen) {
            this.onHideCustomView();
            return true;
        }
        return false;
    }

    public static interface ToggledFullscreenCallback {
        public void toggledFullscreen(boolean var1);
    }
}

