/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.interfaces.KidozPlayerEventHelper;
import com.kidoz.sdk.api.interfaces.KidozPlayerListener;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.ui_views.panel_view.AbstractPanelView;
import com.kidoz.sdk.api.ui_views.panel_view.FamilyPanelView;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.StandardPanelView;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class PanelView
extends RelativeLayout {
    public static final String TAG = PanelView.class.getSimpleName();
    private AbstractPanelView mAbstractPanelView;
    private PANEL_TYPE mPanelType = PANEL_TYPE.BOTTOM;
    private HANDLE_POSITION mHandlePosition = HANDLE_POSITION.START;
    private IOnPanelViewEventListener mIOnPanelViewEventListener = null;
    private int mColor = 0;
    private KidozPlayerEventHelper mKidozPlayerEventHelper;
    private float mFLstartDelay = -1.0f;
    private float mFLopenPeriod = -1.0f;
    private float mFLopenRepeatTimeFarame = -1.0f;
    private KidozPlayerListener mKidozPlayerListener;
    private Lock raceConditionLock = new ReentrantLock();

    public PanelView(Context context) {
        super(context);
        this.initView();
    }

    public PanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public PanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setKidozPlayerListener(KidozPlayerListener kidozPlayerListener) {
        this.mKidozPlayerListener = kidozPlayerListener;
    }

    private void initView() {
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.setBackgroundColor(0);
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (KidozSDK.isInitialised()) {
            this.validateLayoutAndAssets();
        }
        this.mKidozPlayerEventHelper = new KidozPlayerEventHelper(new KidozPlayerEventHelper.IPlayerListener(){

            @Override
            public void onOpen(boolean isMaximizedPlayer) {
                if (PanelView.this.mKidozPlayerListener != null) {
                    PanelView.this.mKidozPlayerListener.onPlayerOpen();
                }
                if (PanelView.this.mAbstractPanelView != null && PanelView.this.mAbstractPanelView instanceof FamilyPanelView) {
                    ((FamilyPanelView)PanelView.this.mAbstractPanelView).pauseAction(isMaximizedPlayer);
                }
            }

            @Override
            public void onClose(boolean isMaximizedPlayer) {
                if (PanelView.this.mKidozPlayerListener != null) {
                    PanelView.this.mKidozPlayerListener.onPlayerClose();
                }
                if (PanelView.this.mAbstractPanelView != null && PanelView.this.mAbstractPanelView instanceof FamilyPanelView) {
                    ((FamilyPanelView)PanelView.this.mAbstractPanelView).resumeAction(isMaximizedPlayer);
                }
            }
        }, WidgetType.WIDGET_TYPE_PANEL);
    }

    private void validateLayoutAndAssets() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.raceConditionLock.tryLock()) {
            try {
                SdkAPIManager.getSdkApiInstance(this.getContext()).getStyle(this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getValue(), new ApiResultCallback<Boolean>(){

                    @Override
                    public void onServerResult(ResultData<?> result) {
                        if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful()) {
                            if (result.getData() != null) {
                                boolean isAssetsReady = (Boolean)result.getData();
                                if (isAssetsReady) {
                                    PanelView.this.buildPanelView();
                                } else {
                                    this.onFailed();
                                }
                            }
                        } else {
                            this.onFailed();
                        }
                    }

                    @Override
                    public void onFailed() {
                    }
                });
            }
            finally {
                this.raceConditionLock.unlock();
            }
        }
    }

    private void buildPanelView() {
        JSONObject jsonObject = DatabaseManager.getInstance(this.getContext()).getConfigTable().loadProperties(TAG);
        if (jsonObject != null) {
            String panelType = jsonObject.optString(TAG);
            if (panelType.equals(StandardPanelView.TAG)) {
                this.mAbstractPanelView = new StandardPanelView(this.getContext(), jsonObject);
            } else if (panelType.equals(FamilyPanelView.TAG)) {
                this.mAbstractPanelView = new FamilyPanelView(this.getContext(), jsonObject);
            }
            if (this.mPanelType != null && this.mHandlePosition != null) {
                this.mAbstractPanelView.setPanelConfiguration(this.mPanelType, this.mHandlePosition);
            }
            if (this.mIOnPanelViewEventListener != null) {
                this.mAbstractPanelView.setOnPanelViewEventListener(this.mIOnPanelViewEventListener);
            }
            int color = -1;
            try {
                color = Color.parseColor((String)jsonObject.optString("panelBgClr", "#ffffff"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jsonObject.optInt("overrideUserProperties", 0) == 0 && this.mColor != 0) {
                color = this.mColor;
            }
            this.mAbstractPanelView.setPanelColor(color);
            this.mAbstractPanelView.setAutoExpandOnStart(this.mFLstartDelay, this.mFLopenPeriod, this.mFLopenRepeatTimeFarame);
        }
        if (this.mKidozPlayerEventHelper != null) {
            this.mKidozPlayerEventHelper.register();
        }
        this.addView((View)this.mAbstractPanelView);
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            this.validateLayoutAndAssets();
        }
    }

    public void setPanelColor(int color) {
        JSONObject jsonObject;
        this.mColor = color;
        if (this.mAbstractPanelView != null && (jsonObject = DatabaseManager.getInstance(this.getContext()).getConfigTable().loadProperties(TAG)) != null && jsonObject.optInt("overrideUserProperties", 0) == 0) {
            this.mAbstractPanelView.setPanelColor(color);
        }
    }

    public void collapsePanelView() {
        if (this.mAbstractPanelView != null) {
            this.mAbstractPanelView.collapsePanelView();
        }
    }

    public void expandPanelView() {
        if (this.mAbstractPanelView != null) {
            this.mAbstractPanelView.expandPanelView();
        }
    }

    public void setPanelConfiguration(PANEL_TYPE panelType, HANDLE_POSITION handlePosition) {
        this.mPanelType = panelType;
        this.mHandlePosition = handlePosition;
        if (this.mAbstractPanelView != null) {
            this.mAbstractPanelView.setPanelConfiguration(panelType, handlePosition);
        }
    }

    public void setPanelAutoExpand(float startDelay, float showPeriod) {
        this.mFLstartDelay = startDelay;
        this.mFLopenPeriod = showPeriod;
        if (this.mAbstractPanelView != null) {
            this.mAbstractPanelView.setAutoExpandOnStart(startDelay, startDelay, -1.0f);
        }
    }

    public void setPanelAutoExpand(float startDelay, float showPeriod, float repeatTimeFrame) {
        this.mFLstartDelay = startDelay;
        this.mFLopenPeriod = showPeriod;
        this.mFLopenRepeatTimeFarame = repeatTimeFrame;
        if (this.mAbstractPanelView != null) {
            this.mAbstractPanelView.setAutoExpandOnStart(startDelay, startDelay, repeatTimeFrame);
        }
    }

    public void setOnPanelViewEventListener(IOnPanelViewEventListener iOnPanelViewEventListener) {
        this.mIOnPanelViewEventListener = iOnPanelViewEventListener;
        if (this.mAbstractPanelView != null) {
            this.mAbstractPanelView.setOnPanelViewEventListener(iOnPanelViewEventListener);
        }
    }

    public boolean getIsPanelViewExpanded() {
        if (this.mAbstractPanelView != null) {
            return this.mAbstractPanelView.getIsPanelViewExpanded();
        }
        return false;
    }

    protected void onDetachedFromWindow() {
        try {
            if (EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().unregister((Object)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mKidozPlayerEventHelper != null) {
            this.mKidozPlayerEventHelper.unRegister();
        }
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mKidozPlayerEventHelper != null) {
            this.mKidozPlayerEventHelper.register();
        }
    }

    public void setVisibility(int visibility) {
        if (visibility == 8) {
            visibility = 4;
        }
        super.setVisibility(visibility);
    }
}

