/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Looper;
import android.os.Message;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.FlexiViewListener;
import com.kidoz.sdk.api.interfaces.KidozPlayerEventHelper;
import com.kidoz.sdk.api.interfaces.KidozPlayerListener;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.flexi_view.FLEXI_POSITION;
import com.kidoz.sdk.api.ui_views.flexi_view.MovableView;
import com.squareup.imagelib.Callback;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class FlexiView
extends FrameLayout {
    public static final String TAG = FlexiView.class.getSimpleName();
    private static final int INVALID_POINTER_ID = -1;
    private static final long MOVE_TO_EDGE_DURATION = 400L;
    private static final float MOVE_TO_EDGE_OVERSHOOT_TENSION = 1.0f;
    private static final long NOTICE_DEFAULT_ANIMATION_CYCLE_INTERVAL = 2500L;
    private static final int CONTENT_DEFAULT_REFRESH_RATE_SECONDS = 25;
    private static final int START_NOTICE_ME_ANIMATION = 0;
    private static final int STOP_NOTICE_ME_ANIMATION = 1;
    private Lock raceConditionLock = new ReentrantLock();
    private JSONObject mProperties;
    private FlexiViewListener mFlexiViewListener;
    private TimeInterpolator mMoveEdgeInterpolator;
    private TimeInterpolator mFlingMoveLinearInterpolator;
    private AnimatorSet mFlingAnimation;
    private boolean mIsSelected = false;
    private boolean mIsDraggable = true;
    private boolean mIsSoundEnabled = true;
    private int mUserSetDragable = -1;
    private int mUserSetClosable = -1;
    private int mUserSetSound = -1;
    private float mLastTouchX;
    private float mLastTouchY;
    private int mSingleFingerActivePointerId;
    private Rect mContainerViewRect = new Rect();
    private Rect mFlexiViewPosRect = new Rect();
    private MovableView mMovableView;
    private ValueAnimator mMoveEdgeAnimatorX;
    private ValueAnimator mMoveEdgeAnimatorY;
    private ContentLogicLoader mContentLogicLoader;
    private String mStyleId;
    private ArrayList<ContentItem> mShowingListContentList = new ArrayList();
    private int mCurrentShowingItemIndex = 0;
    private boolean mIsCyclingContent = false;
    private GestureDetector mGestureDetector;
    private Utils.StaticHandler mStaticHandler;
    private boolean mAllowFling = true;
    private boolean mAllowClickHandling = true;
    private boolean mAllowViewInitiation = false;
    private boolean mIsAutoShowOnCreate = false;
    private Utils.StaticHandler mAnimationHandler;
    private AnimatorSet mNoticeAnimationSet;
    private boolean mIsAnimateNotice = false;
    private NoticeAnimType mNoticeAnimType;
    private long mNoticeAnimCycleRate = 2500L;
    private long mContentRefreshRate = 25L;
    private FLEXI_POSITION mFlexiPosition = FLEXI_POSITION.TOP_START;
    private Point mStartPointCoord = new Point(0, 0);
    private KidozPlayerEventHelper mKidozPlayerEventHelper;
    private KidozPlayerListener mKidozPlayerListener;

    public FlexiView(Context context) {
        super(context);
        this.initView();
    }

    public FlexiView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public FlexiView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setKidozPlayerListener(KidozPlayerListener kidozPlayerListener) {
        this.mKidozPlayerListener = kidozPlayerListener;
    }

    private void initView() {
        this.setBackgroundColor(Color.parseColor((String)"#01ffffff"));
        this.initContentLoader();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        if (KidozSDK.isInitialised()) {
            this.validateLayoutAndAssets();
        }
        this.initGestureListener();
        this.mMoveEdgeInterpolator = new OvershootInterpolator(1.0f);
        this.mFlingMoveLinearInterpolator = new LinearOutSlowInInterpolator();
        this.mKidozPlayerEventHelper = new KidozPlayerEventHelper(new KidozPlayerEventHelper.IPlayerListener(){

            @Override
            public void onOpen(boolean isMaximizedPlayer) {
                if (FlexiView.this.mKidozPlayerListener != null) {
                    FlexiView.this.mKidozPlayerListener.onPlayerOpen();
                }
            }

            @Override
            public void onClose(boolean isMaximizedPlayer) {
                if (FlexiView.this.mKidozPlayerListener != null) {
                    FlexiView.this.mKidozPlayerListener.onPlayerClose();
                }
            }
        }, WidgetType.WIDGET_TYPE_FLEXI_VIEW);
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            this.validateLayoutAndAssets();
        }
    }

    private void validateLayoutAndAssets() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.raceConditionLock.tryLock()) {
            try {
                this.mAllowViewInitiation = true;
                SdkAPIManager.getSdkApiInstance(this.getContext()).getStyle(this.getContext(), WidgetType.WIDGET_TYPE_FLEXI_VIEW.getValue(), new ApiResultCallback<Boolean>(){

                    @Override
                    public void onServerResult(ResultData<?> result) {
                        if (FlexiView.this.mAllowViewInitiation) {
                            if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful()) {
                                if (result.getData() != null) {
                                    boolean isAssetsReady = (Boolean)result.getData();
                                    if (isAssetsReady) {
                                        FlexiView.this.mProperties = DatabaseManager.getInstance(FlexiView.this.getContext()).getConfigTable().loadProperties(TAG);
                                        if (FlexiView.this.mProperties != null) {
                                            File soundFile;
                                            FlexiView.this.mNoticeAnimCycleRate = FlexiView.this.mProperties.optLong("flexiNoticeMeAnimRateMillis", 2500L);
                                            FlexiView.this.mContentRefreshRate = FlexiView.this.mProperties.optInt("flexiContentRefreshRateSec", 25) * 1000;
                                            FlexiView.this.mIsDraggable = FlexiView.this.mProperties.optInt("flexiIsDraggable", 1) == 1;
                                            boolean closable = FlexiView.this.mProperties.optInt("flexiIsClosable", 1) == 1;
                                            FlexiView.this.mIsSoundEnabled = FlexiView.this.mProperties.optInt("flexiEnableSound", 1) == 1;
                                            if (FlexiView.this.mProperties.optInt("flexiIsOverrideUserSet", 0) == 0) {
                                                if (FlexiView.this.mUserSetDragable != -1) {
                                                    FlexiView.this.mIsDraggable = FlexiView.this.mUserSetDragable == 1;
                                                }
                                                if (FlexiView.this.mUserSetClosable != -1) {
                                                    boolean bl = closable = FlexiView.this.mUserSetClosable == 1;
                                                }
                                                if (FlexiView.this.mUserSetSound != -1) {
                                                    FlexiView.this.mIsSoundEnabled = FlexiView.this.mUserSetSound == 1;
                                                }
                                            }
                                            if ((soundFile = AssetUtil.getAssetFile(FlexiView.this.getContext(), FlexiView.this.mProperties.optString("flexiPopSound", null))) != null) {
                                                SdkSoundManager.preloadSound(soundFile.getPath());
                                            }
                                            if (FlexiView.this.mIsSoundEnabled && (soundFile = AssetUtil.getAssetFile(FlexiView.this.getContext(), FlexiView.this.mProperties.optString("flexiContentSwapSound", null))) != null) {
                                                SdkSoundManager.preloadSound(soundFile.getPath());
                                            }
                                            FlexiView.this.initMovableView(FlexiView.this.mProperties, closable);
                                            FlexiView.this.initNoticeAnimation(FlexiView.this.mProperties);
                                        }
                                    } else {
                                        this.onFailed();
                                    }
                                }
                            } else {
                                this.onFailed();
                            }
                        }
                    }

                    @Override
                    public void onFailed() {
                    }
                });
            }
            finally {
                this.raceConditionLock.unlock();
            }
        }
    }

    private void initMovableView(JSONObject mProperties, boolean closable) {
        this.mStyleId = mProperties.optString("style_id");
        this.mMovableView = new MovableView(this.getContext(), mProperties, new MovableView.IMovableActionListener(){

            @Override
            public void onCloseClick() {
                FlexiView.this.hideFlexiView();
                FlexiView.this.invokeNoticeAnimationEvent(1);
                EventManager.getInstance(FlexiView.this.getContext()).logEvent(FlexiView.this.getContext(), WidgetType.WIDGET_TYPE_FLEXI_VIEW.getStringValue(), FlexiView.this.mStyleId, EventManager.LOG_NORMAL_LEVEL, null, "SDK", "Click", "Close");
            }
        });
        this.mMovableView.showCloseBtn(closable);
        FrameLayout.LayoutParams mViewParams = new FrameLayout.LayoutParams(-2, -2);
        this.addView((View)this.mMovableView, (ViewGroup.LayoutParams)mViewParams);
        Utils.setOnGlobalLayoutFinishListener((View)this.mMovableView, new Utils.OnGlobalLayoutFinishedListener(){

            @Override
            public void onLayoutFinished() {
                FlexiView.this.mMovableView.bringToFront();
                FlexiView.this.mFlexiViewPosRect = new Rect(0, 0, FlexiView.this.mMovableView.getWidth(), FlexiView.this.mMovableView.getWidth());
                ((FlexiView)FlexiView.this).mMovableView.getLayoutParams().width = FlexiView.this.mMovableView.getWidth();
                ((FlexiView)FlexiView.this).mMovableView.getLayoutParams().height = FlexiView.this.mMovableView.getWidth();
                FlexiView.this.mMovableView.loadSecondaryAssets(new MovableView.IMovableAssetReadyListener(){

                    @Override
                    public void onAssetsReady() {
                        FlexiView.this.mContentLogicLoader.loadContent(FlexiView.this.getContext(), WidgetType.WIDGET_TYPE_FLEXI_VIEW.getStringValue(), FlexiView.this.mStyleId);
                    }
                });
            }
        });
    }

    private void initContentLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                if (contentData != null && contentData.isHasContentToShow()) {
                    FlexiView.this.mShowingListContentList = new ArrayList();
                    for (int i = 0; i < contentData.getContentDataItems().size(); ++i) {
                        if (!contentData.getContentDataItems().get(i).isPromoted()) continue;
                        FlexiView.this.mShowingListContentList.add(contentData.getContentDataItems().get(i));
                    }
                    if (FlexiView.this.mShowingListContentList.isEmpty()) {
                        FlexiView.this.mShowingListContentList.addAll(contentData.getContentDataItems());
                    }
                    if (FlexiView.this.mMovableView != null) {
                        FlexiView.this.mMovableView.loadMainAsset(((ContentItem)FlexiView.this.mShowingListContentList.get(FlexiView.this.mCurrentShowingItemIndex)).getThumb(), new MovableView.IMovableAssetReadyListener(){

                            @Override
                            public void onAssetsReady() {
                                if (FlexiView.this.mFlexiViewListener != null) {
                                    FlexiView.this.mFlexiViewListener.onViewReady();
                                }
                                if (FlexiView.this.mIsAutoShowOnCreate) {
                                    FlexiView.this.showFlexiView();
                                }
                            }
                        });
                    }
                }
            }

            @Override
            public void onLoadContentFailed() {
            }
        });
    }

    private void startContentChangingCycle() {
        this.getMyHandlerInstance().removeCallbacksAndMessages(null);
        if (!this.mShowingListContentList.isEmpty() && this.mIsCyclingContent && this.getWindowVisibility() == 0 && this.mMovableView != null && this.mMovableView.getVisibility() == 0) {
            this.getMyHandlerInstance().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (FlexiView.this.mIsCyclingContent) {
                        ContentItem contentItem;
                        int nextItemIndex = FlexiView.this.mCurrentShowingItemIndex + 1;
                        if (FlexiView.this.mShowingListContentList.size() - 1 < nextItemIndex) {
                            nextItemIndex = 0;
                        }
                        if ((contentItem = (ContentItem)FlexiView.this.mShowingListContentList.get(nextItemIndex)) != null && FlexiView.this.mMovableView != null) {
                            final int finalNextItemIndex = nextItemIndex;
                            PicassoOk.getPicasso(FlexiView.this.getContext()).load(contentItem.getThumb()).transform(((FlexiView)FlexiView.this).mMovableView.mImageTransformation).fetch(new Callback(){

                                @Override
                                public void onSuccess() {
                                    if (FlexiView.this.getWindowVisibility() == 0) {
                                        FlexiView.this.mCurrentShowingItemIndex = finalNextItemIndex;
                                        FlexiView.this.mMovableView.loadMainAsset(((ContentItem)FlexiView.this.mShowingListContentList.get(FlexiView.this.mCurrentShowingItemIndex)).getThumb(), new MovableView.IMovableAssetReadyListener(){

                                            @Override
                                            public void onAssetsReady() {
                                                File soundFile;
                                                FlexiView.this.sendImpressionLog((ContentItem)FlexiView.this.mShowingListContentList.get(FlexiView.this.mCurrentShowingItemIndex));
                                                if (FlexiView.this.mIsSoundEnabled && (soundFile = AssetUtil.getAssetFile(FlexiView.this.getContext(), FlexiView.this.mProperties.optString("flexiContentSwapSound", null))) != null) {
                                                    SdkSoundManager.playSound(FlexiView.this.getContext(), soundFile.getPath());
                                                }
                                                FlexiView.this.startContentChangingCycle();
                                            }
                                        });
                                    }
                                }

                                @Override
                                public void onError() {
                                    if (FlexiView.this.getWindowVisibility() == 0) {
                                        FlexiView.this.startContentChangingCycle();
                                    }
                                }
                            });
                        }
                    }
                }
            }, this.mContentRefreshRate);
        }
    }

    public void setFlexiViewInitialPosition(FLEXI_POSITION position) {
        this.mFlexiPosition = position;
    }

    public void setAutoShow(boolean autoShow) {
        this.mIsAutoShowOnCreate = autoShow;
    }

    public void setDraggable(boolean isDraggable) {
        this.mUserSetDragable = isDraggable ? 1 : 0;
        if (this.mProperties != null && this.mProperties.optInt("flexiIsOverrideUserSet", 0) == 0) {
            this.mIsDraggable = isDraggable;
        }
    }

    public void setSoundEnabled(boolean enabled) {
        this.mUserSetSound = enabled ? 1 : 0;
        if (this.mProperties != null && this.mProperties.optInt("flexiIsOverrideUserSet", 0) == 0) {
            this.mIsSoundEnabled = enabled;
        }
    }

    public void setClosable(boolean isClosable) {
        this.mUserSetClosable = isClosable ? 1 : 0;
        if (this.mProperties != null && this.mProperties.optInt("flexiIsOverrideUserSet", 0) == 0 && this.mMovableView != null) {
            this.mMovableView.showCloseBtn(isClosable);
        }
    }

    public void showFlexiView() {
        if (this.mMovableView != null && !this.mShowingListContentList.isEmpty() && this.mMovableView.getVisibility() != 0) {
            this.showFlexiInner();
        }
    }

    private void showFlexiInner() {
        GenAnimator.playGrowAnimation((View)this.mMovableView, 700L, 0L, (Interpolator)new BounceInterpolator(), new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                FlexiView.this.calculateStartPositionCoordinates();
                FlexiView.this.mFlexiViewPosRect = new Rect(((FlexiView)FlexiView.this).mStartPointCoord.x, ((FlexiView)FlexiView.this).mStartPointCoord.y, ((FlexiView)FlexiView.this).mStartPointCoord.x + FlexiView.this.mMovableView.getWidth(), ((FlexiView)FlexiView.this).mStartPointCoord.y + FlexiView.this.mMovableView.getHeight());
                FlexiView.this.mMovableView.setTranslationX(((FlexiView)FlexiView.this).mStartPointCoord.x);
                FlexiView.this.mMovableView.setTranslationY(((FlexiView)FlexiView.this).mStartPointCoord.y);
                if (FlexiView.this.getWindowVisibility() == 0) {
                    FlexiView.this.mMovableView.setVisibility(0);
                    FlexiView.this.requestFocus();
                    FlexiView.this.bringToFront();
                    FlexiView.this.mMovableView.bringToFront();
                    File soundFile = AssetUtil.getAssetFile(FlexiView.this.getContext(), FlexiView.this.mProperties.optString("flexiPopSound", null));
                    if (soundFile != null) {
                        SdkSoundManager.playSound(FlexiView.this.getContext(), soundFile.getAbsolutePath());
                    }
                    FlexiView.this.setBackgroundColor(0);
                    EventManager.getInstance(FlexiView.this.getContext()).logEvent(FlexiView.this.getContext(), WidgetType.WIDGET_TYPE_FLEXI_VIEW.getStringValue(), FlexiView.this.mStyleId, EventManager.LOG_CRITICAL_LEVEL, "Sponsored Content", "Widget View", "Flexi View");
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (FlexiView.this.mMovableView.getVisibility() == 0) {
                    FlexiView.this.setViewVisibleAndActive();
                    if (FlexiView.this.mFlexiViewListener != null) {
                        FlexiView.this.mFlexiViewListener.onViewVisible();
                    }
                    FlexiView.this.sendImpressionLog((ContentItem)FlexiView.this.mShowingListContentList.get(FlexiView.this.mCurrentShowingItemIndex));
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public void hideFlexiView() {
        if (this.mMovableView != null && !this.mShowingListContentList.isEmpty() && this.mMovableView.getVisibility() == 0) {
            GenAnimator.playShrinkAnimation((View)this.mMovableView, 470L, (TimeInterpolator)new AnticipateInterpolator(), new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    FlexiView.this.mMovableView.setVisibility(4);
                    FlexiView.this.setViewNotVisibleOrNotActive();
                    if (FlexiView.this.mFlexiViewListener != null) {
                        FlexiView.this.mFlexiViewListener.onViewHidden();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    public boolean getIsFlexiViewVisible() {
        return this.mMovableView == null || this.mMovableView.getVisibility() == 0;
    }

    private void initGestureListener() {
        this.mGestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureListener(new GestureListener.IOnGestureEventsListener(){

            @Override
            public void onClick() {
                GenAnimator.playClickAnimation((View)FlexiView.this.mMovableView, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        FlexiView.this.handleClick((ContentItem)FlexiView.this.mShowingListContentList.get(FlexiView.this.mCurrentShowingItemIndex));
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }

            @Override
            public void onFling(float distX, float distY) {
                if (FlexiView.this.mIsDraggable) {
                    if (FlexiView.this.mAllowFling) {
                        FlexiView.this.animateFling(distX, distY);
                    } else {
                        FlexiView.this.invokeNoticeAnimationEvent(0);
                    }
                }
            }
        }));
    }

    private void handleClick(ContentItem contentItem) {
        if (contentItem != null && this.mAllowClickHandling && this.mAllowClickHandling) {
            this.mAllowClickHandling = false;
            ContentExecutionHandler.handleContentItemClick(this.getContext(), contentItem, WidgetType.WIDGET_TYPE_FLEXI_VIEW.getStringValue(), this.mStyleId, 0, true, new ContentExecutionHandler.IOnHandleClickListener(){

                @Override
                public void onRestoreClick() {
                    FlexiView.this.mAllowClickHandling = true;
                }
            });
        }
    }

    private void setViewVisibleAndActive() {
        if (this.getVisibility() == 0 && this.mMovableView != null && this.mMovableView.getVisibility() == 0) {
            this.mIsCyclingContent = true;
            this.mAllowViewInitiation = true;
            this.mAllowClickHandling = true;
            this.invokeNoticeAnimationEvent(0);
            this.startContentChangingCycle();
        }
    }

    private void setViewNotVisibleOrNotActive() {
        this.mAllowViewInitiation = false;
        this.mIsCyclingContent = false;
        this.mAllowClickHandling = false;
        if (this.mFlingAnimation != null) {
            this.mFlingAnimation.cancel();
        }
        this.invokeNoticeAnimationEvent(1);
        this.getMyHandlerInstance().removeCallbacksAndMessages(null);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0) {
            this.setViewVisibleAndActive();
        } else if (visibility == 8 || visibility == 4) {
            this.setViewNotVisibleOrNotActive();
            EventManager.getInstance(this.getContext()).startEventsSync(this.getContext());
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.setViewVisibleAndActive();
        } else {
            this.setViewNotVisibleOrNotActive();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mMoveEdgeAnimatorX != null) {
            this.mMoveEdgeAnimatorX.removeAllUpdateListeners();
        }
        if (this.mMoveEdgeAnimatorY != null) {
            this.mMoveEdgeAnimatorY.removeAllUpdateListeners();
        }
        if (this.mFlingAnimation != null) {
            this.mFlingAnimation.cancel();
        }
        this.setViewNotVisibleOrNotActive();
        this.getMyHandlerInstance().removeCallbacksAndMessages(null);
        if (this.mKidozPlayerEventHelper != null) {
            this.mKidozPlayerEventHelper.unRegister();
        }
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mKidozPlayerEventHelper != null) {
            this.mKidozPlayerEventHelper.register();
        }
        if (this.getLayoutParams() != null) {
            boolean relayout = false;
            if (this.getLayoutParams().height != -1) {
                this.getLayoutParams().height = -1;
                relayout = true;
            }
            if (this.getLayoutParams().width != -1) {
                this.getLayoutParams().width = -1;
                relayout = true;
            }
            if (relayout) {
                this.requestLayout();
                this.postInvalidate();
                this.bringToFront();
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.handleTouchEvent(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleTouchEvent(MotionEvent event) {
        int maskAction = MotionEventCompat.getActionMasked((MotionEvent)event);
        if (this.mMovableView == null) return this.mIsSelected;
        if (this.mIsDraggable) {
            this.mGestureDetector.onTouchEvent(event);
            if (maskAction == 0) {
                if (this.mMovableView.getVisibility() != 0) return false;
                this.invokeNoticeAnimationEvent(1);
                if (this.mFlingAnimation != null) {
                    this.mFlingAnimation.cancel();
                }
                if (event.getPointerCount() > 1) return this.mIsSelected;
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)event);
                this.mLastTouchX = MotionEventCompat.getX((MotionEvent)event, (int)pointerIndex);
                this.mLastTouchY = MotionEventCompat.getY((MotionEvent)event, (int)pointerIndex);
                this.mSingleFingerActivePointerId = event.getPointerId(pointerIndex);
                if (!this.mFlexiViewPosRect.contains((int)this.mLastTouchX, (int)this.mLastTouchY)) return this.mIsSelected;
                this.mIsSelected = true;
                this.mMovableView.playOrStopTheGifAnimationIfExists(false);
                return this.mIsSelected;
            } else if (maskAction == 2) {
                int pointerIndex;
                if (this.mMovableView.getVisibility() != 0) return false;
                if (!this.mIsDraggable || !this.mIsSelected || event.getPointerCount() > 1 || (pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)event, (int)this.mSingleFingerActivePointerId)) == -1) return this.mIsSelected;
                float x = MotionEventCompat.getX((MotionEvent)event, (int)pointerIndex);
                float y = MotionEventCompat.getY((MotionEvent)event, (int)pointerIndex);
                int dx = (int)(x - this.mLastTouchX);
                int dy = (int)(y - this.mLastTouchY);
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                this.mFlexiViewPosRect.top += dy;
                this.mFlexiViewPosRect.left += dx;
                this.mFlexiViewPosRect.bottom += dy;
                this.mFlexiViewPosRect.right += dx;
                this.mMovableView.setTranslationX(this.mFlexiViewPosRect.left);
                this.mMovableView.setTranslationY(this.mFlexiViewPosRect.top);
                this.mAllowFling = Math.max(Math.abs(dx), Math.abs(dy)) > 10;
                return this.mIsSelected;
            } else {
                if (maskAction != 1 && maskAction != 3) return this.mIsSelected;
                this.mSingleFingerActivePointerId = -1;
                this.mIsSelected = false;
                if (!this.mContainerViewRect.contains(this.mFlexiViewPosRect)) {
                    this.fixLeftRightEdgeAlignmentIfNeeded();
                    this.fixTopBottomEdgeAlignmentIfNeeded();
                }
                this.invokeNoticeAnimationEvent(0);
                if (this.mMovableView.getVisibility() != 0 || this.mAllowFling) return this.mIsSelected;
                this.mMovableView.playOrStopTheGifAnimationIfExists(true);
            }
            return this.mIsSelected;
        } else {
            if (this.mMovableView.getVisibility() != 0) return false;
            if (event.getPointerCount() > 1) return this.mIsSelected;
            int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)event);
            this.mLastTouchX = MotionEventCompat.getX((MotionEvent)event, (int)pointerIndex);
            this.mLastTouchY = MotionEventCompat.getY((MotionEvent)event, (int)pointerIndex);
            if (!this.mFlexiViewPosRect.contains((int)this.mLastTouchX, (int)this.mLastTouchY)) return this.mIsSelected;
            this.mGestureDetector.onTouchEvent(event);
            return true;
        }
    }

    private void fixLeftRightEdgeAlignmentIfNeeded() {
        int currentX = 0;
        int goalPositionX = 0;
        boolean animateX = false;
        if (this.mFlexiViewPosRect.left < 0) {
            animateX = true;
            currentX = this.mFlexiViewPosRect.left;
            goalPositionX = 0;
        } else if (this.mFlexiViewPosRect.right > this.mContainerViewRect.right) {
            animateX = true;
            currentX = this.mFlexiViewPosRect.left;
            goalPositionX = this.mContainerViewRect.right - this.mMovableView.getWidth();
        }
        if (animateX) {
            this.mMoveEdgeAnimatorX = ValueAnimator.ofInt((int[])new int[]{currentX, goalPositionX});
            this.mMoveEdgeAnimatorX.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int translate;
                    ((FlexiView)FlexiView.this).mFlexiViewPosRect.left = translate = ((Integer)animation.getAnimatedValue()).intValue();
                    ((FlexiView)FlexiView.this).mFlexiViewPosRect.right = FlexiView.this.mMovableView.getWidth() + translate;
                    FlexiView.this.mMovableView.setTranslationX(((FlexiView)FlexiView.this).mFlexiViewPosRect.left);
                }
            });
            this.mMoveEdgeAnimatorX.setInterpolator(this.mMoveEdgeInterpolator);
            this.mMoveEdgeAnimatorX.setDuration(400L);
            this.mMoveEdgeAnimatorX.start();
        }
    }

    private void fixTopBottomEdgeAlignmentIfNeeded() {
        int currentY = 0;
        int goalPositionY = 0;
        boolean animateY = false;
        if (this.mFlexiViewPosRect.top < 0) {
            animateY = true;
            currentY = this.mFlexiViewPosRect.top;
            goalPositionY = 0;
        } else if (this.mFlexiViewPosRect.bottom > this.mContainerViewRect.bottom) {
            animateY = true;
            currentY = this.mFlexiViewPosRect.top;
            goalPositionY = this.mContainerViewRect.bottom - this.mMovableView.getHeight();
        }
        if (animateY) {
            this.mMoveEdgeAnimatorY = ValueAnimator.ofInt((int[])new int[]{currentY, goalPositionY});
            this.mMoveEdgeAnimatorY.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int translate;
                    ((FlexiView)FlexiView.this).mFlexiViewPosRect.top = translate = ((Integer)animation.getAnimatedValue()).intValue();
                    ((FlexiView)FlexiView.this).mFlexiViewPosRect.bottom = FlexiView.this.mMovableView.getHeight() + translate;
                    FlexiView.this.mMovableView.setTranslationY(((FlexiView)FlexiView.this).mFlexiViewPosRect.top);
                }
            });
            this.mMoveEdgeAnimatorY.setDuration(400L);
            this.mMoveEdgeAnimatorY.setInterpolator(this.mMoveEdgeInterpolator);
            this.mMoveEdgeAnimatorY.start();
        }
    }

    private void animateFling(double distX, double distY) {
        if (this.mFlingAnimation != null) {
            this.mFlingAnimation.cancel();
        }
        if (this.mMovableView != null) {
            this.mFlingAnimation = new AnimatorSet();
            ValueAnimator xAnimator = ValueAnimator.ofInt((int[])new int[]{this.mFlexiViewPosRect.left, (int)((double)this.mFlexiViewPosRect.left + distX)});
            xAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int translate;
                    ((FlexiView)FlexiView.this).mFlexiViewPosRect.left = translate = ((Integer)animation.getAnimatedValue()).intValue();
                    ((FlexiView)FlexiView.this).mFlexiViewPosRect.right = FlexiView.this.mMovableView.getWidth() + translate;
                    FlexiView.this.mMovableView.setTranslationX(((FlexiView)FlexiView.this).mFlexiViewPosRect.left);
                }
            });
            xAnimator.setDuration(300L);
            xAnimator.setInterpolator(this.mFlingMoveLinearInterpolator);
            ValueAnimator yAnimator = ValueAnimator.ofInt((int[])new int[]{this.mFlexiViewPosRect.top, (int)((double)this.mFlexiViewPosRect.top + distY)});
            yAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int translate;
                    ((FlexiView)FlexiView.this).mFlexiViewPosRect.top = translate = ((Integer)animation.getAnimatedValue()).intValue();
                    ((FlexiView)FlexiView.this).mFlexiViewPosRect.bottom = FlexiView.this.mMovableView.getHeight() + translate;
                    FlexiView.this.mMovableView.setTranslationY(((FlexiView)FlexiView.this).mFlexiViewPosRect.top);
                }
            });
            yAnimator.setDuration(300L);
            yAnimator.setInterpolator(this.mFlingMoveLinearInterpolator);
            this.mFlingAnimation.playTogether(new Animator[]{xAnimator, yAnimator});
            this.mFlingAnimation.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (!FlexiView.this.mContainerViewRect.contains(FlexiView.this.mFlexiViewPosRect)) {
                        FlexiView.this.fixLeftRightEdgeAlignmentIfNeeded();
                        FlexiView.this.fixTopBottomEdgeAlignmentIfNeeded();
                    }
                    FlexiView.this.mMovableView.playOrStopTheGifAnimationIfExists(true);
                }

                public void onAnimationCancel(Animator animation) {
                    if (!FlexiView.this.mContainerViewRect.contains(FlexiView.this.mFlexiViewPosRect)) {
                        FlexiView.this.fixLeftRightEdgeAlignmentIfNeeded();
                        FlexiView.this.fixTopBottomEdgeAlignmentIfNeeded();
                    }
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mFlingAnimation.start();
        }
    }

    private void initNoticeAnimation(JSONObject mProperties) {
        this.mNoticeAnimType = NoticeAnimType.values()[mProperties.optInt("flexiNoticeMeAnimType", 0)];
        if (this.mAnimationHandler == null) {
            this.mAnimationHandler = new Utils.StaticHandler(Looper.getMainLooper()){

                @Override
                public void handleMessage(Message message) {
                    if (message != null) {
                        switch (message.arg1) {
                            case 0: {
                                if (!FlexiView.this.mIsAnimateNotice || FlexiView.this.getWindowVisibility() != 0) break;
                                this.postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (FlexiView.this.mIsAnimateNotice && (FlexiView.this.mNoticeAnimationSet == null || !FlexiView.this.mNoticeAnimationSet.isStarted())) {
                                            FlexiView.this.createAnimationInstance();
                                            FlexiView.this.mNoticeAnimationSet.start();
                                        }
                                    }
                                }, FlexiView.this.mNoticeAnimCycleRate);
                                break;
                            }
                            case 1: {
                                FlexiView.this.mIsAnimateNotice = false;
                                if (FlexiView.this.mNoticeAnimationSet == null) break;
                                FlexiView.this.mNoticeAnimationSet.end();
                            }
                        }
                    }
                }
            };
        }
    }

    private void createAnimationInstance() {
        boolean isResetVals = true;
        switch (this.mNoticeAnimType) {
            case PULSE: {
                if (this.mNoticeAnimationSet == null) {
                    this.mNoticeAnimationSet = GenAnimator.flexiPulseAnimation((View)this.mMovableView, 1000, (TimeInterpolator)new FastOutSlowInInterpolator());
                    break;
                }
                isResetVals = false;
                break;
            }
            case SWING: {
                if (this.mNoticeAnimationSet == null) {
                    this.mNoticeAnimationSet = GenAnimator.flexiSwingAnimation((View)this.mMovableView, 800, null);
                    break;
                }
                isResetVals = false;
                break;
            }
            case BOUNCE: {
                if (this.mNoticeAnimationSet != null) {
                    this.mNoticeAnimationSet.cancel();
                }
                this.mNoticeAnimationSet = null;
                this.mNoticeAnimationSet = GenAnimator.flexiBounceAnimation((View)this.mMovableView, 800, null);
                break;
            }
            case FLASH: {
                if (this.mNoticeAnimationSet == null) {
                    this.mNoticeAnimationSet = GenAnimator.flexiFlashAnimation((View)this.mMovableView, 800, null);
                    break;
                }
                isResetVals = false;
                break;
            }
            case TADA: {
                if (this.mNoticeAnimationSet != null) {
                    this.mNoticeAnimationSet.cancel();
                }
                this.mNoticeAnimationSet = null;
                this.mNoticeAnimationSet = GenAnimator.flexiTadaAnimation((View)this.mMovableView, 900, null);
            }
        }
        if (isResetVals) {
            this.mNoticeAnimationSet.setStartDelay(this.mNoticeAnimCycleRate);
            this.mNoticeAnimationSet.removeAllListeners();
            this.mNoticeAnimationSet.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (FlexiView.this.mIsAnimateNotice) {
                        FlexiView.this.invokeNoticeAnimationEvent(0);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    FlexiView.this.mAnimationHandler.removeCallbacksAndMessages(null);
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    private void invokeNoticeAnimationEvent(int action) {
        if (this.mAnimationHandler != null) {
            if (action == 0) {
                this.mIsAnimateNotice = true;
            } else if (action == 1) {
                this.mIsAnimateNotice = false;
            }
            Message message = Message.obtain();
            message.arg1 = action;
            this.mAnimationHandler.sendMessage(message);
        }
    }

    private void sendImpressionLog(ContentItem contentItem) {
        if (contentItem != null && contentItem.isPromoted() && !contentItem.getIsAvoidAutoImpression()) {
            EventManager.getInstance(this.getContext()).logSponsoredContentImpressionEvent(this.getContext(), WidgetType.WIDGET_TYPE_FLEXI_VIEW.getStringValue(), this.mStyleId, "Impression", contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), contentItem.getRealViewIndex());
        }
    }

    private Utils.StaticHandler getMyHandlerInstance() {
        if (this.mStaticHandler == null) {
            this.mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()){

                @Override
                public void handleMessage(Message message) {
                }
            };
        }
        return this.mStaticHandler;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mContainerViewRect = new Rect(0, 0, w, h);
        if (this.mMovableView != null) {
            this.getMyHandlerInstance().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (FlexiView.this.mMovableView != null) {
                        FlexiView.this.fixLeftRightEdgeAlignmentIfNeeded();
                        FlexiView.this.fixTopBottomEdgeAlignmentIfNeeded();
                    }
                }
            }, 300L);
        }
    }

    private void calculateStartPositionCoordinates() {
        if (this.mMovableView != null && this.mContainerViewRect != null) {
            switch (this.mFlexiPosition) {
                case TOP_START: {
                    this.mStartPointCoord = new Point(0, 0);
                    break;
                }
                case TOP_CENTER: {
                    this.mStartPointCoord = new Point(this.mContainerViewRect.width() / 2 - this.mMovableView.getWidth() / 2, 0);
                    break;
                }
                case TOP_END: {
                    this.mStartPointCoord = new Point(this.mContainerViewRect.width() - this.mMovableView.getWidth(), 0);
                    break;
                }
                case MIDDLE_START: {
                    this.mStartPointCoord = new Point(0, this.mContainerViewRect.height() / 2 - this.mMovableView.getWidth() / 2);
                    break;
                }
                case MIDDLE_CENTER: {
                    this.mStartPointCoord = new Point(this.mContainerViewRect.width() / 2 - this.mMovableView.getWidth() / 2, this.mContainerViewRect.height() / 2 - this.mMovableView.getWidth() / 2);
                    break;
                }
                case MIDDLE_END: {
                    this.mStartPointCoord = new Point(this.mContainerViewRect.width() - this.mMovableView.getWidth(), this.mContainerViewRect.height() / 2 - this.mMovableView.getWidth() / 2);
                    break;
                }
                case BOTTOM_START: {
                    this.mStartPointCoord = new Point(0, this.mContainerViewRect.height() - this.mMovableView.getWidth());
                    break;
                }
                case BOTTOM_CENTER: {
                    this.mStartPointCoord = new Point(this.mContainerViewRect.width() / 2 - this.mMovableView.getWidth() / 2, this.mContainerViewRect.height() - this.mMovableView.getWidth());
                    break;
                }
                case BOTTOM_END: {
                    this.mStartPointCoord = new Point(this.mContainerViewRect.width() - this.mMovableView.getWidth(), this.mContainerViewRect.height() - this.mMovableView.getWidth());
                }
            }
        }
    }

    public void setOnFlexiViewEventListener(FlexiViewListener eventListener) {
        this.mFlexiViewListener = eventListener;
    }

    private static final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private static final int SWIPE_THRESHOLD = 100;
        private static final int SWIPE_VELOCITY_THRESHOLD = 130;
        IOnGestureEventsListener mEventListener;

        public GestureListener(IOnGestureEventsListener eventListener) {
            this.mEventListener = eventListener;
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            this.mEventListener.onClick();
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (Math.max(Math.abs(velocityX), Math.abs(velocityY)) > 130.0f) {
                float distX = e2.getX() - e1.getX();
                float distY = e2.getY() - e1.getY();
                if (Math.max(Math.abs(distX), Math.abs(distY)) > 100.0f) {
                    this.mEventListener.onFling(distX, distY);
                }
            }
            return false;
        }

        public static interface IOnGestureEventsListener {
            public void onClick();

            public void onFling(float var1, float var2);
        }
    }

    private static enum NoticeAnimType {
        PULSE(0),
        SWING(1),
        BOUNCE(2),
        FLASH(3),
        TADA(4);

        private int id;

        private NoticeAnimType(int id) {
            this.id = id;
        }
    }
}

