package com.kidoz.sdk.api.ui_views.web_unit_view;

import android.content.Context;
import android.content.res.Configuration;
import android.view.View;

import com.kidoz.sdk.api.general.utils.SDKLogger;

/**
 * Created by RonyBrosh on 6/7/2016.
 */
public class ConfigurationView extends View
{
    private final String TAG = ConfigurationView.class.getSimpleName();

    private ConfigurationViewInterface mConfigurationViewInterface;

    public ConfigurationView(Context context, ConfigurationViewInterface configurationViewInterface)
    {
        super(context);
        mConfigurationViewInterface = configurationViewInterface;
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        SDKLogger.printDebbugLog(TAG, "*** onConfigurationChanged ***");

        if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE)
        {
            SDKLogger.printDebbugLog(TAG, "New configuration: LANDSCAPE");
        }
        else
        {
            SDKLogger.printDebbugLog(TAG, "New configuration: PORTRAIT");
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus)
    {
        super.onWindowFocusChanged(hasWindowFocus);
        SDKLogger.printDebbugLog(TAG, "*** onWindowFocusChanged ***");
        SDKLogger.printDebbugLog(TAG, "Has window focus = " + Boolean.toString(hasWindowFocus));
        if (mConfigurationViewInterface != null)
        {
            mConfigurationViewInterface.onViewVisibilityChanged(hasWindowFocus);
        }
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility)
    {
        super.onVisibilityChanged(changedView, visibility);
        SDKLogger.printDebbugLog(TAG, "*** onVisibilityChanged ***");
        SDKLogger.printDebbugLog(TAG, "Visibility = " + String.valueOf(visibility));
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility)
    {
        super.onWindowVisibilityChanged(visibility);
        SDKLogger.printDebbugLog(TAG, "*** onWindowVisibilityChanged ***");
        SDKLogger.printDebbugLog(TAG, "Visibility = " + String.valueOf(visibility));
    }

    public interface ConfigurationViewInterface
    {
        void onViewVisibilityChanged(boolean isVisible);
    }
}
