package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.PanelView;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;

import org.json.JSONObject;

import java.util.ArrayList;

public class StandardPanelView extends AbstractPanelView
{

    public static final String TAG = StandardPanelView.class.getSimpleName();

    private PanelSliderView mPanelSliderView;

    public StandardPanelView(Context context, JSONObject jsonObject)
    {
        super(context, jsonObject);
    }

    @Override
    protected void initInnerPanelView()
    {
        mPanelSliderView = new PanelSliderView(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId);
        mPanelSliderView.setId(Utils.generateViewId());
        mPanelSliderView.setBackgroundColor(mPanelBgColor);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mInnerContainer.addView(mPanelSliderView, params);

        PanelViewListener mPanelViewListener = new PanelViewListener()
        {
            @Override
            public void onItemClick(ContentItem contentItem, int position)
            {
                if (mAllowClickHandling)
                {
                    mAllowClickHandling = false;
                    ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId, position, true, new ContentExecutionHandler.IOnHandleClickListener()
                    {
                        @Override
                        public void onRestoreClick()
                        {
                            mAllowClickHandling = true;
                        }
                    });
                }
            }
        };
        mPanelSliderView.setPanelViewListener(mPanelViewListener);
    }

    @Override
    protected void setContentAndRefresh(ArrayList<ContentItem> content)
    {
        if (content != null && content.isEmpty() == false)
        {
            mPanelSliderView.setContentData(content);
        }
    }

    @Override
    protected void onContentDataLoadStarted()
    {
        mPanelSliderView.showLoadingProgressView(true);
    }

    @Override
    protected void onContentDataLoadEnded()
    {
        mPanelSliderView.showLoadingProgressView(false);
    }

    @Override
    protected void onContentDataLoadFailed()
    {
        mPanelSliderView.showLoadingProgressView(false);
    }

    @Override
    protected void onCollapsePanelAnimationEnded()
    {
        super.onCollapsePanelAnimationEnded();

        mShadowLine.setVisibility(View.INVISIBLE);
        mPanelSliderView.clearContent();
    }

    @Override
    protected void onExpandPanelAnimationStarted()
    {
        super.onExpandPanelAnimationStarted();

        mShadowLine.setVisibility(View.VISIBLE);
    }

    @Override
    protected void clearPanelContent()
    {
        mPanelSliderView.clearContent();
    }

    @Override
    protected void setShowable(boolean showable)
    {
        // TODO add nessasery code
    }

    @Override
    protected void invokeViewAction(int itemIndex)
    {
        // TODO add nessasery code
    }


    protected void createShadowLineBg()
    {
        int[] colors = new int[2];
        colors[0] = Color.parseColor("#dd000000");
        colors[1] = Color.TRANSPARENT;

        GradientDrawable shadow = null;

        switch (mPanelType)
        {
            case BOTTOM:
            {
                shadow = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, colors);
                break;
            }
            case TOP:
            {
                shadow = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, colors);
                break;
            }
            case LEFT:
            {
                shadow = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, colors);
                break;
            }
            case RIGHT:
            {
                shadow = new GradientDrawable(GradientDrawable.Orientation.RIGHT_LEFT, colors);
                break;
            }
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
        {
            mShadowLine.setBackground(shadow);
        } else
        {
            mShadowLine.setBackgroundDrawable(shadow);
        }
    }

    @Override
    protected void initShadowView()
    {

        mShadowLine = new LinearLayout(getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE));
        mContainer.addView(mShadowLine, params);
        mShadowLine.setAlpha(0.20f);
        mShadowLine.setVisibility(View.INVISIBLE);
    }

    @Override
    public void setPanelColor(int color)
    {
        super.setPanelColor(color);

        if (mPanelSliderView != null)
        {
            mPanelSliderView.setBackgroundColor(mPanelBgColor);
        }
    }

    @Override
    protected void initPanelViewsRules()
    {
        createShadowLineBg();

        RelativeLayout.LayoutParams containerParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        setLayoutParams(containerParams);

        RelativeLayout.LayoutParams innerContainerParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mInnerContainer.setLayoutParams(innerContainerParams);

        RelativeLayout.LayoutParams sliderParams = (LayoutParams) mPanelSliderView.getLayoutParams();
        mPanelSliderView.setLayoutParams(sliderParams);

        RelativeLayout.LayoutParams bottomBarParams = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mBottomBarContainer.setLayoutParams(bottomBarParams);

        RelativeLayout.LayoutParams handleParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mPanelHandle.setLayoutParams(handleParams);

        RelativeLayout.LayoutParams shadowParams = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE));
        mShadowLine.setLayoutParams(shadowParams);

        int margin = Utils.dpTOpx(getContext(), 6);
        switch (mPanelType)
        {
            case LEFT:
            {
                mPanelSliderView.setPanelType(PANEL_TYPE.LEFT);
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                innerContainerParams.width = LayoutParams.WRAP_CONTENT;
                innerContainerParams.height = LayoutParams.MATCH_PARENT;

                handleParams.addRule(RelativeLayout.RIGHT_OF, mInnerContainer.getId());
                bottomBarParams.width = LayoutParams.WRAP_CONTENT;

                bottomBarParams.addRule(RelativeLayout.ALIGN_RIGHT, mPanelSliderView.getId());
                bottomBarParams.addRule(RelativeLayout.ALIGN_LEFT, mPanelSliderView.getId());
                bottomBarParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);

                sliderParams.addRule(RelativeLayout.ABOVE, mBottomBarContainer.getId());

                shadowParams.addRule(RelativeLayout.RIGHT_OF, mInnerContainer.getId());
                shadowParams.width = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);
                shadowParams.height = LayoutParams.MATCH_PARENT;

                mPoweredByTextView.setVisibility(View.INVISIBLE);

                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                        handleParams.topMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_VERTICAL);
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_BOTTOM, mInnerContainer.getId());
                        handleParams.bottomMargin = margin;
                        break;
                    }
                }
                containerParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                break;
            }
            case TOP:
            {
                mPanelSliderView.setPanelType(PANEL_TYPE.TOP);
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                innerContainerParams.width = LayoutParams.MATCH_PARENT;
                innerContainerParams.height = LayoutParams.WRAP_CONTENT;

                bottomBarParams.addRule(RelativeLayout.BELOW, mPanelSliderView.getId());
                handleParams.addRule(RelativeLayout.BELOW, mInnerContainer.getId());

                shadowParams.addRule(RelativeLayout.BELOW, mInnerContainer.getId());
                shadowParams.width = LayoutParams.MATCH_PARENT;
                shadowParams.height = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);

                mPoweredByTextView.setVisibility(View.VISIBLE);

                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                        handleParams.leftMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                        handleParams.rightMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                break;
            }
            case RIGHT:
            {
                mPanelSliderView.setPanelType(PANEL_TYPE.RIGHT);
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                innerContainerParams.width = LayoutParams.WRAP_CONTENT;
                innerContainerParams.height = LayoutParams.MATCH_PARENT;

                handleParams.addRule(RelativeLayout.LEFT_OF, mInnerContainer.getId());
                bottomBarParams.width = LayoutParams.WRAP_CONTENT;

                bottomBarParams.addRule(RelativeLayout.ALIGN_RIGHT, mPanelSliderView.getId());
                bottomBarParams.addRule(RelativeLayout.ALIGN_LEFT, mPanelSliderView.getId());
                bottomBarParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);

                sliderParams.addRule(RelativeLayout.ABOVE, mBottomBarContainer.getId());

                shadowParams.addRule(RelativeLayout.LEFT_OF, mInnerContainer.getId());
                shadowParams.width = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);
                shadowParams.height = LayoutParams.MATCH_PARENT;

                mPoweredByTextView.setVisibility(View.INVISIBLE);

                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                        handleParams.topMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_VERTICAL);
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_BOTTOM, mInnerContainer.getId());
                        handleParams.bottomMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                break;
            }
            case BOTTOM:
            {
                mPanelSliderView.setPanelType(PANEL_TYPE.BOTTOM);
                innerContainerParams.addRule(RelativeLayout.BELOW, mPanelHandle.getId());
                innerContainerParams.width = LayoutParams.MATCH_PARENT;
                innerContainerParams.height = LayoutParams.WRAP_CONTENT;

                shadowParams.addRule(RelativeLayout.ABOVE, mInnerContainer.getId());
                shadowParams.width = LayoutParams.MATCH_PARENT;
                shadowParams.height = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);

                bottomBarParams.addRule(RelativeLayout.BELOW, mPanelSliderView.getId());
                mPoweredByTextView.setVisibility(View.VISIBLE);

                switch (mHandlePosition)
                {
                    case START:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                        handleParams.leftMargin = margin;
                        break;
                    }
                    case CENTER:
                    {
                        handleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                        break;
                    }
                    case END:
                    {
                        handleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                        handleParams.rightMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                break;
            }
        }
    }

    /**
     * Compare new JSON to old JSON, save the updated JSON to database, delete old assets if needed and download new assets.
     *
     * @param context
     * @param jsonObject
     */
    public static boolean parsePanelData(Context context, JSONObject jsonObject)
    {
        boolean result = false;
        if (jsonObject != null)
        {
            try
            {
                jsonObject.put(PanelView.TAG, StandardPanelView.TAG);
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(PanelView.TAG);

                AssetUtil.loadAsset(context, oldData, jsonObject, BTN_OPEN_URL);
                AssetUtil.loadAsset(context, oldData, jsonObject, BTN_CLOSE_URL);
                AssetUtil.loadAsset(context, oldData, jsonObject, CIH_BTN_OPEN_HANDLE_OVERLAY_URL);

                result = AssetUtil.loadAsset(context, oldData, jsonObject, BTN_LOCK_OPEN);
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, BTN_LOCK_CLOSED);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, KIDOZ_LOGO_ICON);
                }

                if (result == true)
                {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(PanelView.TAG, jsonObject);
                }
            } catch (Exception ex)
            {
                result = false;
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(PanelView.TAG, "Error when trying to parse kidoz PanelView properties" + ex.getMessage());
            }
        }
        return result;
    }
}
