package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Looper;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.CookieManager;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.picasso_related.RoundedTransformation;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.custom_drawables.ShadowView;
import com.kidoz.sdk.api.ui_views.flexi_view.MovableView;
import com.kidoz.sdk.api.ui_views.interstitial.LocalIntrst;
import com.kidoz.sdk.api.ui_views.one_item_view.OneItemFamilyView;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

import org.json.JSONObject;

import java.util.ArrayList;

public abstract class AbstractPanelView extends RelativeLayout
{
    private static final String PANEL_SHARED_PREFERENCES = "panel_shared_pref";
    private static final String FIRST_TIME_LAST_LOUNCH_KEY = "fistTimeLastLounch";

    protected static final int DEFAULT_SHADOW_LINE_SIZE = 3;
    private static final int TIME_MULT_FACTOR = 1000 * 60 * 60;

    protected PANEL_TYPE mPanelType = PANEL_TYPE.BOTTOM;
    protected HANDLE_POSITION mHandlePosition = HANDLE_POSITION.START;

    protected RelativeLayout mContainer;
    protected RelativeLayout mInnerContainer;
    protected ContentLogicLoader mContentLogicLoader;
    protected ArrayList<ContentItem> mContentItems = new ArrayList<ContentItem>();

    protected AssetView mParentalLockButton;
    protected AssetView mAboutKidozButton;

    protected PanelHandle mPanelHandle;
    protected TextView mPoweredByTextView;
    protected RelativeLayout mBottomBarContainer;
    protected OneItemFamilyView mOneItemFamilyView;
    protected IOnPanelViewEventListener mIOnPanelViewEventListener;

    protected boolean mIsOpen;
    protected boolean mIsAnimationRunning;
    protected boolean mIsClicksBlocked;
    protected boolean mAllowClickHandling = true;
    protected boolean mIsPanelPrepared = false;
    protected boolean mIsAllowThumbChange = false;

    protected ShadowView mShadowView;
    protected LinearLayout mShadowLine;

    protected JSONObject mWidgetProperties;

    protected int mAnimType = 1;
    protected String mBtnCloseUrl = null;
    protected String mBtnOpenUrl = null;
    protected float mBtnScaleSize = 0.15f;
    protected int mPanelBgColor = Color.WHITE;
    protected String mLabelText = "";
    protected int mLabelColor = Color.BLACK;
    // Time in second of showing (Expanding the panel on first launch per session
    protected float mFirstLounchOpenPeriod = -1;
    protected float mFirstLounchOpenRepeatTimeFarme = -1;
    protected float mFirstLounchStartDelay = -1;

    protected Utils.StaticHandler mStaticHandler;
    protected Utils.StaticHandler mHandleThumbStaticHandler;
    protected SharedPreferences mSharedPreferences;
    protected LocalIntrst mInterstitial;

    // Content handle item properties
    protected boolean mIsShowFirstItemThumb = false;
    protected float mFirstItemThumbSize = 0.5f;
    protected int mHandleThumbCurrentShownIndex = 0;
    protected int mHandleThumbRefreshRateSec = 12;
    protected int mHandleContentThumbRoundVal = 0;

    // The style id of the widget
    protected String mStyleId = null;

    public AbstractPanelView(Context context, JSONObject jsonObject)
    {
        super(context);
        mHandleThumbStaticHandler = new Utils.StaticHandler(Looper.getMainLooper());
        mWidgetProperties = jsonObject;
        prepareProperties();

        initView();
    }

    protected void prepareProperties()
    {
        mStyleId = mWidgetProperties.optString(STYLE_ID, null);

        mAnimType = mWidgetProperties.optInt(BTN_ANIMATION_TYPE, 1);
        mBtnCloseUrl = mWidgetProperties.optString(BTN_CLOSE_URL, null); // Image that shown in OPENED state
        mBtnOpenUrl = mWidgetProperties.optString(BTN_OPEN_URL, null); // Image that shown in CLOSED state
        mBtnScaleSize = (float) mWidgetProperties.optDouble(BTN_SCALE_SIZE, 0.15f);
        mLabelText = mWidgetProperties.optString(LABEL_TEXT, "");

        mFirstLounchOpenPeriod = (float) mWidgetProperties.optDouble(FIRST_LAUNCH_STAY_OPEN_PERIOD_SECONDS, -1);
        mFirstLounchStartDelay = (float) mWidgetProperties.optDouble(FIRST_LAUNCH_OPEN_START_DELAY_SECONDS, -1);
        mFirstLounchOpenRepeatTimeFarme = (float) mWidgetProperties.optDouble(FIRST_LAUNCH_OPEN_PANEL_EVEY_X_HOURS, -1);

        mIsShowFirstItemThumb = mWidgetProperties.optInt(CIH_SHOW_THUMB_IN_HANDLE, 0) == 1 ? true : false;
        if (mIsShowFirstItemThumb == true)
        {
            String alternativeOpenBtn = mWidgetProperties.optString(CIH_BTN_OPEN_HANDLE_OVERLAY_URL, null);
            if (alternativeOpenBtn != null && !alternativeOpenBtn.equals(""))
            {
                mBtnOpenUrl = alternativeOpenBtn;
            }
        }

        mFirstItemThumbSize = (float) mWidgetProperties.optDouble(CIH_THUMB_SIZE, 0.5);
        mHandleThumbRefreshRateSec = mWidgetProperties.optInt(CIH_REFRESH_CYCLE_PERIOD_SECONDS, 12);
        mHandleContentThumbRoundVal = mWidgetProperties.optInt(CIH_ROUND_CORNERS, 0);

        try
        {
            mPanelBgColor = Color.parseColor(mWidgetProperties.optString(PANEL_BG_COLOR, "#FFFFFF"));
        } catch (Exception e)
        {
            mPanelBgColor = Color.WHITE;
        }

        try
        {
            mLabelColor = Color.parseColor(mWidgetProperties.optString(LABEL_TEXT_COLOR, "#000000"));
        } catch (Exception e)
        {
            mLabelColor = Color.BLACK;
        }

        mSharedPreferences = getContext().getSharedPreferences(PANEL_SHARED_PREFERENCES, Context.MODE_PRIVATE);

        // Init interstitial if needed
        if (mWidgetProperties.optInt(MovableView.LOUNCH_INTERSTITIAL_ON_OPEN, 0) == 1)
        {
            if (mInterstitial == null)
            {
                mInterstitial = new LocalIntrst(getContext());
            }
        }
    }

    protected void initView()
    {
        initPanelContainer();
        initHandleButton();
        initInnerPanelView();
        initBottomBar();
        initPanelViewsRules();
        initContentLogicLoader();
        preparePanel();
    }

    protected abstract void initInnerPanelView();

    protected abstract void initPanelViewsRules();

    protected abstract void initShadowView();

    protected abstract void setContentAndRefresh(ArrayList<ContentItem> content);

    protected abstract void onContentDataLoadStarted();

    protected abstract void onContentDataLoadEnded();

    protected abstract void onContentDataLoadFailed();

    protected abstract void clearPanelContent();

    protected abstract void setShowable(boolean showable);

    protected abstract void invokeViewAction(int itemIndex);

    private void initPanelContainer()
    {
        mContainer = new RelativeLayout(getContext());
        mContainer.setBackgroundColor(Color.TRANSPARENT);
        mContainer.setId(Utils.generateViewId());
        setLayoutParams(new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));

        initShadowView();

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        addView(mContainer, params);

        mInnerContainer = new RelativeLayout(getContext());
        mInnerContainer.setId(Utils.generateViewId());
        mInnerContainer.setBackgroundColor(Color.WHITE);

        params = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mInnerContainer, params);
    }

    private void initHandleButton()
    {

        Point point = Utils.getScreenSize(getContext());
        int size = (int) (Math.min(point.x, point.y) * mBtnScaleSize);

        mPanelHandle = new PanelHandle(getContext(), mPanelType, mAnimType, size, mFirstItemThumbSize, new PanelHandle.IOnPanelHandleClickListener()
        {
            @Override
            public void onHandleClick()
            {
                toggleAnimation();

                if (mIsOpen == false)
                {
                    if (mWidgetProperties != null && mWidgetProperties.optInt(LAUNCH_INTERSTITIAL_ON_OPEN, 0) == 1)
                    {
                        if (mInterstitial != null)
                        {
                            mInterstitial.loadAd();
                        }
                    }
                }
            }
        });

        if (mHandleContentThumbRoundVal > 0)
        {
            mPanelHandle.getThumbLayerAsset().addTransformation(new RoundedTransformation(mHandleContentThumbRoundVal, 0));
        }

        if (mBtnScaleSize == 0)
        {
            mPanelHandle.setVisibility(View.GONE);
        }

        // Default handle button
        mPanelHandle.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mPanelHandle, params);
    }

    protected void initBottomBar()
    {
        mBottomBarContainer = new RelativeLayout(getContext());
        //mBottomBarContainer.setBackgroundColor(mPanelBgColor);
        mBottomBarContainer.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);

        int margin = Utils.dpTOpx(getContext(), 3);
        params.setMargins(margin, 0, margin, margin);
        mInnerContainer.addView(mBottomBarContainer, params);

        initParentalLockButton();
        initAboutKidozButton();

        int size = (int) (70 * ScreenUtils.getScaleFactor(getContext()));

        LayoutParams parentalLockParams = (LayoutParams) mParentalLockButton.getLayoutParams();
        parentalLockParams.width = size;
        parentalLockParams.height = size;

        LayoutParams aboutKidozParams = (LayoutParams) mAboutKidozButton.getLayoutParams();
        aboutKidozParams.width = size;
        aboutKidozParams.height = size;

        mPoweredByTextView = new TextView(getContext());
        mPoweredByTextView.setText(mLabelText);
        mPoweredByTextView.setTextColor(mLabelColor);
        mPoweredByTextView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12);
        mPoweredByTextView.setLines(1);
        mPoweredByTextView.setEllipsize(TextUtils.TruncateAt.END);
        mPoweredByTextView.setGravity(Gravity.LEFT | Gravity.BOTTOM);
        mPoweredByTextView.setShadowLayer(3, 2, 2, Color.parseColor("#44000000"));

        params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_BOTTOM, mAboutKidozButton.getId());
        params.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());
        params.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
        params.setMargins(Utils.dpTOpx(getContext(), 4), 0, Utils.dpTOpx(getContext(), 4), 0);
        mBottomBarContainer.addView(mPoweredByTextView, params);
    }

    private void initParentalLockButton()
    {
        mParentalLockButton = new AssetView(getContext());
        mParentalLockButton.setId(Utils.generateViewId());
        mParentalLockButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mParentalLockButton.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                if (mIsClicksBlocked == false)
                {
                    GenAnimator.clickItemAnimation(v, 80, new GenAnimator.ViewAnimationListener()
                    {
                        @Override
                        public void onAnimationEnd()
                        {
                            mIsClicksBlocked = true;
                            if (ParentalLockDialog.getIsCanShowDialog(getContext()) == true)
                            {
                                int[] popLocation = new int[2];
                                popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                                popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                                ParentalLockDialog parentalLockDialog = new ParentalLockDialog(getContext(), false, popLocation);
                                parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener()
                                {
                                    @Override
                                    public void onDismiss(DialogInterface dialog)
                                    {
                                        //Refresh the parental lock icon
                                        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                                        setParentalLocIConkState(isLockActive);
                                        mIsClicksBlocked = false;
                                    }
                                });
                                parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener()
                                {
                                    @Override
                                    public void onPasswordEntered(boolean isPasswordCorrect)
                                    {
                                        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                                        setParentalLocIConkState(isLockActive);
                                    }
                                });
                                parentalLockDialog.show();
                            } else
                            {
                                mIsClicksBlocked = false;
                            }
                        }

                        @Override
                        public void onAnimationStart()
                        {
                        }
                    });
                }
            }
        });

        mParentalLockButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        params.addRule(RelativeLayout.CENTER_VERTICAL);
        mBottomBarContainer.addView(mParentalLockButton, params);

        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
        setParentalLocIConkState(isLockActive);
    }

    private void initAboutKidozButton()
    {
        mAboutKidozButton = new AssetView(getContext());
        mAboutKidozButton.setId(Utils.generateViewId());
        mAboutKidozButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mAboutKidozButton.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                GenAnimator.clickItemAnimation(v, 80, new GenAnimator.ViewAnimationListener()
                {
                    @Override
                    public void onAnimationEnd()
                    {
                        int[] popLocation = new int[2];
                        popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                        popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                        AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(getContext(), popLocation);
                        aboutKidozDialog.openDialog();
                    }

                    @Override
                    public void onAnimationStart()
                    {
                    }
                });
            }
        });

        mAboutKidozButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.CENTER_VERTICAL);
        params.setMargins(Utils.dpTOpx(getContext(), 1), 0, 0, 0);
        mBottomBarContainer.addView(mAboutKidozButton, params);

        mAboutKidozButton.loadAsset(AssetUtil.getAssetFile(getContext(), mWidgetProperties.optString(KIDOZ_LOGO_ICON)), null);
    }

    protected void initContentLogicLoader()
    {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback()
        {
            @Override
            public void onDataReady(ContentData contentData)
            {
                onContentDataLoadEnded();
                if (contentData != null && contentData.isHasContentToShow())
                {
                    // Reset The storage of the impressions for the HTML content
                    CookieManager.resetStorage(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), StorageLife.WIDGET);

                    mContentItems.clear();
                    clearPanelContent();

                    mContentItems.addAll(contentData.getContentDataItems());
                    setContentAndRefresh(mContentItems);

                    final String url = mContentItems.get(mHandleThumbCurrentShownIndex).getThumb();

                    if (mIsPanelPrepared == false)
                    {
                        if (mIsShowFirstItemThumb)
                        {
                            mPanelHandle.getThumbLayerAsset().prefetchAsset(url, new AssetView.IOnAssetLoadedListener()
                            {
                                @Override
                                public void onAssetLoaded(boolean successful)
                                {
                                    prepareHandle(url);
                                }
                            });
                        } else
                        {
                            prepareHandle(null);
                        }
                    } else
                    {
                        if (mIsShowFirstItemThumb)
                        {
                            mPanelHandle.getThumbLayerAsset().loadAsset(url, null);
                        }
                    }

                    startThumbChangeCycle();
                }
            }

            @Override
            public void onLoadContentFailed()
            {
                onContentDataLoadFailed();
            }
        });
    }

    private void setParentalLocIConkState(boolean isLockActive)
    {
        if (isLockActive)
        {
            mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mWidgetProperties.optString(BTN_LOCK_CLOSED)), null);
        } else
        {
            mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mWidgetProperties.optString(BTN_LOCK_OPEN)), null);
        }
    }

    /**
     * Set panel color
     *
     * @param color
     */
    public void setPanelColor(int color)
    {
        mPanelBgColor = color;

        if (mInnerContainer != null)
        {
            mInnerContainer.setBackgroundColor(mPanelBgColor);
        }

        if (mPanelHandle != null)
        {
            mPanelHandle.setBaseColor(mPanelBgColor);
        }
    }

    private void toggleAnimation()
    {
        if (mIsOpen == true)
        {
            collapsePanelView();
        } else
        {
            expandPanelViewInternal(true);
        }
    }

    /**
     * Collapse panel view
     */

    public void collapsePanelView()
    {
        if (KidozSDK.isInitialised())
        {
            if (mIsAnimationRunning == false && mIsOpen == true && mContainer != null)
            {
                GenAnimator.closePanelView(mContainer, 200, mInnerContainer, mPanelType, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {
                        GenAnimator.animateHandleClose(mPanelHandle, null);

                        setShowable(false);
                        //mContentItems.clear();
                        //clearPanelContent();

                        onContentDataLoadStarted();
                        mContentLogicLoader.loadContent(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId);
                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        onCollapsePanelAnimationEnded();
                        EventManager.getInstance(getContext()).startEventsSync(getContext(), 250);
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        }
    }

    protected void onCollapsePanelAnimationEnded()
    {

        mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.CLOSED);

        mIsOpen = false;
        mIsAnimationRunning = false;
        if (mIOnPanelViewEventListener != null)
        {
            mIOnPanelViewEventListener.onPanelViewCollapsed();
        }
    }

    /**
     * Expand (Open) Panel view
     */
    public void expandPanelView()
    {
        if (KidozSDK.isInitialised())
        {
            expandPanelViewInternal(true);
        }
    }

    /**
     * Expand (Open) Panel view
     *
     * @param byUserAction if invoked by user action or automatically
     */
    private void expandPanelViewInternal(boolean byUserAction)
    {
        if (mIsAnimationRunning == false && mIsOpen == false)
        {
            // Stop thumb automatic rotation update
            stopThumbChangeCycle();

            if (mIsShowFirstItemThumb)
            {
                if (!mContentItems.isEmpty() && mContentItems.size() > mHandleThumbCurrentShownIndex)
                {
                    mContentItems.add(0, mContentItems.remove(mHandleThumbCurrentShownIndex));
                    setContentAndRefresh(mContentItems);
                }
                mHandleThumbCurrentShownIndex = 0;
            }

            // Send log
            Event event = new Event();
            if (byUserAction)
            {
                event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.MANUAL_OPEN);
            } else
            {
                event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.AUTOMATIC_OPEN);
            }
            event.addParameterToJsonObject(EventParameters.LABEL_PANEL_VIEW_TYPE, mPanelType.ordinal());

            EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId, EventManager.LOG_CRITICAL_LEVEL, event, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.PANEL_VIEW);

            //Refresh the parental lock icon
            boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
            setParentalLocIConkState(isLockActive);

            if (mContainer != null)
            {
                GenAnimator.openPanelView(mContainer, mInnerContainer, mPanelType, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {
                        mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.OPENED);

                        setShowable(true);
                        onExpandPanelAnimationStarted();
                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        mIsOpen = true;
                        mIsAnimationRunning = false;
                        invokeViewAction(mHandleThumbCurrentShownIndex);

                        if (mIOnPanelViewEventListener != null)
                        {
                            mIOnPanelViewEventListener.onPanelViewExpanded();
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {
                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {
                    }
                });
            }
        }
    }

    private void startThumbChangeCycle()
    {
        mHandleThumbCurrentShownIndex = 0;
        mHandleThumbStaticHandler.removeCallbacksAndMessages(null);
        if (mIsShowFirstItemThumb)
        {
            mIsAllowThumbChange = true;
        }
        loadNextHandleThumbImage();
    }

    // Stop thumb automatic rotation update
    private void stopThumbChangeCycle()
    {
        mIsAllowThumbChange = false;
        mHandleThumbStaticHandler.removeCallbacksAndMessages(null);
    }

    protected void onExpandPanelAnimationStarted()
    {
        GenAnimator.animateHandleOpen(mPanelHandle, null);
    }

    /**
     * Set panel view configuration
     *
     * @param panelType      panel view type (Possible values <code> PANEL_TYPE.TOP, PANEL_TYPE.BOTTOM, PANEL_TYPE.LEFT ,PANEL_TYPE.RIGHT </code>
     * @param handlePosition handle position  (Possible values <code> HANDLE_POSITION.START, HANDLE_POSITION.CENTER, HANDLE_POSITION.END </code>
     */
    public void setPanelConfiguration(PANEL_TYPE panelType, HANDLE_POSITION handlePosition)
    {

        if (KidozSDK.isInitialised())
        {
            mPanelType = panelType;
            mHandlePosition = handlePosition;
            mPanelHandle.setPanelType(mPanelType);

            initPanelViewsRules();

            if (mHandlePosition == HANDLE_POSITION.NONE)
            {
                mPanelHandle.setVisibility(View.INVISIBLE);
            } else
            {
                if (mBtnScaleSize != 0)
                {
                    mPanelHandle.setVisibility(View.VISIBLE);
                }
            }
        }
    }

    /**
     * Set panel events listener
     *
     * @param iOnPanelViewEventListener listener
     */
    public void setOnPanelViewEventListener(IOnPanelViewEventListener iOnPanelViewEventListener)
    {
        mIOnPanelViewEventListener = iOnPanelViewEventListener;
    }

    /**
     * Get panel view state
     *
     * @return is panel expanded pr closed
     */
    public boolean getIsPanelViewExpanded()
    {
        return mIsOpen;
    }

    @Override
    protected void onDetachedFromWindow()
    {
        getStaticHandler().removeCallbacksAndMessages(null);
        stopThumbChangeCycle();

        super.onDetachedFromWindow();
    }

    @Override
    protected void onAttachedToWindow()
    {
        super.onAttachedToWindow();

        startThumbChangeCycle();
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility)
    {
        super.onWindowVisibilityChanged(visibility);

        if (KidozSDK.isInitialised())
        {
            if (visibility == View.VISIBLE)
            {
                startThumbChangeCycle();
            } else if (!isInEditMode() && (visibility == View.GONE || visibility == View.INVISIBLE))
            {
                EventManager.getInstance(getContext()).startEventsSync(getContext());
                getStaticHandler().removeCallbacksAndMessages(null);
                stopThumbChangeCycle();
            }
        }
        mAllowClickHandling = true;
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility)
    {
        super.onVisibilityChanged(changedView, visibility);

        if (visibility == View.VISIBLE)
        {
            startThumbChangeCycle();
        } else
        {
            stopThumbChangeCycle();
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus)
    {
        super.onWindowFocusChanged(hasWindowFocus);

        if (hasWindowFocus)
        {
            mAllowClickHandling = true;
        } else
        {
            mAllowClickHandling = false;
        }
    }

    /**
     * Prepare panel handle for view
     */
    private void prepareHandle(final String url)
    {
        // Load proper handle button image for close and open state
        mPanelHandle.loadAssets(AssetUtil.getAssetFile(getContext(), mBtnOpenUrl), AssetUtil.getAssetFile(getContext(), mBtnCloseUrl), new PanelHandle.IonPanelHandlePreparedListener()
        {
            @Override
            public void onPanelPrepared()
            {
                mIsPanelPrepared = true;
                GenAnimator.playGrowAnimation(mPanelHandle, 350, 0, null, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {
                        mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.CLOSED);

                        requestFocus();
                        bringToFront();

                        if (mIsShowFirstItemThumb)
                        {
                            mPanelHandle.getThumbLayerAsset().loadAsset(url, null);
                        }
                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        mIsOpen = false;
                        mIsAnimationRunning = false;
                        if (mIOnPanelViewEventListener != null)
                        {
                            mIOnPanelViewEventListener.onPanelReady();
                        }

                        requestFocus();
                        bringToFront();

                        if (getVisibility() == VISIBLE)
                        {
                            openPanelForDefinedAmountOfTime();
                        }
                        // Start post delayed load and change of item thumb layer
                        startThumbChangeCycle();

                        EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SDK, EventParameters.ACTION_BUTTON_VIEW, EventParameters.LABEL_PANEL_BUTTON_VIEW);
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        });
    }

    /**
     * Prepare panel view
     */
    private void preparePanel()
    {
        mIsOpen = true;
        mIsAnimationRunning = true;
        Utils.setOnGlobalLayoutFinishListener(this, new Utils.OnGlobalLayoutFinishedListener()
        {
            @Override
            public void onLayoutFinished()
            {
                GenAnimator.closePanelView(mContainer, 0, mInnerContainer, mPanelType, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {
                        GenAnimator.animateHandleClose(mPanelHandle, null);
                        requestFocus();
                        bringToFront();
                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        clearPanelContent();
                        onContentDataLoadStarted();
                        mContentLogicLoader.loadContent(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId);
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {
                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {
                    }
                });
            }
        });
    }

    /**
     * Open (Show) the panel for predefined amount of time if needed
     * Used to make user notice that there is a panel and its content
     */
    private void openPanelForDefinedAmountOfTime()
    {
        final long lastLaunchTime = mSharedPreferences.getLong(FIRST_TIME_LAST_LOUNCH_KEY, -1);

        if (mFirstLounchStartDelay >= 0)
        {
            if (getVisibility() == View.VISIBLE)
            {
                getStaticHandler().postDelayed(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        if (mFirstLounchOpenRepeatTimeFarme == -1 ||
                                (lastLaunchTime == -1 || (lastLaunchTime + mFirstLounchOpenRepeatTimeFarme * TIME_MULT_FACTOR) > System.currentTimeMillis()))
                        {
                            expandPanelViewInternal(false);

                            SharedPreferences.Editor editor = mSharedPreferences.edit();
                            editor.putLong(FIRST_TIME_LAST_LOUNCH_KEY, System.currentTimeMillis());
                            editor.apply();

                            if (mFirstLounchOpenPeriod > 0)
                            {
                                getStaticHandler().postDelayed(new Runnable()
                                {
                                    @Override
                                    public void run()
                                    {
                                        collapsePanelView();
                                    }
                                }, (long) (mFirstLounchOpenPeriod * 1000));
                            }
                        }
                    }
                }, (long) (mFirstLounchStartDelay * 1000));
            }
        }
    }

    private void loadNextHandleThumbImage()
    {
        if (mIsShowFirstItemThumb)
        {
            mHandleThumbStaticHandler.postDelayed(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mIsAllowThumbChange)
                    {
                        mHandleThumbCurrentShownIndex++;
                        if (mContentItems != null && !mContentItems.isEmpty() && mHandleThumbCurrentShownIndex < mContentItems.size())
                        {
                            if (mHandleThumbCurrentShownIndex == mContentItems.size() - 1)
                            {
                                mHandleThumbCurrentShownIndex = 0;
                            }
                            final String url = mContentItems.get(mHandleThumbCurrentShownIndex).getThumb();
                            if (url != null)
                            {
                                mPanelHandle.getThumbLayerAsset().loadAsset(url, new AssetView.IOnAssetLoadedListener()
                                {
                                    @Override
                                    public void onAssetLoaded(boolean successful)
                                    {
                                        loadNextHandleThumbImage();
                                    }
                                });
                            }
                        }
                    }
                }
            }, mHandleThumbRefreshRateSec * 1000);
        }
    }

    public static final String BTN_OPEN_URL = "btnOpenedUrl";
    public static final String BTN_CLOSE_URL = "btnClosedUrl";
    public static final String BTN_SCALE_SIZE = "btnScaleSize";
    public static final String BTN_ANIMATION_TYPE = "btnAnimType";
    public static final String PANEL_BG_COLOR = "panelBgClr";
    public static final String LABEL_TEXT = "labelText";
    public static final String LABEL_TEXT_COLOR = "labelColor";
    public static final String STYLE_ID = "style_id";
    public static final String OVERRIDE_USER_PROPERTIES = "overrideUserProperties";
    public static final String FIRST_LAUNCH_STAY_OPEN_PERIOD_SECONDS = "flOpenPeriodSec"; // the timeout to leave the panel open
    public static final String FIRST_LAUNCH_OPEN_START_DELAY_SECONDS = "flOpenStartDelaySec"; // the start delay before opening the panel
    public static final String FIRST_LAUNCH_OPEN_PANEL_EVEY_X_HOURS = "flOpenEveryXhoursTF"; // opens panel every amount of time (hours)
    public static final String LAUNCH_INTERSTITIAL_ON_OPEN = "lounchInterstitialOnOpen";
    public static final String BTN_LOCK_OPEN = "btnUnlockUrl";
    public static final String BTN_LOCK_CLOSED = "btnLockUrl";
    public static final String THUMBNAIL_BG_COLOR = "thumbBgColor";
    public static final String KIDOZ_LOGO_ICON = "kidozIcon";

    public static final String CIH_SHOW_THUMB_IN_HANDLE = "contentItemHandleThumbShow"; // Show content item in the handle
    public static final String CIH_THUMB_SIZE = "contentItemHandleThumbSize"; // Content item  handle thumb relative to handle size
    public static final String CIH_REFRESH_CYCLE_PERIOD_SECONDS = "contentItemHandleRefreshPeriodSec"; // Content item handle thumb refresh rate
    public static final String CIH_BTN_OPEN_HANDLE_OVERLAY_URL = "contentItemHandleBtnOpenUrl"; // Content item handle alternative button closed overlay image
    public static final String CIH_ROUND_CORNERS = "contentItemHandleRoundCornersPx"; // Content item thumb possible rounding of corners

    // Sequential handler
    protected Utils.StaticHandler getStaticHandler()
    {
        if (mStaticHandler == null)
        {
            mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper());
        }
        return mStaticHandler;
    }

    /**
     * Set Automatically show panel on being added to view
     *
     * @param startDelay time in seconds,delay before automatic invocation of panel expand
     * @param showPeriod time in seconds,the period to show the panel before closing it
     * @param showPeriod time in hours ,the period to repeat the first time launch (Used to not open the panel of each "first lounch" every amount of time
     */
    public void setAutoExpandOnStart(float startDelay, float showPeriod, float repeatTimeFrame)
    {
        if (mWidgetProperties != null && mWidgetProperties.optInt(OVERRIDE_USER_PROPERTIES, 0) == 0 ? true : false)
        {
            mFirstLounchStartDelay = startDelay;
            mFirstLounchOpenPeriod = showPeriod;
            mFirstLounchOpenRepeatTimeFarme = repeatTimeFrame;
        }
    }
}
