package com.kidoz.sdk.api.ui_views.flexi_view;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.media.ThumbnailUtils;

import com.squareup.imagelib.Transformation;

/**
 * Created by Eugine on 1/19/2016.
 */
public class CircleTransformation implements Transformation {

    private float mMargin = 0;
    private int mBorder = 0;
    private int mContainerSize = 0;
    private String mBorderColor;
    private String mFillColor;

    public CircleTransformation(int borderWith, String borderColor, String fillColor,int containerSize) {
        mBorder = borderWith;
        mBorderColor = borderColor;
        mContainerSize = containerSize;
        mFillColor = fillColor;
    }

    @Override
    public Bitmap transform(Bitmap source) {
        Bitmap squaredBitmap = ThumbnailUtils.extractThumbnail(source, mContainerSize, mContainerSize);
        source.recycle();

        Bitmap bitmap = Bitmap.createBitmap(squaredBitmap.getWidth(), squaredBitmap.getHeight(), squaredBitmap.getConfig());
        float r = 0;
        if (mBorder != 0) {
            r = (squaredBitmap.getWidth() / 2f) - mBorder / 2;
        }

        //Create border/fill paint
        Paint borderPaint = new Paint();
        try {
            borderPaint.setColor(Color.parseColor(mFillColor));
        } catch (Exception e) {
            borderPaint.setColor(Color.WHITE);
        }
        borderPaint.setStyle(Paint.Style.FILL);
        borderPaint.setAntiAlias(true);
        borderPaint.setStrokeWidth(mBorder);

        Canvas canvas = new Canvas(bitmap);

        //Draw fill
        canvas.drawCircle((squaredBitmap.getWidth()) / 2 - mMargin, (squaredBitmap.getHeight()) / 2 - mMargin, r, borderPaint);

        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(squaredBitmap, BitmapShader.TileMode.CLAMP, BitmapShader.TileMode.CLAMP);
        paint.setShader(shader);
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);

        // Draw image
        canvas.drawCircle((squaredBitmap.getWidth() - mMargin) / 2, (squaredBitmap.getHeight() - mMargin) / 2, r, paint);

        //Draw Border
        if (mBorder != 0) {
            try {
                borderPaint.setColor(Color.parseColor(mBorderColor));
            } catch (Exception e) {
                borderPaint.setColor(Color.WHITE);
            }
            borderPaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle((squaredBitmap.getWidth()) / 2 - mMargin, (squaredBitmap.getHeight()) / 2 - mMargin, r, borderPaint);
        }

        if (squaredBitmap.isRecycled() == false) {
            squaredBitmap.recycle();
        }

        if (source.isRecycled() == false) {
            source.recycle();
        }
        return bitmap;

    }

    @Override
    public String key() {
        return "circleFlexiTransform";
    }
}
