package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.view.View;

/**
 * Created by RonyBrosh on 4/21/2016.
 */
public class ConfigurationView extends View
{
    private final String TAG = ConfigurationView.class.getSimpleName();
    private boolean mHasWindowFocus;
    private int mWindowVisibility;
    private int mVisibility;

    private ConfigurationViewListener mConfigurationViewListener;

    public ConfigurationView(Context context, ConfigurationViewListener configurationViewListener)
    {
        super(context);
        mConfigurationViewListener = configurationViewListener;
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE)
        {
        }
        else
        {
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus)
    {
        super.onWindowFocusChanged(hasWindowFocus);
        mHasWindowFocus = hasWindowFocus;
        checkIsViewCompletelyInvisible();
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility)
    {
        super.onVisibilityChanged(changedView, visibility);
        mVisibility = visibility;
        checkIsViewCompletelyInvisible();
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility)
    {
        super.onWindowVisibilityChanged(visibility);
        mWindowVisibility = visibility;
        checkIsViewCompletelyInvisible();
    }

    private void checkIsViewCompletelyInvisible()
    {
        boolean result = false;
        if (mHasWindowFocus == false && mVisibility == View.INVISIBLE && mWindowVisibility == View.GONE)
        {
            result = true;
        }
        if (mConfigurationViewListener != null)
        {
            mConfigurationViewListener.onIsViewCompletelyInvisible(result);
        }
    }

    public interface ConfigurationViewListener
    {
        void onIsViewCompletelyInvisible(boolean isViewCompletelyInvisible);
    }
}
