package com.kidoz.sdk.api.server_connect;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;

import com.kidoz.sdk.api.general.utils.SDKLogger;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/**
 * {@code BaseConnectionClient} Responsible for making a connection to a remote server via different approach methods SOAP and REST
 */
@SuppressLint("NewApi")
public class BaseConnectionClient
{
    protected static String mPublicherId = null;
    protected static String mSecurityToken = null;

    protected static String MAIN_SERVER_URL = "http://sdk.kidoz.net/api/sdk";
    protected static String KIDOZ_ANALITYCS_SERVER_URL = "http://analytics.kidoz.net/parents/KidozRestMobile.php";
    protected static String SDK_API_URL = "http://sdk-api.kidoz.net/api/";

    public static int getConnectionType(Context context)
    {
        int reuslt = ConnectivityManager.TYPE_WIFI;
        if (context != null)
        {
            ConnectivityManager connManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo nInfo = connManager.getActiveNetworkInfo();
            if (nInfo != null)
            {
                if (nInfo.isAvailable())
                {
                    reuslt = nInfo.getType();
                }
            }
        }
        return reuslt;
    }

    // Main server access Url

    protected final static String TAG = BaseConnectionClient.class.getSimpleName();

    protected enum CONNECTION_TYPE
    {
        POST, GET
    }

    private static OkHttpClient client;
    private static final MediaType JSON = MediaType.parse("application/x-www-form-urlencoded; charset=utf-8");

    /**
     * Initiate http conn ection client
     */
    protected static void initConnectionClient()
    {
        getOkHttpClient();
        initCookieManager();
    }

    public synchronized static OkHttpClient getOkHttpClient()
    {
        if (client == null)
        {
            client = new OkHttpClient.Builder().connectTimeout(10, TimeUnit.SECONDS).writeTimeout(10, TimeUnit.SECONDS).readTimeout(20, TimeUnit.SECONDS).build();
        }
        return client;
    }

    /**
     * Initiate cookie manager
     */
    private static void initCookieManager()
    {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
    }

    /**
     * Make Post connection // Uses MORE preferable HTTP connection library
     *
     * @param url           url
     * @param contentValues http parameters
     * @param requestTag    connection request tag
     */
    public static Call makePostConnection(String url, ContentValues contentValues, String requestTag) throws IOException
    {
        // 'method_name' => 'initSdk',\n  'request_parameters' => '{ "version": "1", "publisher_id": 1, "package_id": 1003249 }',\n  'key' => 'zidok',\n  'hash' => '2343 2c 423x23xd23sd3223',\n)  \n        Call call = null;
        Call result = null;
        if (contentValues != null && contentValues.size() > 0)
        {
            StringBuilder stringBuilder = new StringBuilder();
            Set<String> set = contentValues.keySet();
            Iterator<String> iter = set.iterator();
            if (iter.hasNext())
            {
                String val = iter.next();
                stringBuilder.append(val).append("=").append(contentValues.getAsString(val));
            }
            while (iter.hasNext())
            {
                String val = iter.next();
                stringBuilder.append("&");
                stringBuilder.append(val).append("=").append(contentValues.getAsString(val));
            }
            if (url != null && url.equals("") == false)
            {
                RequestBody body = RequestBody.create(JSON, stringBuilder.toString());
                Request request = new Request.Builder().url(url).post(body).tag(requestTag).build();
                result = client.newCall(request);
            } else
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Invalid Server Url or Request parameters JSON !");
            }
        }
        return result;
    }

    /**
     * Make GET connection
     *
     * @param url           url
     * @param contentValues http parameters
     * @param requestTag    connection request tag
     */
    public static Call makeGetConnection(String url, ContentValues contentValues, String requestTag) throws IOException
    {
        Call call = null;

        StringBuilder sb = new StringBuilder(url);
        if (contentValues != null && contentValues.size() > 0)
        {
            sb.append("?");

            Set<String> set = contentValues.keySet();
            Iterator<String> iter = set.iterator();
            if (iter.hasNext())
            {
                String val = iter.next();
                sb.append(val).append("=").append(Uri.encode(contentValues.getAsString(val)));
            }
            while (iter.hasNext())
            {
                String val = iter.next();
                sb.append("&");
                sb.append(val).append("=").append(Uri.encode(contentValues.getAsString(val)));
            }
        }
        Request request = new Request.Builder().url(sb.toString()).header("Access-Key", mPublicherId + "::" + mSecurityToken).tag(requestTag).build();

        call = client.newCall(request);

        return call;
    }

    /**
     * Cancel current running request connection
     *
     * @param call connection request tag
     */
    private static void cancelRequest(Call call)
    {
        call.cancel();
    }

    /**
     * Get gif image stream
     *
     * @param url        url
     * @param requestTag connection request tag
     */
    public static void getImageStreamAsync(String url, String requestTag, final IOnImageRequestCallback requestCallback)
    {
        Request request = new Request.Builder().url(url).tag(requestTag).build();
        client.newCall(request).enqueue(new Callback()
        {
            @Override
            public void onFailure(Call call, IOException e)
            {

            }

            @Override
            public void onResponse(Call call, Response response) throws IOException
            {
                requestCallback.onImageRecieved(response.body().byteStream());
            }
        });
    }

    /**
     * Get gif image stream
     *
     * @param url        url
     * @param requestTag connection request tag
     */
    public static Call getImageStream(String url, String requestTag) throws IOException
    {
        Request request = new Request.Builder().url(url).tag(requestTag).build();
        return client.newCall(request);
    }

    public static boolean downloadAndSaveFile(String fileURL, File destinationFile)
    {
        boolean result = false;
        try
        {
            SDKLogger.printDebbugLog(TAG, "Downloading file url: " + fileURL);

            Request request = new Request.Builder().url(fileURL).build();
            Response response = client.newCall(request).execute();
            InputStream inputStream = response.body().byteStream();
            OutputStream outputStream = new FileOutputStream(destinationFile);
            byte[] buf = new byte[1024];
            int len;
            while ((len = inputStream.read(buf)) > 0)
            {
                outputStream.write(buf, 0, len);
            }
            outputStream.close();
            inputStream.close();
            result = true;
        } catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, "Error when trying download file: " + ex.getMessage());
        }
        return result;
    }

    public interface IOnImageRequestCallback
    {
        void onImageRecieved(InputStream inputStream) throws IOException;
    }
}

