package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.KidozTopBar;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;

public class WebPlayerView extends RelativeLayout
{

    private static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.25f;

    private KidozWebView mKidozWebView;
    private WebPlayerType mWebPlayerType;
    private IOnRemoveViewRequestListener mRemoveViewRequestListener;

    private LoadingProgressView mLoadingProgressView;

    public WebPlayerView(Context context, WebPlayerType webPlayerType, String widgetType)
    {
        super(context);

        mWebPlayerType = webPlayerType;

        initiateView();
    }

    private void initiateView()
    {

        initWebView();

        if (mWebPlayerType != null && mWebPlayerType == WebPlayerType.EXTERNAL_LINK)
        {
            mKidozWebView.setAlpha(0);
            mLoadingProgressView = new LoadingProgressView(getContext());

            Point point = Utils.getScreenSize(getContext());
            int size = (int) (Math.min(point.x, point.y) * LOADING_PROGRESS_DEFAULT_RATIO);
            RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(size, size);
            prParams.addRule(RelativeLayout.CENTER_IN_PARENT);
            addView(mLoadingProgressView, prParams);
            mLoadingProgressView.startLoadingAnimation();
        }
    }

    private void initWebView()
    {
        mKidozWebView = new KidozWebView(getContext(), mWebPlayerType);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        Point point = Utils.getScreenSize(getContext());
        int paddingTop = (int) (Math.max(point.x, point.y) * KidozTopBar.BACKGROUND_RATIO);
        params.topMargin = paddingTop;
        addView(mKidozWebView, params);

        mKidozWebView.setOnLounchExternalAppFromRedirect(new KidozWebView.IOnLounchExternalAppFromRedirectListener()
        {
            @Override
            public void onLounch()
            {
                if (mRemoveViewRequestListener != null)
                {
                    mRemoveViewRequestListener.onRemoveView();
                }
            }
        });
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
    }

    public void loadWebUrl(String url, String googlePlayAppId)
    {
        mKidozWebView.loadWebUrl(url, googlePlayAppId);
    }

    @Override
    protected void onDetachedFromWindow()
    {
        super.onDetachedFromWindow();

        if (mKidozWebView != null)
        {
            mKidozWebView.stopLoading();
        }
    }

    /**
     * Set on remove view request listener
     *
     * @param listener click listener
     */
    public void setOnRemoveViewRequestListener(IOnRemoveViewRequestListener listener)
    {
        mRemoveViewRequestListener = listener;
    }

    /**
     * Close the view and release inner resources
     */
    public void releaseAndcloseView()
    {
        if (mKidozWebView != null)
        {
            mKidozWebView.stopAndReleaseWebView();
        }

        if (mLoadingProgressView != null)
        {
            mLoadingProgressView.stopLoadingAnimation();
        }
    }

    /**
     * Request remove view listener
     */
    public interface IOnRemoveViewRequestListener
    {
        void onRemoveView();
    }
}
